/*
 * Decompiled with CFR 0.152.
 */
package gw.renderables;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;

public class ElevatedSurfaceImage
extends SurfaceImage {
    public static final String IMAGE_REPEAT_NONE = "TexturedLayer.ImageRepeatNone";
    public static final String IMAGE_REPEAT_X = "TexturedLayer.ImageRepeatX";
    public static final String IMAGE_REPEAT_Y = "TexturedLayer.ImageRepeatY";
    public static final String IMAGE_REPEAT_XY = "TexturedLayer.ImageRepeatXY";
    private final int DENSITY = 256;
    private double elevation = 0.0;
    private String imageRepeat = "TexturedLayer.ImageRepeatNone";
    private Point imageOffset;
    private double imageScale = 1.0;
    private Sector geometrySector;
    private Vec4 referenceCenter;
    private DoubleBuffer vertices;
    private DoubleBuffer texCoords;
    private IntBuffer indices;
    boolean needsUpdate = true;
    boolean floating = true;
    TextureData texdata = null;

    public ElevatedSurfaceImage(Object imageSource, Sector sector) {
        super(imageSource, sector);
    }

    public ElevatedSurfaceImage(Object imageSource, Sector sector, Layer layer) {
        super(imageSource, sector, layer);
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
        this.geometrySector = null;
    }

    public boolean getFloating() {
        return this.floating;
    }

    public void setFloating(boolean f) {
        this.floating = f;
    }

    public void setImageRepeat(String imageRepeat) {
        this.imageRepeat = imageRepeat;
    }

    public String getImageRepeat() {
        return this.imageRepeat;
    }

    public void setImageOffset(Point offset) {
        this.imageOffset = offset;
    }

    public Point getImageOffset() {
        return this.imageOffset;
    }

    public void setImageScale(double scale) {
        this.imageScale = scale;
    }

    public double getImageScale() {
        return this.imageScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(DrawContext dc) {
        if (!this.floating) {
            super.render(dc);
            return;
        }
        if (dc == null) {
            String message = Logging.getMessage((String)"nullValue.DrawContextIsNull");
            Logging.logger().severe(message);
            throw new IllegalStateException(message);
        }
        if (!this.getSector().intersects(dc.getVisibleSector())) {
            return;
        }
        if (this.bind(dc)) {
            Texture texture = dc.getTextureCache().get(this.getImageSource());
            if (texture == null) {
                return;
            }
            GL gl = dc.getGL();
            gl.glPushAttrib(291081);
            try {
                if (!dc.isPickingMode()) {
                    double opacity = this.getLayer() != null ? this.getOpacity() * this.getLayer().getOpacity() : this.getOpacity();
                    gl.glColor4d(1.0, 1.0, 1.0, opacity);
                    gl.glEnable(3042);
                    gl.glBlendFunc(770, 771);
                }
                gl.glPolygonMode(1028, 6914);
                gl.glEnable(2884);
                gl.glCullFace(1029);
                gl.glEnable(2929);
                gl.glDepthFunc(515);
                gl.glEnable(3008);
                gl.glAlphaFunc(516, 0.01f);
                gl.glActiveTexture(33984);
                gl.glEnable(3553);
                gl.glMatrixMode(5890);
                gl.glPushMatrix();
                if (!dc.isPickingMode()) {
                    gl.glTexEnvi(8960, 8704, 8448);
                } else {
                    gl.glTexEnvf(8960, 8704, 34160.0f);
                    gl.glTexEnvf(8960, 34176, 34168.0f);
                    gl.glTexEnvf(8960, 34161, 7681.0f);
                }
                this.applyInternalTransform(dc);
                if (this.imageRepeat.equals(IMAGE_REPEAT_X) || this.imageRepeat.equals(IMAGE_REPEAT_XY)) {
                    texture.setTexParameteri(10242, 10497);
                } else {
                    texture.setTexParameteri(10242, 33069);
                }
                if (this.imageRepeat.equals(IMAGE_REPEAT_Y) || this.imageRepeat.equals(IMAGE_REPEAT_XY)) {
                    texture.setTexParameteri(10243, 10497);
                } else {
                    texture.setTexParameteri(10243, 33069);
                }
                gl.glScaled(1.0 / this.imageScale, 1.0 / this.imageScale, 1.0);
                if (this.imageOffset != null) {
                    gl.glTranslated(-((double)this.imageOffset.x) / (double)texture.getWidth(), -((double)this.imageOffset.y) / (double)texture.getHeight(), 0.0);
                }
                this.renderLayer(dc);
                gl.glActiveTexture(33984);
                gl.glMatrixMode(5890);
                gl.glPopMatrix();
                gl.glDisable(3553);
            }
            finally {
                gl.glPopAttrib();
            }
        }
    }

    private void renderLayer(DrawContext dc) {
        if (!this.getSector().equals((Object)this.geometrySector)) {
            this.buildGeometry(dc);
        }
        GL gl = dc.getGL();
        dc.getView().pushReferenceCenter(dc, this.referenceCenter);
        gl.glPushClientAttrib(2);
        gl.glEnableClientState(32884);
        gl.glVertexPointer(3, 5130, 0, this.vertices.rewind());
        gl.glClientActiveTexture(33984);
        gl.glEnableClientState(32888);
        gl.glTexCoordPointer(2, 5130, 0, this.texCoords.rewind());
        gl.glDrawElements(5, this.indices.limit(), 5125, this.indices.rewind());
        gl.glPopClientAttrib();
        dc.getView().popReferenceCenter(dc);
    }

    private void buildGeometry(DrawContext dc) {
        Globe globe = dc.getGlobe();
        Sector sector = this.getSector();
        LatLon centroid = sector.getCentroid();
        this.geometrySector = sector;
        this.referenceCenter = globe.computePointFromPosition(centroid.getLatitude(), centroid.getLongitude(), 0.0);
        Angle dLat = sector.getDeltaLat().divide(256.0);
        Angle dLon = sector.getDeltaLon().divide(256.0);
        int numVertices = 66049;
        this.vertices = BufferUtil.newDoubleBuffer((int)(numVertices * 3));
        int iv = 0;
        Angle lat = sector.getMinLatitude();
        for (int j = 0; j <= 256; ++j) {
            Angle lon = sector.getMinLongitude();
            for (int i = 0; i <= 256; ++i) {
                Vec4 p = globe.computePointFromPosition(lat, lon, this.elevation);
                this.vertices.put(iv++, p.x - this.referenceCenter.x).put(iv++, p.y - this.referenceCenter.y).put(iv++, p.z - this.referenceCenter.z);
                lon = lon.add(dLon);
            }
            lat = lat.add(dLat);
        }
        if (this.indices == null) {
            this.indices = ElevatedSurfaceImage.getIndices(256);
        }
        if (this.texCoords == null) {
            this.texCoords = ElevatedSurfaceImage.getTextureCoordinates(256);
        }
    }

    private static IntBuffer getIndices(int density) {
        if (density < 1) {
            density = 1;
        }
        int sideSize = density;
        int indexCount = 2 * sideSize * sideSize + 4 * sideSize - 2;
        IntBuffer buffer = BufferUtil.newIntBuffer((int)indexCount);
        int k = 0;
        for (int i = 0; i < sideSize; ++i) {
            int j;
            buffer.put(k);
            if (i > 0) {
                buffer.put(++k);
                buffer.put(k);
            }
            if (i % 2 == 0) {
                buffer.put(++k);
                for (j = 0; j < sideSize; ++j) {
                    buffer.put(k += sideSize);
                    buffer.put(++k);
                }
                continue;
            }
            buffer.put(--k);
            for (j = 0; j < sideSize; ++j) {
                buffer.put(k -= sideSize);
                buffer.put(--k);
            }
        }
        return buffer;
    }

    private static DoubleBuffer getTextureCoordinates(int density) {
        if (density < 1) {
            density = 1;
        }
        int coordCount = (density + 1) * (density + 1);
        DoubleBuffer p = BufferUtil.newDoubleBuffer((int)(2 * coordCount));
        double delta = 1.0 / (double)density;
        int k = 0;
        for (int j = 0; j <= density; ++j) {
            double v = (double)j * delta;
            for (int i = 0; i <= density; ++i) {
                p.put(k++, (double)i * delta);
                p.put(k++, v);
            }
        }
        return p;
    }

    public void refresh() {
        this.needsUpdate = true;
    }

    public boolean bind(DrawContext dc) {
        boolean returnValue = super.bind(dc);
        if (this.needsUpdate) {
            GL gl = dc.getGL();
            gl.glTexParameterf(3553, 10241, 9728.0f);
            gl.glTexParameterf(3553, 10240, 9728.0f);
            if (this.texdata == null) {
                this.texdata = new TextureData(0, 0, false, (BufferedImage)this.getImageSource());
                gl.glTexImage2D(3553, 0, this.texdata.getInternalFormat(), this.texdata.getWidth(), this.texdata.getHeight(), 0, this.texdata.getPixelFormat(), this.texdata.getPixelType(), this.texdata.getBuffer());
            } else {
                gl.glTexSubImage2D(3553, 0, 0, 0, this.texdata.getWidth(), this.texdata.getHeight(), this.texdata.getPixelFormat(), this.texdata.getPixelType(), this.texdata.getBuffer());
            }
            this.needsUpdate = false;
        }
        return returnValue;
    }
}

