/*
 * Decompiled with CFR 0.152.
 */
package gw.examples;

import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLJPanel;
import gov.nasa.worldwind.layers.Layer;
import gw.layers.AnimatedSimpleFeatureLayer;
import gw.layers.LayerFactory;
import gw.util.AnimationFile;
import gw.util.WorldWindUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;

public class AnimationDemo
extends JFrame {
    AnimatedSimpleFeatureLayer animatedLayer;
    Timer timer;
    boolean isInitializing = true;
    private JSlider animationSlider;
    private WorldWindowGLJPanel canvas;
    private JButton flyToButton;
    private JButton playButton;

    public AnimationDemo() throws Exception {
        this.initComponents();
        if (this.canvas.getModel() == null) {
            this.canvas.setModel((Model)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ModelClassName"));
        }
        this.animatedLayer = LayerFactory.fromFile(new File("sampledata/animation/wb_hrus.shp"), new AnimationFile("sampledata/animation/wb_gis.out.nhru"), (WorldWindow)this.canvas);
        this.animatedLayer.setAttrMaxColor(Color.BLUE);
        this.animatedLayer.setPrimaryAttr(this.animatedLayer.getSchema().indexOf("HRU"));
        this.animatedLayer.setAnimationColumn(3);
        this.animatedLayer.redraw();
        this.canvas.getModel().getLayers().add((Layer)this.animatedLayer);
        WorldWindUtils.flyTo(this.animatedLayer.getSector(), (WorldWindow)this.canvas);
        this.animationSlider.setMinimum(0);
        this.animationSlider.setMaximum(this.animatedLayer.getFrameCount() - 1);
        this.animationSlider.setValue(0);
        AnimatedSimpleFeatureLayer layer = this.animatedLayer;
        this.timer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    AnimationDemo.this.animationSlider.setValue(AnimationDemo.this.animationSlider.getValue() + 10);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.isInitializing = false;
    }

    private void initComponents() {
        this.animationSlider = new JSlider();
        this.playButton = new JButton();
        this.flyToButton = new JButton();
        this.canvas = new WorldWindowGLJPanel();
        this.setDefaultCloseOperation(3);
        this.animationSlider.setMajorTickSpacing(200);
        this.animationSlider.setPaintTicks(true);
        this.animationSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AnimationDemo.this.animationSliderChanged(evt);
            }
        });
        this.playButton.setText(">");
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimationDemo.this.playButtonActionPerformed(evt);
            }
        });
        this.flyToButton.setText("Focus");
        this.flyToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimationDemo.this.flyToButtonActionPerformed(evt);
            }
        });
        GroupLayout canvasLayout = new GroupLayout((Container)this.canvas);
        this.canvas.setLayout((LayoutManager)canvasLayout);
        canvasLayout.setHorizontalGroup((GroupLayout.Group)canvasLayout.createParallelGroup(1).add(0, 445, Short.MAX_VALUE));
        canvasLayout.setVerticalGroup((GroupLayout.Group)canvasLayout.createParallelGroup(1).add(0, 284, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.playButton, -2, 45, -2).add(10, 10, 10).add((Component)this.animationSlider, -1, 307, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.flyToButton).add(6, 6, 6)).add((Component)this.canvas, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.canvas, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.flyToButton).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.playButton).addContainerGap()).add(2, (Component)this.animationSlider, -1, -1, Short.MAX_VALUE))));
        this.pack();
    }

    private void animationSliderChanged(ChangeEvent evt) {
        if (this.isInitializing) {
            return;
        }
        try {
            this.animatedLayer.setFrame(this.animationSlider.getValue());
            this.animatedLayer.redraw();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.canvas.redrawNow();
    }

    private void flyToButtonActionPerformed(ActionEvent evt) {
        try {
            WorldWindUtils.flyTo(this.animatedLayer.getSector(), (WorldWindow)this.canvas);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playButtonActionPerformed(ActionEvent evt) {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.playButton.setText(">");
        } else {
            this.timer.start();
            this.playButton.setText("||");
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new AnimationDemo().setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

