/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.arcgrid;

import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.gce.arcgrid.ArcGridFormat;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;

public final class ArcGridFormatFactory
implements GridFormatFactorySpi {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.gce.arcgrid");

    public boolean isAvailable() {
        boolean available = true;
        try {
            Class.forName("javax.media.jai.JAI");
            Class.forName("com.sun.media.jai.operator.ImageReadDescriptor");
            Class.forName("it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageMetadata");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("ArcGridFormatFactory is availaible.");
            }
        }
        catch (ClassNotFoundException cnf) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("ArcGridFormatFactory is not availaible.");
            }
            available = false;
        }
        return available;
    }

    public Format createFormat() {
        return new ArcGridFormat();
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

