/*
 * Decompiled with CFR 0.152.
 */
package ngmf.util;

import java.util.Iterator;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import ngmf.Compound;

public class Runner {
    public static void sequential(Iterator<Compound> c) throws Exception {
        for (Compound compound : Runner.it(c)) {
            compound.execute();
        }
    }

    public static void parallel1(Iterator<Compound> comp) throws Exception {
        Runner.parallel1(comp, Runtime.getRuntime().availableProcessors() + 1);
    }

    public static void parallel1(Iterator<Compound> comp, int numproc) throws Exception {
        if (numproc < 1) {
            throw new IllegalArgumentException("numproc");
        }
        int count = 0;
        for (Compound c : Runner.it(comp)) {
            ++count;
        }
        if (count == 0) {
            throw new IllegalArgumentException("comp");
        }
        final CountDownLatch latch = new CountDownLatch(count);
        final ExecutorService e = Executors.newFixedThreadPool(numproc);
        for (final Compound c : Runner.it(comp)) {
            e.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        c.execute();
                    }
                    catch (Throwable E) {
                        e.shutdownNow();
                    }
                    latch.countDown();
                }
            });
        }
        latch.await();
        e.shutdown();
    }

    public static void parallel2(Iterator<Compound> comp, int numproc) throws Exception {
    }

    public static final Iterable<Compound> it(final Iterator<Compound> i) {
        return new Iterable<Compound>(){

            @Override
            public Iterator<Compound> iterator() {
                return i;
            }
        };
    }

    public static class ThreadExec {
        int activeThreads = 0;
        ExecutorService e;
        Stack<Compound> it;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parallel(Stack<Compound> it) {
            int proc = Runtime.getRuntime().availableProcessors() + 1;
            this.e = Executors.newFixedThreadPool(proc);
            ThreadExec threadExec = this;
            synchronized (threadExec) {
                this.it = it;
            }
            for (int i = 0; i < proc; ++i) {
                ThreadExec threadExec2 = this;
                synchronized (threadExec2) {
                    if (it.isEmpty()) {
                        break;
                    }
                    this.e.submit(new ComputeThread1(it.pop()));
                    continue;
                }
            }
            try {
                ThreadExec i = this;
                synchronized (i) {
                    this.wait();
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            finally {
                this.e.shutdown();
            }
        }

        private class ComputeThread1
        implements Runnable {
            Compound job;

            ComputeThread1(Compound job) {
                this.job = job;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ThreadExec threadExec = ThreadExec.this;
                synchronized (threadExec) {
                    ++ThreadExec.this.activeThreads;
                }
                try {
                    this.job.execute();
                }
                catch (Exception ex) {
                    Logger.getLogger(Runner.class.getName()).log(Level.SEVERE, null, ex);
                }
                threadExec = ThreadExec.this;
                synchronized (threadExec) {
                    if (!ThreadExec.this.it.isEmpty()) {
                        ThreadExec.this.e.submit(new ComputeThread1(ThreadExec.this.it.pop()));
                    }
                    if (--ThreadExec.this.activeThreads == 0) {
                        ThreadExec.this.notifyAll();
                    }
                }
            }
        }
    }
}

