/*
 * Decompiled with CFR 0.152.
 */
package ngmf.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import ngmf.Notification;
import ngmf.ann.Range;
import ngmf.ann.Unit;

public class Listeners {

    public static class Logging
    implements Notification.Listener {
        Logger log;
        Level level;

        public Logging(Logger log, Level level) {
            this.log = log;
            this.level = level;
        }

        @Override
        public void notifyExec(Notification.Event E) throws InterruptedException {
            this.log.log(this.level, (Object)((Object)E.getType()) + " " + E.getComponent() + " " + E.getAccess() + " " + E.getValue());
        }
    }

    public static class UnitConverter
    implements Notification.Listener {
        Map<Object, String> m = new HashMap<Object, String>();

        @Override
        public void notifyExec(Notification.Event E) throws InterruptedException {
            Unit inUnit;
            String out;
            if (E.getType() == Notification.Type.OUT) {
                Unit outUnit = E.getAccess().getField().getAnnotation(Unit.class);
                if (outUnit != null) {
                    this.m.put(E.getValue(), outUnit.value());
                }
            } else if (E.getType() == Notification.Type.IN && (out = this.m.get(E.getValue())) != null && (inUnit = E.getAccess().getField().getAnnotation(Unit.class)) != null) {
                this.convert(out, inUnit.value(), E.getValue());
            }
        }

        private void convert(String out, String in, Object value) {
        }
    }

    public static class NullCheck
    implements Notification.Listener {
        @Override
        public void notifyExec(Notification.Event E) throws InterruptedException {
            if ((E.getType() == Notification.Type.IN || E.getType() == Notification.Type.OUT) && E.getValue() == null) {
                System.out.println("Null : " + E.getAccess().getField().getName() + " in " + E.getComponent());
            }
        }
    }

    public static class RangeCheck
    implements Notification.Listener {
        @Override
        public void notifyExec(Notification.Event E) throws InterruptedException {
            Range range;
            if (!(E.getType() != Notification.Type.IN && E.getType() != Notification.Type.OUT || !(E.getValue() instanceof Number) && E.getValue() == null || (range = E.getAccess().getField().getAnnotation(Range.class)) == null)) {
                Number v = (Number)E.getValue();
                if (v != null) {
                    if (range.min() > v.doubleValue() || range.max() < v.doubleValue()) {
                        System.out.println(v + " not within expected range " + range.min() + "..." + range.max() + " in " + E.getComponent() + ")");
                    }
                } else {
                    System.out.println("Null value");
                }
            }
        }
    }
}

