/*
 * Decompiled with CFR 0.152.
 */
package worldwind.kml;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.IconRenderer;
import gov.nasa.worldwind.render.UserFacingIcon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;
import worldwind.kml.model.KMLColor;
import worldwind.kml.model.KMLCoord;
import worldwind.kml.model.KMLFile;
import worldwind.kml.model.KMLFolder;
import worldwind.kml.model.KMLGraphic;
import worldwind.kml.model.KMLLineString;
import worldwind.kml.model.KMLObject;
import worldwind.kml.model.KMLPlacemark;
import worldwind.kml.model.KMLPoint;
import worldwind.kml.model.KMLPolygon;
import worldwind.kml.model.KMLStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KML3dLayer
extends AbstractLayer {
    KMLFile kmlFile;
    int count = 0;
    double simplificationFactor = 0.1;
    IconRenderer iconRenderer = new IconRenderer();
    Map pointCache = new HashMap();
    Map<KMLPolygon, PolyCacheItem> polyCache = new HashMap<KMLPolygon, PolyCacheItem>();
    static final int HEIGHT_ABSOULTE = 0;
    static final int HEIGHT_RELATIVE = 1;
    static final int HEIGHT_TESS = 2;
    int polys = 0;
    int cachedPolys = 0;

    public KML3dLayer(KMLFile kMLFile) {
        this.kmlFile = kMLFile;
    }

    protected void doRender(DrawContext drawContext) {
        double d = (double)drawContext.getDrawableWidth() / drawContext.getVisibleSector().getDeltaLonDegrees();
        this.polys = 0;
        this.cachedPolys = 0;
        KMLFolder kMLFolder = this.kmlFile.getRootFolder();
        this.paintKMLFolder(drawContext, kMLFolder);
    }

    private void paintKMLFolder(DrawContext drawContext, KMLFolder kMLFolder) {
        for (KMLObject object : kMLFolder.getObjects()) {
            KMLPlacemark kMLPlacemark;
            KMLGraphic kMLGraphic;
            if (!(object instanceof KMLPlacemark) || (kMLGraphic = (kMLPlacemark = (KMLPlacemark)object).getGraphic()) == null || !kMLGraphic.getSector().intersects(drawContext.getVisibleSector())) continue;
            if (kMLGraphic instanceof KMLLineString) {
                this.paintLineString(drawContext, (KMLLineString)kMLGraphic);
                continue;
            }
            if (kMLGraphic instanceof KMLPoint) {
                this.paintPoint(drawContext, (KMLPoint)kMLGraphic);
                continue;
            }
            if (!(kMLGraphic instanceof KMLPolygon)) continue;
            this.paintPoly(drawContext, kMLPlacemark.getStyle(), (KMLPolygon)kMLGraphic);
        }
        for (KMLFolder kMLFolder2 : kMLFolder.getChildFolders()) {
            this.paintKMLFolder(drawContext, kMLFolder2);
        }
    }

    private void paintPoly(DrawContext drawContext, KMLStyle kMLStyle, KMLPolygon kMLPolygon) {
        double d = this.calcScaleForSector(drawContext, kMLPolygon.getSector());
        if (d < 0.5) {
            return;
        }
        ++this.polys;
        PolyCacheItem polyCacheItem = this.polyCache.get(kMLPolygon);
        if (polyCacheItem != null && !polyCacheItem.fullScale && (d > polyCacheItem.scale * 3.0 || d < polyCacheItem.scale / 3.0)) {
            this.polyCache.remove(kMLPolygon);
            drawContext.getGL().glDeleteLists(polyCacheItem.displayList, 1);
            polyCacheItem = null;
        }
        if (polyCacheItem == null) {
            polyCacheItem = new PolyCacheItem();
            polyCacheItem.scale = d;
            int n = drawContext.getGL().glGenLists(1);
            drawContext.getGL().glNewList(n, 4864);
            polyCacheItem.fullScale = this.doPaintPoly(drawContext, kMLStyle, kMLPolygon);
            drawContext.getGL().glEndList();
            polyCacheItem.displayList = n;
            this.polyCache.put(kMLPolygon, polyCacheItem);
        } else {
            ++this.cachedPolys;
        }
        drawContext.getGL().glCallList(polyCacheItem.displayList);
    }

    private boolean doPaintPoly(DrawContext drawContext, KMLStyle kMLStyle, KMLPolygon kMLPolygon) {
        Vec4 vec4;
        Vec4 vec42;
        int n;
        Object object;
        Vec4 vec43;
        Object object2;
        boolean bl;
        List<KMLCoord> list = kMLPolygon.getOuter();
        List<Vec4> list2 = this.getTransformedPoints(drawContext, kMLPolygon, list, 25.0, 1, false);
        List<Vec4> list3 = this.getTransformedPoints(drawContext, kMLPolygon, list, -10.0, 2, false);
        List<Vec4> list4 = null;
        List<Vec4> list5 = null;
        boolean bl2 = bl = list.size() == list2.size();
        if (kMLPolygon.getInner() != null) {
            object2 = kMLPolygon.getInner();
            list4 = this.getTransformedPoints(drawContext, kMLPolygon, (List<KMLCoord>)object2, 25.0, 1, false);
            list5 = this.getTransformedPoints(drawContext, kMLPolygon, (List<KMLCoord>)object2, -10.0, 2, false);
        }
        object2 = null;
        if (kMLStyle != null) {
            object2 = (KMLColor)kMLStyle.getPolyStyle("color");
        }
        if (object2 == null) {
            object2 = new KMLColor();
        }
        boolean bl3 = true;
        this.begin(drawContext);
        float[] fArray = new float[]{((KMLColor)object2).red, ((KMLColor)object2).green, ((KMLColor)object2).blue, ((KMLColor)object2).alpha};
        float[] fArray2 = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        drawContext.getGL().glMaterialfv(1028, 4610, fArray2, 0);
        drawContext.getGL().glMaterialfv(1028, 4609, fArray, 0);
        drawContext.getGL().glMaterialfv(1028, 4608, fArray, 0);
        drawContext.getGL().glMaterialf(1028, 5633, 50.0f);
        drawContext.getGL().glMaterialfv(1028, 5632, fArray, 0);
        GLUtessellator gLUtessellator = drawContext.getGLU().gluNewTess();
        PloygonTessCallback ploygonTessCallback = new PloygonTessCallback(drawContext);
        drawContext.getGLU().gluTessCallback(gLUtessellator, 100101, (GLUtessellatorCallback)ploygonTessCallback);
        drawContext.getGLU().gluTessCallback(gLUtessellator, 100100, (GLUtessellatorCallback)ploygonTessCallback);
        drawContext.getGLU().gluTessCallback(gLUtessellator, 100102, (GLUtessellatorCallback)ploygonTessCallback);
        drawContext.getGLU().gluTessCallback(gLUtessellator, 100103, (GLUtessellatorCallback)ploygonTessCallback);
        drawContext.getGL().glCullFace(1029);
        drawContext.getGL().glEnable(3042);
        drawContext.getGL().glBlendFunc(770, 771);
        drawContext.getGL().glEnable(2881);
        if (list2.size() > 2) {
            Vec4 vec44 = list2.get(1).subtract3(list2.get(0)).normalize3();
            vec43 = list2.get(2).subtract3(list2.get(0)).normalize3();
            object = vec44.cross3(vec43).normalize3();
            drawContext.getGL().glNormal3d(object.x, object.y, object.z);
        }
        drawContext.getGLU().gluTessBeginPolygon(gLUtessellator, null);
        drawContext.getGLU().gluTessBeginContour(gLUtessellator);
        for (n = 0; n < list2.size(); ++n) {
            vec43 = list2.get(n);
            object = vec43.toArray3(new double[3], 0);
            drawContext.getGLU().gluTessVertex(gLUtessellator, object, 0, object);
        }
        drawContext.getGLU().gluTessEndContour(gLUtessellator);
        if (list4 != null) {
            drawContext.getGLU().gluTessBeginContour(gLUtessellator);
            for (n = 0; n < list4.size(); ++n) {
                vec43 = list4.get(n);
                object = vec43.toArray3(new double[3], 0);
                drawContext.getGLU().gluTessVertex(gLUtessellator, object, 0, object);
            }
            drawContext.getGLU().gluTessEndContour(gLUtessellator);
        }
        drawContext.getGLU().gluTessEndPolygon(gLUtessellator);
        for (n = 0; n < list2.size(); ++n) {
            drawContext.getGL().glBegin(9);
            vec43 = list2.get(n);
            object = list2.get((n + 1) % list2.size());
            vec42 = list3.get((n + 1) % list3.size());
            vec4 = list3.get(n);
            Vec4 vec45 = object.subtract3(vec43).normalize3();
            Vec4 vec46 = vec42.subtract3(vec43).normalize3();
            Vec4 vec47 = vec46.cross3(vec45).normalize3();
            drawContext.getGL().glNormal3d(vec47.x, vec47.y, vec47.z);
            drawContext.getGL().glVertex3d(vec43.x, vec43.y, vec43.z);
            drawContext.getGL().glVertex3d(object.x, object.y, object.z);
            drawContext.getGL().glVertex3d(vec42.x, vec42.y, vec42.z);
            drawContext.getGL().glVertex3d(vec4.x, vec4.y, vec4.z);
            drawContext.getGL().glEnd();
        }
        if (list4 != null) {
            for (n = 0; n < list4.size(); ++n) {
                drawContext.getGL().glBegin(9);
                vec43 = list4.get(n);
                object = list4.get((n + 1) % list4.size());
                vec42 = list5.get((n + 1) % list5.size());
                vec4 = list5.get(n);
                drawContext.getGL().glVertex3d(vec43.x, vec43.y, vec43.z);
                drawContext.getGL().glVertex3d(object.x, object.y, object.z);
                drawContext.getGL().glVertex3d(vec42.x, vec42.y, vec42.z);
                drawContext.getGL().glVertex3d(vec4.x, vec4.y, vec4.z);
                drawContext.getGL().glEnd();
            }
        }
        drawContext.getGL().glDisable(3042);
        drawContext.getGL().glDisable(2881);
        if (bl3) {
            drawContext.getGL().glColor3f(1.0f, 1.0f, 1.0f);
            drawContext.getGL().glLineWidth(1.5f);
            drawContext.getGL().glBegin(1);
            drawContext.getGL().glEnable(2848);
            for (n = 0; n < list2.size(); ++n) {
                vec43 = list2.get(n);
                object = list2.get((n + 1) % list2.size());
                vec42 = list3.get(n);
                drawContext.getGL().glVertex3d(vec43.x, vec43.y, vec43.z);
                drawContext.getGL().glVertex3d(object.x, object.y, object.z);
                drawContext.getGL().glVertex3d(vec43.x, vec43.y, vec43.z);
                drawContext.getGL().glVertex3d(vec42.x, vec42.y, vec42.z);
            }
            if (list4 != null) {
                for (n = 0; n < list4.size(); ++n) {
                    vec43 = list4.get(n);
                    object = list4.get((n + 1) % list4.size());
                    vec42 = list5.get(n);
                    drawContext.getGL().glVertex3d(vec43.x, vec43.y, vec43.z);
                    drawContext.getGL().glVertex3d(object.x, object.y, object.z);
                    drawContext.getGL().glVertex3d(vec43.x, vec43.y, vec43.z);
                    drawContext.getGL().glVertex3d(vec42.x, vec42.y, vec42.z);
                }
            }
            drawContext.getGL().glEnd();
            drawContext.getGL().glDisable(2848);
        }
        drawContext.getGL().glEnable(2896);
        this.end(drawContext);
        return bl;
    }

    private void paintPoint(DrawContext drawContext, KMLPoint kMLPoint) {
        UserFacingIcon userFacingIcon = new UserFacingIcon("Thumbtack.png", new Position(Angle.fromDegrees((double)kMLPoint.getCoord().getLat()), Angle.fromDegrees((double)kMLPoint.getCoord().getLon()), 0.0));
        ArrayList<UserFacingIcon> arrayList = new ArrayList<UserFacingIcon>();
        arrayList.add(userFacingIcon);
        this.iconRenderer.render(drawContext, arrayList);
    }

    private double calcScaleForSector(DrawContext drawContext, Sector sector) {
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        int[] nArray = new int[4];
        Vec4 vec4 = this.computeSurfacePoint(drawContext, sector.getMinLatitude(), sector.getMinLongitude(), 0.0);
        Vec4 vec42 = this.computeSurfacePoint(drawContext, sector.getMinLatitude(), sector.getMaxLongitude(), 0.0);
        Vec4 vec43 = this.computeSurfacePoint(drawContext, sector.getMaxLatitude(), sector.getMinLongitude(), 0.0);
        Vec4 vec44 = this.computeSurfacePoint(drawContext, sector.getMaxLatitude(), sector.getMaxLongitude(), 0.0);
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[4];
        double[] dArray5 = new double[4];
        double[] dArray6 = new double[4];
        drawContext.getGL().glGetDoublev(2982, dArray, 0);
        drawContext.getGL().glGetDoublev(2983, dArray2, 0);
        drawContext.getGL().glGetIntegerv(2978, nArray, 0);
        drawContext.getGLU().gluProject(vec4.x, vec4.y, vec4.z, dArray, 0, dArray2, 0, nArray, 0, dArray3, 0);
        drawContext.getGLU().gluProject(vec42.x, vec42.y, vec42.z, dArray, 0, dArray2, 0, nArray, 0, dArray4, 0);
        drawContext.getGLU().gluProject(vec43.x, vec43.y, vec43.z, dArray, 0, dArray2, 0, nArray, 0, dArray5, 0);
        drawContext.getGLU().gluProject(vec44.x, vec44.y, vec44.z, dArray, 0, dArray2, 0, nArray, 0, dArray6, 0);
        double d = dArray3[0];
        double d2 = dArray3[1];
        double d3 = dArray4[0];
        double d4 = dArray4[1];
        double d5 = dArray5[0];
        double d6 = dArray5[1];
        double d7 = dArray6[0];
        double d8 = dArray6[1];
        double d9 = Math.sqrt((d - d7) * (d - d7) + (d2 - d8) * (d2 - d8));
        double d10 = Math.sqrt((d3 - d5) * (d3 - d5) + (d4 - d6) * (d4 - d6));
        return Math.max(d9, d10);
    }

    private double calcScaleAtPoint(DrawContext drawContext, Vec4 vec4) {
        double[] dArray = new double[16];
        double[] dArray2 = new double[16];
        int[] nArray = new int[4];
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[4];
        double[] dArray5 = new double[4];
        double[] dArray6 = new double[4];
        drawContext.getGL().glGetDoublev(2982, dArray, 0);
        drawContext.getGL().glGetDoublev(2983, dArray2, 0);
        drawContext.getGL().glGetIntegerv(2978, nArray, 0);
        drawContext.getGLU().gluProject(vec4.x, vec4.y, vec4.z, dArray, 0, dArray2, 0, nArray, 0, dArray3, 0);
        drawContext.getGLU().gluProject(vec4.x + 1000.0, vec4.y, vec4.z, dArray, 0, dArray2, 0, nArray, 0, dArray4, 0);
        drawContext.getGLU().gluProject(vec4.x, vec4.y + 1000.0, vec4.z, dArray, 0, dArray2, 0, nArray, 0, dArray5, 0);
        drawContext.getGLU().gluProject(vec4.x, vec4.y, vec4.z + 1000.0, dArray, 0, dArray2, 0, nArray, 0, dArray6, 0);
        double d = dArray3[0];
        double d2 = dArray3[1];
        double d3 = dArray4[0];
        double d4 = dArray4[1];
        double d5 = dArray5[0];
        double d6 = dArray5[1];
        double d7 = dArray6[0];
        double d8 = dArray6[1];
        double d9 = Math.sqrt((d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2));
        double d10 = Math.sqrt((d5 - d) * (d5 - d) + (d6 - d2) * (d6 - d2));
        double d11 = Math.sqrt((d7 - d) * (d7 - d) + (d8 - d2) * (d8 - d2));
        return Math.max(d9, Math.max(d10, d11));
    }

    private void paintLineString(DrawContext drawContext, KMLLineString kMLLineString) {
        List<KMLCoord> list = kMLLineString.getCoords();
        int n = 1;
        if (kMLLineString.isAbsolute()) {
            n = 0;
        }
        List<Vec4> list2 = this.getTransformedPoints(drawContext, kMLLineString, list, 10.0, n, kMLLineString.isTessellate());
        this.begin(drawContext);
        drawContext.getGL().glLineWidth(3.0f);
        drawContext.getGL().glDisable(2896);
        drawContext.getGL().glColor3f(1.0f, 0.0f, 0.0f);
        drawContext.getGL().glBegin(1);
        Vec4 vec4 = list2.get(0);
        for (int i = 1; i < list2.size(); ++i) {
            Vec4 vec42 = list2.get(i);
            drawContext.getGL().glVertex3d(vec4.x, vec4.y, vec4.z);
            drawContext.getGL().glVertex3d(vec42.x, vec42.y, vec42.z);
            vec4 = vec42;
        }
        drawContext.getGL().glEnd();
        drawContext.getGL().glEnable(2896);
        this.end(drawContext);
    }

    private List<Vec4> getTransformedPoints(DrawContext drawContext, Object object, List<KMLCoord> list, double d, int n, boolean bl) {
        double d2 = (double)drawContext.getDrawableWidth() / drawContext.getVisibleSector().getDeltaLonDegrees();
        double d3 = this.simplificationFactor / d2;
        ArrayList<Vec4> arrayList = null;
        arrayList = new ArrayList<Vec4>();
        KMLCoord kMLCoord = null;
        for (int i = 0; i < list.size(); ++i) {
            double d4 = -1.0;
            if (kMLCoord != null && (d4 = kMLCoord.dist(list.get(i))) < d3 && i < list.size() - 1) continue;
            if (bl && d4 > d3 * 2.0) {
                double d5 = d4 / (d3 * 2.0);
                double d6 = (kMLCoord.getLon() - list.get(i).getLon()) / d5;
                double d7 = (kMLCoord.getLat() - list.get(i).getLat()) / d5;
                double d8 = (kMLCoord.getHeight() - list.get(i).getHeight()) / d5;
                for (double d9 = 1.0; d9 < d5; d9 += 1.0) {
                    KMLCoord kMLCoord2 = new KMLCoord(kMLCoord.getLon() - d6 * d9, kMLCoord.getLat() - d7 * d9, kMLCoord.getHeight() - d8 * d9);
                    this.addComputedPoint(drawContext, kMLCoord2, n, d, arrayList);
                }
            }
            this.addComputedPoint(drawContext, list.get(i), n, d, arrayList);
            kMLCoord = list.get(i);
        }
        return arrayList;
    }

    private void addComputedPoint(DrawContext drawContext, KMLCoord kMLCoord, int n, double d, List<Vec4> list) {
        if (n == 0) {
            list.add(this.computePointFromPosition(drawContext, kMLCoord));
        } else if (n == 1) {
            list.add(this.computeSurfacePoint(drawContext, kMLCoord, Math.max(kMLCoord.getHeight(), 1.0)));
        } else {
            list.add(this.computeSurfacePoint(drawContext, kMLCoord, d));
        }
    }

    private Vec4 computeSurfacePoint(DrawContext drawContext, KMLCoord kMLCoord, double d) {
        Angle angle = Angle.fromDegrees((double)kMLCoord.getLat());
        Angle angle2 = Angle.fromDegrees((double)kMLCoord.getLon());
        Vec4 vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(angle, angle2, d);
        if (vec4 != null) {
            return vec4;
        }
        return drawContext.getGlobe().computePointFromPosition(angle, angle2, d);
    }

    private Vec4 computeSurfacePoint(DrawContext drawContext, Angle angle, Angle angle2, double d) {
        Vec4 vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(angle, angle2, d);
        if (vec4 != null) {
            return vec4;
        }
        return drawContext.getGlobe().computePointFromPosition(angle, angle2, d);
    }

    private Vec4 computePointFromPosition(DrawContext drawContext, KMLCoord kMLCoord) {
        Angle angle = Angle.fromDegrees((double)kMLCoord.getLat());
        Angle angle2 = Angle.fromDegrees((double)kMLCoord.getLon());
        return drawContext.getGlobe().computePointFromPosition(angle, angle2, kMLCoord.getHeight());
    }

    protected void begin(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        Vec4 vec4 = drawContext.getView().getEyePoint();
        gL.glPushAttrib(274497);
        gL.glDisable(3553);
        float[] fArray = new float[]{(float)(vec4.x * 2.0), (float)(vec4.y / 2.0), (float)vec4.z, 0.0f};
        float[] fArray2 = new float[]{0.4f, 0.4f, 0.4f, 1.0f};
        float[] fArray3 = new float[]{0.3f, 0.3f, 0.3f, 1.0f};
        float[] fArray4 = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
        gL.glDisable(2903);
        gL.glLightfv(16385, 4611, fArray, 0);
        gL.glLightfv(16385, 4609, fArray2, 0);
        gL.glLightfv(16385, 4608, fArray3, 0);
        gL.glLightfv(16385, 4610, fArray4, 0);
        gL.glDisable(16384);
        gL.glEnable(16385);
        gL.glEnable(2896);
        gL.glEnable(2977);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
    }

    protected void end(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glDisable(16385);
        gL.glEnable(16384);
        gL.glDisable(2896);
        gL.glDisable(2977);
        gL.glPopAttrib();
    }

    static class PloygonTessCallback
    extends GLUtessellatorCallbackAdapter {
        DrawContext dc;

        PloygonTessCallback(DrawContext drawContext) {
            this.dc = drawContext;
        }

        public void begin(int n) {
            this.dc.getGL().glBegin(n);
        }

        public void end() {
            this.dc.getGL().glEnd();
        }

        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            double[] dArray2 = new double[6];
            dArray2[0] = dArray[0];
            dArray2[1] = dArray[1];
            dArray2[2] = dArray[2];
            for (int i = 3; i < 6; ++i) {
                dArray2[i] = (double)fArray[0] * ((double[])objectArray[0])[i] + (double)fArray[1] * ((double[])objectArray[1])[i] + (double)fArray[2] * ((double[])objectArray[2])[i] + (double)fArray[3] * ((double[])objectArray[3])[i];
            }
            objectArray2[0] = dArray2;
        }

        public void vertex(Object object) {
            double[] dArray = (double[])object;
            this.dc.getGL().glVertex3dv(dArray, 0);
        }

        public void error(int n) {
            System.out.println("Error: " + n);
        }
    }

    public static class PolyCacheItem {
        int displayList;
        double scale;
        boolean fullScale = false;
    }

    static class CacheWrapper {
        double ppd;
        Object val;

        CacheWrapper() {
        }
    }
}

