/*
 * Decompiled with CFR 0.152.
 */
package groovy.xml.dom;

import groovy.lang.GroovyRuntimeException;
import groovy.xml.QName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMCategory {
    private static boolean trimWhitespace = true;

    public static Object get(Element element, String elementName) {
        return DOMCategory.xgetAt(element, elementName);
    }

    public static Object get(NodeList nodeList, String elementName) {
        if (nodeList instanceof Element) {
            return DOMCategory.xgetAt((Element)((Object)nodeList), elementName);
        }
        return DOMCategory.xgetAt(nodeList, elementName);
    }

    public static Object get(NamedNodeMap nodeMap, String elementName) {
        return DOMCategory.xgetAt(nodeMap, elementName);
    }

    private static Object xgetAt(Element element, String elementName) {
        if ("..".equals(elementName)) {
            return DOMCategory.parent(element);
        }
        if ("**".equals(elementName)) {
            return DOMCategory.depthFirst(element);
        }
        if (elementName.startsWith("@")) {
            return element.getAttribute(elementName.substring(1));
        }
        return DOMCategory.getChildElements(element, elementName);
    }

    private static Object xgetAt(NodeList nodeList, String elementName) {
        ArrayList results = new ArrayList();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            DOMCategory.addResult(results, DOMCategory.get((Element)node, elementName));
        }
        if (elementName.startsWith("@")) {
            return results;
        }
        return new NodeListsHolder(results);
    }

    public static NamedNodeMap attributes(Element element) {
        return element.getAttributes();
    }

    private static String xgetAt(NamedNodeMap namedNodeMap, String elementName) {
        Attr a = (Attr)namedNodeMap.getNamedItem(elementName);
        return a.getValue();
    }

    public static int size(NamedNodeMap namedNodeMap) {
        return namedNodeMap.getLength();
    }

    public static Node getAt(Node o, int i) {
        return DOMCategory.nodeGetAt(o, i);
    }

    public static Node getAt(NodeListsHolder o, int i) {
        return DOMCategory.nodeGetAt(o, i);
    }

    public static Node getAt(NodesHolder o, int i) {
        return DOMCategory.nodeGetAt(o, i);
    }

    private static Node nodeGetAt(Object o, int i) {
        Node n;
        if (o instanceof Element && (n = DOMCategory.xgetAt((Element)o, i)) != null) {
            return n;
        }
        if (o instanceof NodeList) {
            return DOMCategory.xgetAt((NodeList)o, i);
        }
        return null;
    }

    private static Node xgetAt(Element element, int i) {
        if (DOMCategory.hasChildElements(element, "*")) {
            NodeList nodeList = DOMCategory.getChildElements(element, "*");
            return nodeList.item(i);
        }
        return null;
    }

    private static Node xgetAt(NodeList nodeList, int i) {
        if (i >= 0 && i < nodeList.getLength()) {
            return nodeList.item(i);
        }
        return null;
    }

    public static String name(Element element) {
        return element.getNodeName();
    }

    public static Node parent(Node node) {
        return node.getParentNode();
    }

    public static String text(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        if (node.hasChildNodes()) {
            return DOMCategory.text(node.getChildNodes());
        }
        return "";
    }

    public static String text(NodeList nodeList) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            sb.append(DOMCategory.text(nodeList.item(i)));
        }
        return sb.toString();
    }

    public static List list(NodeList self) {
        ArrayList<Node> answer = new ArrayList<Node>();
        Iterator<Node> it = DefaultGroovyMethods.iterator(self);
        while (it.hasNext()) {
            answer.add(it.next());
        }
        return answer;
    }

    public static NodeList depthFirst(Element self) {
        ArrayList<NodeList> result = new ArrayList<NodeList>();
        result.add(DOMCategory.createNodeList(self));
        result.add(self.getElementsByTagName("*"));
        return new NodeListsHolder(result);
    }

    public static void setValue(Element self, String value) {
        self.getFirstChild().setNodeValue(value);
    }

    public static void putAt(Element self, String property, Object value) {
        if (property.startsWith("@")) {
            String attributeName = property.substring(1);
            Document doc = self.getOwnerDocument();
            Attr newAttr = doc.createAttribute(attributeName);
            newAttr.setValue(value.toString());
            self.setAttributeNode(newAttr);
            return;
        }
        InvokerHelper.setProperty(self, property, value);
    }

    public static Element appendNode(Element self, Object name) {
        return DOMCategory.appendNode(self, name, (String)null);
    }

    public static Element appendNode(Element self, Object name, Map attributes) {
        return DOMCategory.appendNode(self, name, attributes, null);
    }

    public static Element appendNode(Element self, Object name, String value) {
        Element newChild;
        Document doc = self.getOwnerDocument();
        if (name instanceof QName) {
            QName qn = (QName)name;
            newChild = doc.createElementNS(qn.getNamespaceURI(), qn.getQualifiedName());
        } else {
            newChild = doc.createElement(name.toString());
        }
        if (value != null) {
            Text text = doc.createTextNode(value);
            newChild.appendChild(text);
        }
        self.appendChild(newChild);
        return newChild;
    }

    public static Element appendNode(Element self, Object name, Map attributes, String value) {
        Element result = DOMCategory.appendNode(self, name, value);
        for (Map.Entry e : attributes.entrySet()) {
            DOMCategory.putAt(result, "@" + e.getKey().toString(), e.getValue());
        }
        return result;
    }

    private static NodeList createNodeList(Element self) {
        ArrayList<Element> first = new ArrayList<Element>();
        first.add(self);
        return new NodesHolder(first);
    }

    public static NodeList breadthFirst(Element self) {
        ArrayList<NodeList> result = new ArrayList<NodeList>();
        NodeList thisLevel = DOMCategory.createNodeList(self);
        while (thisLevel.getLength() > 0) {
            result.add(thisLevel);
            thisLevel = DOMCategory.getNextLevel(thisLevel);
        }
        return new NodeListsHolder(result);
    }

    private static NodeList getNextLevel(NodeList thisLevel) {
        ArrayList<NodeList> result = new ArrayList<NodeList>();
        for (int i = 0; i < thisLevel.getLength(); ++i) {
            Node n = thisLevel.item(i);
            if (!(n instanceof Element)) continue;
            result.add(DOMCategory.getChildElements((Element)n, "*"));
        }
        return new NodeListsHolder(result);
    }

    public static NodeList children(Element self) {
        return DOMCategory.getChildElements(self, "*");
    }

    private static boolean hasChildElements(Element self, String elementName) {
        return DOMCategory.getChildElements(self, elementName).getLength() > 0;
    }

    private static NodeList getChildElements(Element self, String elementName) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList nodeList = self.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Element child = (Element)node;
                if (!"*".equals(elementName) && !child.getTagName().equals(elementName)) continue;
                result.add(child);
                continue;
            }
            if (node.getNodeType() != 3) continue;
            String value = node.getNodeValue();
            if (trimWhitespace) {
                value = value.trim();
            }
            if (!"*".equals(elementName) || value.length() <= 0) continue;
            node.setNodeValue(value);
            result.add(node);
        }
        return new NodesHolder(result);
    }

    public static String toString(Object o) {
        if (o instanceof Node && ((Node)o).getNodeType() == 3) {
            return ((Node)o).getNodeValue();
        }
        if (o instanceof NodeList) {
            return DOMCategory.toString((NodeList)o);
        }
        return o.toString();
    }

    public static Object xpath(Node self, String expression, javax.xml.namespace.QName returnType) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            return xpath.evaluate(expression, self, returnType);
        }
        catch (XPathExpressionException e) {
            throw new GroovyRuntimeException(e);
        }
    }

    public static String xpath(Node self, String expression) {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            return xpath.evaluate(expression, self);
        }
        catch (XPathExpressionException e) {
            throw new GroovyRuntimeException(e);
        }
    }

    private static String toString(NodeList self) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        Iterator<Node> it = DefaultGroovyMethods.iterator(self);
        while (it.hasNext()) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(it.next().toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public static int size(NodeList self) {
        return self.getLength();
    }

    public static boolean isEmpty(NodeList self) {
        return DOMCategory.size(self) == 0;
    }

    private static void addResult(List results, Object result) {
        if (result != null) {
            if (result instanceof Collection) {
                results.addAll((Collection)result);
            } else {
                results.add(result);
            }
        }
    }

    private static final class NodeListsHolder
    implements NodeList {
        private List nodeLists;

        private NodeListsHolder(List nodeLists) {
            this.nodeLists = nodeLists;
        }

        public int getLength() {
            int length = 0;
            for (int i = 0; i < this.nodeLists.size(); ++i) {
                NodeList nl = (NodeList)this.nodeLists.get(i);
                length += nl.getLength();
            }
            return length;
        }

        public Node item(int index) {
            int relativeIndex = index;
            for (int i = 0; i < this.nodeLists.size(); ++i) {
                NodeList nl = (NodeList)this.nodeLists.get(i);
                if (relativeIndex < nl.getLength()) {
                    return nl.item(relativeIndex);
                }
                relativeIndex -= nl.getLength();
            }
            return null;
        }

        public String toString() {
            return DOMCategory.toString(this);
        }
    }

    private static final class NodesHolder
    implements NodeList {
        private List nodes;

        private NodesHolder(List nodes) {
            this.nodes = nodes;
        }

        public int getLength() {
            return this.nodes.size();
        }

        public Node item(int index) {
            if (index < 0 || index >= this.getLength()) {
                return null;
            }
            return (Node)this.nodes.get(index);
        }
    }
}

