/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.performance;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Box;
import gov.nasa.worldwind.render.Cone;
import gov.nasa.worldwind.render.Cylinder;
import gov.nasa.worldwind.render.Ellipsoid;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Pyramid;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.RigidShape;
import gov.nasa.worldwind.render.Wedge;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EllipsoidsEverywhere
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Very Many Shapes", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        String shapeType = "Ellipsoid";

        public AppFrame() {
            super(true, true, false);
            this.getLayerPanel().add((Component)this.makeShapesControlPanel(), "South");
            RenderableLayer renderableLayer = new RenderableLayer();
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.makeMany();
        }

        protected void makeMany() {
            int n = 0;
            double d = -50.0;
            double d2 = 50.0;
            double d3 = -140.0;
            double d4 = -10.0;
            double d5 = 1.5;
            double d6 = 5.0;
            double d7 = 1.0 / d6;
            double d8 = 1.0 / d6;
            RenderableLayer renderableLayer = this.getLayer();
            int n2 = 0;
            for (double d9 = d; d9 <= d2; d9 += d5) {
                for (double d10 = d3; d10 <= d4; d10 += d5) {
                    Position position = new Position(Angle.fromDegreesLatitude(d9), Angle.fromDegreesLongitude(d10), 50000.0);
                    RigidShape rigidShape = this.shapeType.equalsIgnoreCase("ellipsoid") ? new Ellipsoid(position, 50000.0, 10000.0, 50000.0) : (this.shapeType.equalsIgnoreCase("box") ? new Box(position, 50000.0, 10000.0, 50000.0) : (this.shapeType.equalsIgnoreCase("pyramid") ? new Pyramid(position, 50000.0, 10000.0, 50000.0) : (this.shapeType.equalsIgnoreCase("cylinder") ? new Cylinder(position, 50000.0, 10000.0, 50000.0) : (this.shapeType.equalsIgnoreCase("cone") ? new Cone(position, 50000.0, 10000.0, 50000.0) : new Wedge(position, Angle.fromDegrees(227.0), 50000.0, 10000.0, 50000.0)))));
                    rigidShape.setAltitudeMode(n);
                    BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
                    basicShapeAttributes.setDrawOutline(false);
                    basicShapeAttributes.setInteriorMaterial(Material.RED);
                    basicShapeAttributes.setEnableLighting(true);
                    rigidShape.setAttributes(basicShapeAttributes);
                    renderableLayer.addRenderable(rigidShape);
                    ++n2;
                }
            }
            System.out.printf("%d %s, Altitude mode = %s\n", n2, this.shapeType, n == 2 ? "RELATIVE_TO_GROUND" : "ABSOLUTE");
            this.getLayerPanel().update(this.getWwd());
        }

        protected JPanel makeShapesControlPanel() {
            JPanel jPanel = new JPanel(new BorderLayout(0, 10));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Shape selection")));
            JPanel jPanel2 = new JPanel(new BorderLayout(0, 5));
            Object object = new String[]{"Ellipsoid", "Box", "Pyramid", "Cylinder", "Cone", "Wedge"};
            JComboBox<String> jComboBox = new JComboBox<String>((E[])object);
            jComboBox.setSelectedIndex(0);
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    AppFrame.this.shapeType = (String)jComboBox.getSelectedItem();
                    AppFrame.this.getLayer().removeAllRenderables();
                    AppFrame.this.makeMany();
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel2.add(jComboBox, "South");
            object = new JPanel(new BorderLayout(0, 5));
            int n = -10;
            int n2 = 10;
            int n3 = 0;
            JSlider jSlider = new JSlider(n, n2, n3);
            jSlider.setMajorTickSpacing(10);
            jSlider.setMinorTickSpacing(1);
            jSlider.setPaintTicks(true);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(-10, new JLabel("-1.0"));
            hashtable.put(0, new JLabel("0.0"));
            hashtable.put(10, new JLabel("1.0"));
            jSlider.setLabelTable(hashtable);
            jSlider.setPaintLabels(true);
            jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    double d = (double)((JSlider)changeEvent.getSource()).getValue() / 10.0;
                    AppFrame.this.getLayer().removeAllRenderables();
                    AppFrame.this.makeMany();
                    AppFrame.this.setDetailHint(d);
                    AppFrame.this.getWwd().redraw();
                }
            });
            ((Container)object).add((Component)jSlider, "South");
            JPanel jPanel3 = new JPanel(new GridLayout(2, 0));
            jPanel3.add(jPanel2);
            JLabel jLabel = new JLabel("Detail Hint:");
            JPanel jPanel4 = new JPanel(new GridLayout(2, 0));
            jPanel4.add((Component)object);
            jPanel.add((Component)jPanel3, "North");
            jPanel.add((Component)jLabel, "Center");
            jPanel.add((Component)jPanel4, "South");
            return jPanel;
        }

        protected RenderableLayer getLayer() {
            for (Layer layer : this.getWwd().getModel().getLayers()) {
                if (!layer.getName().contains("Renderable")) continue;
                return (RenderableLayer)layer;
            }
            return null;
        }

        protected void setDetailHint(double d) {
            for (Renderable renderable : this.getLayer().getRenderables()) {
                RigidShape rigidShape;
                if (this.shapeType.equalsIgnoreCase("ellipsoid")) {
                    rigidShape = (Ellipsoid)renderable;
                    rigidShape.setDetailHint(d);
                    continue;
                }
                if (this.shapeType.equalsIgnoreCase("cylinder")) {
                    rigidShape = (Cylinder)renderable;
                    rigidShape.setDetailHint(d);
                    continue;
                }
                if (this.shapeType.equalsIgnoreCase("cone")) {
                    rigidShape = (Cone)renderable;
                    rigidShape.setDetailHint(d);
                    continue;
                }
                if (!this.shapeType.equalsIgnoreCase("wedge")) continue;
                rigidShape = (Wedge)renderable;
                rigidShape.setDetailHint(d);
            }
            System.out.println("wedge detail hint set to " + d);
        }
    }
}

