/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Version;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class WorldWindDiagnostics {
    public static void main(String[] stringArray) {
        MainFrame mainFrame = new MainFrame();
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setVisible(true);
    }

    static {
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind Diagnostic Program");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
        }
    }

    private static class MainFrame
    extends JFrame {
        private static JTextArea outputArea = new JTextArea(20, 80);
        private static Action[] operations = new Action[]{new RunAction()};
        private JPanel mainPanel = new JPanel();
        private JPanel controlContainer = new JPanel(new BorderLayout());
        private JPanel outputContainer = new JPanel();

        public MainFrame() {
            try {
                this.mainPanel.setLayout(new BorderLayout());
                this.mainPanel.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
                this.mainPanel.add((Component)this.outputContainer, "Center");
                outputArea.setLineWrap(true);
                this.outputContainer.add((Component)new JScrollPane(outputArea), "Center");
                this.outputContainer.setBorder(new TitledBorder("Results"));
                this.getContentPane().add((Component)this.mainPanel, "Center");
                ArrayList<JButton> arrayList = new ArrayList<JButton>();
                Serializable serializable = new JPanel(new GridLayout(0, 1, 0, 10));
                serializable.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
                Object object2 = new JPanel(new GridLayout(6, 1));
                ((JComponent)object2).setBorder(new TitledBorder("Operations"));
                for (Action action : operations) {
                    JPanel jPanel = new JPanel(new BorderLayout());
                    JButton jButton = new JButton(action);
                    arrayList.add(jButton);
                    jPanel.add((Component)jButton, "North");
                    ((Container)object2).add(jPanel);
                }
                serializable.add((Component)object2);
                this.controlContainer.add((Component)serializable, "Center");
                this.getContentPane().add((Component)this.controlContainer, "West");
                this.pack();
                serializable = ((JButton)arrayList.get(0)).getSize();
                for (JButton jButton : arrayList) {
                    jButton.setPreferredSize((Dimension)serializable);
                }
                object2 = this.getPreferredSize();
                ((Dimension)object2).setSize(((Dimension)object2).getWidth(), 1.1 * ((Dimension)object2).getHeight());
                this.setSize((Dimension)object2);
                Point point = new Point(0, 0);
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                int n = point.x + (dimension.width - ((Dimension)object2).width) / 2;
                int n2 = point.y + (dimension.height - ((Dimension)object2).height) / 2;
                this.setLocation(n, n2);
                this.setResizable(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        protected void processWindowEvent(WindowEvent windowEvent) {
            super.processWindowEvent(windowEvent);
            if (windowEvent.getID() != 200) {
                return;
            }
            GLFrame gLFrame = new GLFrame(outputArea);
            gLFrame.setVisible(true);
        }

        private static class RunAction
        extends AbstractAction {
            public RunAction() {
                super("Re-run Test");
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                outputArea.setText("");
                GLFrame gLFrame = new GLFrame(outputArea);
                gLFrame.setVisible(true);
            }
        }
    }

    private static class GLFrame
    extends JFrame
    implements GLEventListener {
        private JTextArea outputArea;
        private static Attr[] attrs = new Attr[]{new Attr(3415, "stencil bits"), new Attr(3414, "depth bits"), new Attr(34018, "max texture units"), new Attr(34930, "max texture image units"), new Attr(34929, "max texture coords"), new Attr(3379, "max texture size"), new Attr(33001, "max elements indices"), new Attr(33000, "max elements vertices"), new Attr(3377, "max lights")};

        GLFrame(JTextArea jTextArea) {
            this.outputArea = jTextArea;
            GLCapabilities gLCapabilities = new GLCapabilities(Configuration.getMaxCompatibleGLProfile());
            gLCapabilities.setAlphaBits(8);
            gLCapabilities.setRedBits(8);
            gLCapabilities.setGreenBits(8);
            gLCapabilities.setBlueBits(8);
            GLCanvas gLCanvas = new GLCanvas((GLCapabilitiesImmutable)gLCapabilities);
            gLCanvas.addGLEventListener((GLEventListener)this);
            this.add((Component)gLCanvas);
            this.setSize(200, 200);
        }

        /*
         * WARNING - void declaration
         */
        public void init(GLAutoDrawable gLAutoDrawable) {
            void var11_14;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Version.getVersion() + "\n");
            stringBuilder.append("\nSystem Properties\n");
            stringBuilder.append("Processors: " + Runtime.getRuntime().availableProcessors() + "\n");
            stringBuilder.append("Free memory: " + Runtime.getRuntime().freeMemory() + " bytes\n");
            stringBuilder.append("Max memory: " + Runtime.getRuntime().maxMemory() + " bytes\n");
            stringBuilder.append("Total memory: " + Runtime.getRuntime().totalMemory() + " bytes\n");
            for (Map.Entry<Object, Object> object2 : System.getProperties().entrySet()) {
                stringBuilder.append(object2.getKey() + " = " + object2.getValue() + "\n");
            }
            GL gL = gLAutoDrawable.getGL();
            stringBuilder.append("\nOpenGL Values\n");
            String string = gL.glGetString(7938);
            stringBuilder.append("OpenGL version: " + string + "\n");
            String string2 = gL.glGetString(7936);
            stringBuilder.append("OpenGL vendor: " + string2 + "\n");
            String string3 = gL.glGetString(7937);
            stringBuilder.append("OpenGL renderer: " + string3 + "\n");
            String string4 = "";
            int[] nArray = new int[1];
            Object object = attrs;
            int stringArray = ((Attr[])object).length;
            boolean object3 = false;
            while (var11_14 < stringArray) {
                Attr classNotFoundException = object[var11_14];
                if (classNotFoundException.attr instanceof Integer) {
                    gL.glGetIntegerv(((Integer)classNotFoundException.attr).intValue(), nArray, 0);
                    string4 = Integer.toString(nArray[0]);
                }
                stringBuilder.append(classNotFoundException.name + ": " + string4 + "\n");
                ++var11_14;
            }
            object = gL.glGetString(7939);
            String[] stringArray2 = ((String)object).split(" ");
            stringBuilder.append("Extensions\n");
            for (String string5 : stringArray2) {
                stringBuilder.append("    " + string5 + "\n");
            }
            stringBuilder.append("\nJOGL Values\n");
            String string6 = "javax.media.opengl";
            try {
                this.getClass().getClassLoader().loadClass(string6 + ".GL");
                Package package_ = Package.getPackage(string6);
                if (package_ == null) {
                    stringBuilder.append("WARNING: Package.getPackage(" + string6 + ") is null\n");
                } else {
                    stringBuilder.append(package_ + "\n");
                    stringBuilder.append("Specification Title = " + package_.getSpecificationTitle() + "\n");
                    stringBuilder.append("Specification Vendor = " + package_.getSpecificationVendor() + "\n");
                    stringBuilder.append("Specification Version = " + package_.getSpecificationVersion() + "\n");
                    stringBuilder.append("Implementation Vendor = " + package_.getImplementationVendor() + "\n");
                    stringBuilder.append("Implementation Version = " + package_.getImplementationVersion() + "\n");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                stringBuilder.append("Unable to load " + string6 + "\n");
            }
            this.outputArea.setText(stringBuilder.toString());
        }

        public void dispose(GLAutoDrawable gLAutoDrawable) {
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            gLAutoDrawable.getGL().glClear(16640);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        }

        private static class Attr {
            private Object attr;
            private String name;

            private Attr(Object object, String string) {
                this.attr = object;
                this.name = string;
            }
        }
    }
}

