/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.SurfaceSector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.view.orbit.BasicOrbitViewLimits;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwind.view.orbit.OrbitViewLimits;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ViewLimits
extends ApplicationTemplate {
    protected static final String SECTOR_LIMITS_CHANGED = "SectorLimitsChanged";
    protected static final String HEADING_LIMITS_CHANGED = "HeadingLimitsChanged";
    protected static final String PITCH_LIMITS_CHANGED = "PitchLimitsChanged";
    protected static final String ZOOM_LIMITS_CHANGED = "ZoomLimitsChanged";
    protected static final String SAVE = "Save";
    protected static final String LOAD = "Load";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("View Limits", AppFrame.class);
    }

    public static class Controller
    implements ActionListener {
        protected AppFrame appFrame;
        protected SurfaceSector surfaceSector;
        protected RenderableLayer layer;
        protected static final Sector DEFAULT_SECTOR_LIMITS = Sector.fromDegrees(40.0, 50.0, -130.0, -120.0);

        public Controller(AppFrame appFrame) {
            OrbitViewLimits orbitViewLimits;
            this.appFrame = appFrame;
            this.surfaceSector = new SurfaceSector();
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setInteriorMaterial(Material.WHITE);
            basicShapeAttributes.setOutlineMaterial(Material.GREEN);
            basicShapeAttributes.setInteriorOpacity(0.1);
            basicShapeAttributes.setOutlineOpacity(0.7);
            basicShapeAttributes.setOutlineWidth(3.0);
            this.surfaceSector.setAttributes(basicShapeAttributes);
            this.layer = new RenderableLayer();
            this.layer.setPickEnabled(false);
            this.layer.addRenderable(this.surfaceSector);
            ApplicationTemplate.insertBeforePlacenames(this.appFrame.getWwd(), this.layer);
            OrbitView orbitView = this.getOrbitView();
            if (orbitView != null && (orbitViewLimits = orbitView.getOrbitViewLimits()) != null) {
                Globe globe = this.appFrame.getWwd().getModel().getGlobe();
                double d = 3.0 * globe.getRadius();
                orbitViewLimits.setCenterLocationLimits(DEFAULT_SECTOR_LIMITS);
                orbitViewLimits.setZoomLimits(0.0, d);
                BasicOrbitViewLimits.applyLimits(orbitView, orbitViewLimits);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent == null) {
                return;
            }
            String string = actionEvent.getActionCommand();
            if (string == null) {
                return;
            }
            if (string == ViewLimits.SECTOR_LIMITS_CHANGED || string == ViewLimits.HEADING_LIMITS_CHANGED || string == ViewLimits.PITCH_LIMITS_CHANGED || string == ViewLimits.ZOOM_LIMITS_CHANGED) {
                this.updateViewLimits();
            } else if (string == ViewLimits.LOAD) {
                this.loadObjects();
            } else if (string == ViewLimits.SAVE) {
                this.saveObjects();
            }
        }

        public void updateViewLimits() {
            double[] dArray;
            Angle[] angleArray;
            OrbitView orbitView = this.getOrbitView();
            if (orbitView == null) {
                return;
            }
            OrbitViewLimits orbitViewLimits = orbitView.getOrbitViewLimits();
            if (orbitViewLimits == null) {
                return;
            }
            Sector sector = this.appFrame.getSectorLimits();
            if (sector != null) {
                orbitViewLimits.setCenterLocationLimits(sector);
            }
            if ((angleArray = this.appFrame.getHeadingLimits()) != null) {
                orbitViewLimits.setHeadingLimits(angleArray[0], angleArray[1]);
            }
            if ((angleArray = this.appFrame.getPitchLimits()) != null) {
                orbitViewLimits.setPitchLimits(angleArray[0], angleArray[1]);
            }
            if ((dArray = this.appFrame.getZoomLimits()) != null) {
                orbitViewLimits.setZoomLimits(dArray[0], dArray[1]);
            }
            BasicOrbitViewLimits.applyLimits(orbitView, orbitViewLimits);
            this.updateRenderables();
        }

        public void saveObjects() {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File(Configuration.getUserHomeDirectory()));
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            int n = jFileChooser.showSaveDialog(this.appFrame);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            View view = this.appFrame.getWwd().getView();
            String string = view.getRestorableState();
            WWIO.writeTextFile(string, file);
        }

        public void loadObjects() {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(new File(Configuration.getUserHomeDirectory()));
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            int n = jFileChooser.showOpenDialog(this.appFrame);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            View view = this.appFrame.getWwd().getView();
            String string = WWIO.readTextFile(file);
            view.restoreState(string);
            if (view instanceof OrbitView) {
                OrbitView orbitView = (OrbitView)view;
                BasicOrbitViewLimits.applyLimits(orbitView, orbitView.getOrbitViewLimits());
            }
            this.appFrame.updateComponents();
        }

        public OrbitView getOrbitView() {
            View view = this.appFrame.getWwd().getView();
            return view != null && view instanceof OrbitView ? (OrbitView)view : null;
        }

        public void updateRenderables() {
            View view = this.appFrame.getWwd().getView();
            if (view == null || !(view instanceof OrbitView)) {
                return;
            }
            OrbitView orbitView = (OrbitView)view;
            OrbitViewLimits orbitViewLimits = orbitView.getOrbitViewLimits();
            this.surfaceSector.setSector(orbitViewLimits.getCenterLocationLimits());
            this.appFrame.getWwd().redraw();
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame
    implements ActionListener {
        private Controller controller = new Controller(this);
        private JSpinner minLatitude;
        private JSpinner maxLatitude;
        private JSpinner minLongitude;
        private JSpinner maxLongitude;
        private JSpinner minHeading;
        private JSpinner maxHeading;
        private JSpinner minPitch;
        private JSpinner maxPitch;
        private JSpinner minZoom;
        private JSpinner maxZoom;
        private boolean ignoreComponentEvents = false;

        public AppFrame() {
            this.initComponents();
            this.updateComponents();
        }

        public Sector getSectorLimits() {
            return Sector.fromDegrees((Double)this.minLatitude.getValue(), (Double)this.maxLatitude.getValue(), (Double)this.minLongitude.getValue(), (Double)this.maxLongitude.getValue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSectorLimits(Sector sector) {
            if (sector == null) {
                String string = Logging.getMessage("nullValue.SectorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.ignoreComponentEvents = true;
            try {
                this.minLatitude.setValue(sector.getMinLatitude().degrees);
                this.maxLatitude.setValue(sector.getMaxLatitude().degrees);
                this.minLongitude.setValue(sector.getMinLongitude().degrees);
                this.maxLongitude.setValue(sector.getMaxLongitude().degrees);
            }
            finally {
                this.ignoreComponentEvents = false;
            }
        }

        public Angle[] getHeadingLimits() {
            return new Angle[]{Angle.fromDegrees((Double)this.minHeading.getValue()), Angle.fromDegrees((Double)this.maxHeading.getValue())};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setHeadingLimits(Angle angle, Angle angle2) {
            if (angle == null || angle2 == null) {
                String string = Logging.getMessage("nullValue.MinOrMaxAngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.ignoreComponentEvents = true;
            try {
                this.minHeading.setValue(angle.degrees);
                this.maxHeading.setValue(angle2.degrees);
            }
            finally {
                this.ignoreComponentEvents = false;
            }
        }

        public Angle[] getPitchLimits() {
            return new Angle[]{Angle.fromDegrees((Double)this.minPitch.getValue()), Angle.fromDegrees((Double)this.maxPitch.getValue())};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPitchLimits(Angle angle, Angle angle2) {
            if (angle == null || angle2 == null) {
                String string = Logging.getMessage("nullValue.MinOrMaxAngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.ignoreComponentEvents = true;
            try {
                this.minPitch.setValue(angle.degrees);
                this.maxPitch.setValue(angle2.degrees);
            }
            finally {
                this.ignoreComponentEvents = false;
            }
        }

        public double[] getZoomLimits() {
            return new double[]{(Double)this.minZoom.getValue(), (Double)this.maxZoom.getValue()};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setZoomLimits(double d, double d2) {
            try {
                this.minZoom.setValue(d);
                this.maxZoom.setValue(d2);
            }
            finally {
                this.ignoreComponentEvents = false;
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.ignoreComponentEvents) {
                return;
            }
            if (this.controller != null) {
                this.controller.actionPerformed(actionEvent);
            }
        }

        public void updateComponents() {
            double[] dArray;
            Angle[] angleArray;
            OrbitView orbitView = this.controller.getOrbitView();
            if (orbitView == null) {
                return;
            }
            OrbitViewLimits orbitViewLimits = orbitView.getOrbitViewLimits();
            if (orbitViewLimits == null) {
                return;
            }
            Sector sector = orbitViewLimits.getCenterLocationLimits();
            if (sector != null) {
                this.setSectorLimits(sector);
            }
            if ((angleArray = orbitViewLimits.getHeadingLimits()) != null) {
                this.setHeadingLimits(angleArray[0], angleArray[1]);
            }
            if ((angleArray = orbitViewLimits.getPitchLimits()) != null) {
                this.setPitchLimits(angleArray[0], angleArray[1]);
            }
            if ((dArray = orbitViewLimits.getZoomLimits()) != null) {
                this.setZoomLimits(dArray[0], dArray[1]);
            }
        }

        protected void initComponents() {
            this.minLatitude = this.createAngleSpinner(ViewLimits.SECTOR_LIMITS_CHANGED, Angle.NEG90, Angle.NEG90, Angle.POS90);
            this.maxLatitude = this.createAngleSpinner(ViewLimits.SECTOR_LIMITS_CHANGED, Angle.POS90, Angle.NEG90, Angle.POS90);
            this.minLongitude = this.createAngleSpinner(ViewLimits.SECTOR_LIMITS_CHANGED, Angle.NEG180, Angle.NEG180, Angle.POS180);
            this.maxLongitude = this.createAngleSpinner(ViewLimits.SECTOR_LIMITS_CHANGED, Angle.POS180, Angle.NEG180, Angle.POS180);
            this.minHeading = this.createAngleSpinner(ViewLimits.HEADING_LIMITS_CHANGED, Angle.NEG180, Angle.NEG180, Angle.POS180);
            this.maxHeading = this.createAngleSpinner(ViewLimits.HEADING_LIMITS_CHANGED, Angle.POS180, Angle.NEG180, Angle.POS180);
            this.minPitch = this.createAngleSpinner(ViewLimits.PITCH_LIMITS_CHANGED, Angle.NEG180, Angle.NEG180, Angle.POS180);
            this.maxPitch = this.createAngleSpinner(ViewLimits.PITCH_LIMITS_CHANGED, Angle.POS180, Angle.NEG180, Angle.POS180);
            this.minZoom = this.createDoubleSpinner(ViewLimits.ZOOM_LIMITS_CHANGED, 0.0, 0.0, Double.MAX_VALUE);
            this.maxZoom = this.createDoubleSpinner(ViewLimits.ZOOM_LIMITS_CHANGED, Double.MAX_VALUE, 0.0, Double.MAX_VALUE);
            JPanel jPanel = new JPanel(new BorderLayout(0, 0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 20, 0));
            JComponent jComponent = Box.createVerticalBox();
            JComponent jComponent2 = new JLabel("<html><b>Sector Limits</b></html>");
            jComponent2.setAlignmentX(0.0f);
            jComponent.add(jComponent2);
            JComponent jComponent3 = Box.createHorizontalBox();
            jComponent3.setAlignmentX(0.0f);
            jComponent3.add(new JLabel("Lat Min/Max"));
            jComponent3.add(this.minLatitude);
            jComponent3.add(this.maxLatitude);
            jComponent.add(jComponent3);
            jComponent3 = Box.createHorizontalBox();
            jComponent3.setAlignmentX(0.0f);
            jComponent3.add(new JLabel("Lon Min/Max"));
            jComponent3.add(this.minLongitude);
            jComponent3.add(this.maxLongitude);
            jComponent.add(jComponent3);
            jComponent2 = new JLabel("<html><b>Heading Limits</b></html>");
            jComponent2.setAlignmentX(0.0f);
            jComponent.add(jComponent2);
            jComponent3 = Box.createHorizontalBox();
            jComponent3.setAlignmentX(0.0f);
            jComponent3.add(new JLabel("Min/Max"));
            jComponent3.add(this.minHeading);
            jComponent3.add(this.maxHeading);
            jComponent.add(jComponent3);
            jComponent2 = new JLabel("<html><b>Pitch Limits</b></html>");
            jComponent2.setAlignmentX(0.0f);
            jComponent.add(jComponent2);
            jComponent3 = Box.createHorizontalBox();
            jComponent3.setAlignmentX(0.0f);
            jComponent3.add(new JLabel("Min/Max"));
            jComponent3.add(this.minPitch);
            jComponent3.add(this.maxPitch);
            jComponent.add(jComponent3);
            jComponent2 = new JLabel("<html><b>Zoom Limits</b></html>");
            jComponent2.setAlignmentX(0.0f);
            jComponent.add(jComponent2);
            jComponent3 = Box.createHorizontalBox();
            jComponent3.setAlignmentX(0.0f);
            jComponent3.add(new JLabel("Min/Max"));
            jComponent3.add(this.minZoom);
            jComponent3.add(this.maxZoom);
            jComponent.add(jComponent3);
            jPanel.add((Component)jComponent, "North");
            this.getLayerPanel().add((Component)jPanel, "South");
            jComponent = new JMenuBar();
            jComponent2 = new JMenu("File");
            jComponent3 = new JMenuItem("Open");
            ((AbstractButton)jComponent3).setActionCommand(ViewLimits.LOAD);
            ((AbstractButton)jComponent3).addActionListener(this.controller);
            ((JMenu)jComponent2).add((JMenuItem)jComponent3);
            jComponent3 = new JMenuItem(ViewLimits.SAVE);
            ((AbstractButton)jComponent3).setActionCommand(ViewLimits.SAVE);
            ((AbstractButton)jComponent3).addActionListener(this.controller);
            ((JMenu)jComponent2).add((JMenuItem)jComponent3);
            ((JMenuBar)jComponent).add((JMenu)jComponent2);
            this.setJMenuBar((JMenuBar)jComponent);
        }

        protected JSpinner createDoubleSpinner(final String string, double d, double d2, double d3) {
            final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(d, d2, d3, 0.01));
            jSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ActionEvent actionEvent = new ActionEvent(jSpinner, 0, string);
                    AppFrame.this.actionPerformed(actionEvent);
                }
            });
            Dimension dimension = jSpinner.getPreferredSize();
            dimension.width = 70;
            jSpinner.setPreferredSize(dimension);
            return jSpinner;
        }

        protected JSpinner createAngleSpinner(String string, Angle angle, Angle angle2, Angle angle3) {
            return this.createDoubleSpinner(string, angle.degrees, angle2.degrees, angle3.degrees);
        }
    }
}

