/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.examples;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.MultiResolutionPath;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwindx.examples.ApplicationTemplate;
import java.util.ArrayList;

public class MultiResPath
extends ApplicationTemplate {
    protected static final int NUM_POSITIONS = 108000;
    protected static final double SPEED = 1.4110703485986582E-5;
    protected static final Position[] ORIGIN = new Position[]{Position.fromDegrees(40.2377, -105.648, 200.0), Position.fromDegrees(41.2625, -105.6503, 200.0), Position.fromDegrees(42.2285, -105.6169, 200.0), Position.fromDegrees(43.2019, -105.6467, 200.0), Position.fromDegrees(44.2414, -105.6911, 200.0)};

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind UAVPath Test", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            this.makeMany();
        }

        protected void makeMany() {
            for (Position position : ORIGIN) {
                this.addShape(position);
            }
        }

        protected void addShape(Position position) {
            Object object;
            int n = 2;
            LatLon latLon = new LatLon(position);
            double d = 500.0;
            double d2 = 0.0;
            double d3 = 4.233211045795975E-5;
            ArrayList<Position> arrayList = new ArrayList<Position>(108000);
            for (int i = 0; i < 108000; ++i) {
                object = new Position(latLon, d);
                arrayList.add((Position)object);
                d += 5.0;
                latLon = LatLon.rhumbEndPosition(latLon, d2 += 0.04908738521234052, d3);
            }
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setDrawInterior(false);
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            object = new MultiResolutionPath(arrayList);
            ((Path)object).setShowPositions(true);
            ((Path)object).setShowPositionsThreshold(5000.0);
            ((AbstractShape)object).setViewDistanceExpiration(false);
            ((AbstractShape)object).setAltitudeMode(n);
            ((AbstractShape)object).setAttributes(basicShapeAttributes);
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.addRenderable((Renderable)object);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.getLayerPanel().update(this.getWwd());
        }
    }
}

