/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.worldwindow.util.Util;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImageLibrary {
    private static final String[] WARNING_IMAGES = new String[]{"gov/nasa/worldwindx/applications/worldwindow/images/warning16.png", "gov/nasa/worldwindx/applications/worldwindow/images/warning24.png", "gov/nasa/worldwindx/applications/worldwindow/images/warning32.png", "gov/nasa/worldwindx/applications/worldwindow/images/warning64.png"};
    private static ImageLibrary instance;
    private ConcurrentHashMap<String, BufferedImage> imageMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ImageIcon> iconMap = new ConcurrentHashMap();

    public static void setInstance(ImageLibrary imageLibrary) {
        instance = imageLibrary;
    }

    public ImageLibrary() {
        this.loadWarningImages();
    }

    protected void loadWarningImages() {
        for (String string : WARNING_IMAGES) {
            try {
                InputStream inputStream = WWIO.openFileOrResourceStream(string, this.getClass());
                this.imageMap.put(string, ImageUtil.toCompatibleImage(ImageIO.read(inputStream)));
            }
            catch (Exception exception) {
                Util.getLogger().log(Level.WARNING, exception.getMessage() + " Stand-in image, name is " + string, exception);
            }
        }
    }

    public static BufferedImage getWarningImage(int n) {
        if (n < 24) {
            return ImageLibrary.getImage(WARNING_IMAGES[0]);
        }
        if (n < 32) {
            return ImageLibrary.getImage(WARNING_IMAGES[1]);
        }
        if (n < 64) {
            return ImageLibrary.getImage(WARNING_IMAGES[2]);
        }
        return ImageLibrary.getImage(WARNING_IMAGES[3]);
    }

    public static Icon getWarningIcon(int n) {
        if (n < 24) {
            return ImageLibrary.getIcon(WARNING_IMAGES[0]);
        }
        if (n < 32) {
            return ImageLibrary.getIcon(WARNING_IMAGES[1]);
        }
        if (n < 64) {
            return ImageLibrary.getIcon(WARNING_IMAGES[2]);
        }
        return ImageLibrary.getIcon(WARNING_IMAGES[3]);
    }

    public static synchronized BufferedImage getImage(String string) {
        try {
            BufferedImage bufferedImage;
            BufferedImage bufferedImage2 = bufferedImage = !WWUtil.isEmpty(string) ? ImageLibrary.instance.imageMap.get(string) : null;
            if (bufferedImage != null) {
                return bufferedImage;
            }
            URL uRL = ImageLibrary.getImageURL(string);
            if (uRL != null && (bufferedImage = ImageIO.read(uRL)) != null) {
                bufferedImage = ImageUtil.toCompatibleImage(bufferedImage);
                ImageLibrary.register(string, bufferedImage);
                return bufferedImage;
            }
            return null;
        }
        catch (IOException iOException) {
            Util.getLogger().log(Level.SEVERE, iOException.getMessage() + " Image name " + (string != null ? string : null), iOException);
            return null;
        }
    }

    public static synchronized URL getImageURL(String string) {
        URL uRL = instance.getClass().getResource(string);
        if (uRL == null) {
            uRL = instance.getClass().getResource("/" + string);
        }
        if (uRL == null) {
            uRL = instance.getClass().getResource("images" + File.separatorChar + string);
        }
        if (uRL == null) {
            uRL = instance.getClass().getResource("/images" + File.separatorChar + string);
        }
        if (uRL == null) {
            uRL = instance.getClass().getResource("gov/nasa/worldwindx/applications/worldwindow/images" + File.separatorChar + string);
        }
        if (uRL == null) {
            uRL = instance.getClass().getResource("/gov/nasa/worldwindx/applications/worldwindow/images" + File.separatorChar + string);
        }
        return uRL;
    }

    public static synchronized ImageIcon getIcon(String string) {
        try {
            ImageIcon imageIcon;
            ImageIcon imageIcon2 = imageIcon = !WWUtil.isEmpty(string) ? ImageLibrary.instance.iconMap.get(string) : null;
            if (imageIcon != null) {
                return imageIcon;
            }
            BufferedImage bufferedImage = ImageLibrary.getImage(string);
            if (bufferedImage != null) {
                imageIcon = new ImageIcon(bufferedImage);
                ImageLibrary.register(string, imageIcon);
                return imageIcon;
            }
            return null;
        }
        catch (Exception exception) {
            Util.getLogger().log(Level.SEVERE, exception.getMessage() + " Icon name " + (string != null ? string : null), exception);
            return null;
        }
    }

    public static BufferedImage getImageForIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        return ImageLibrary.getImage(ImageLibrary.getIconName(icon));
    }

    public static synchronized Object register(String string, Object object) {
        if (!WWUtil.isEmpty(string) && object != null) {
            if (object instanceof BufferedImage) {
                ImageLibrary.instance.imageMap.put(string, (BufferedImage)object);
            } else if (object instanceof ImageIcon) {
                ImageLibrary.instance.iconMap.put(string, (ImageIcon)object);
            }
        }
        return object;
    }

    public static String getImageName(BufferedImage bufferedImage) {
        for (Map.Entry<String, BufferedImage> entry : ImageLibrary.instance.imageMap.entrySet()) {
            if (entry.getValue() != bufferedImage) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getIconName(Icon icon) {
        for (Map.Entry<String, ImageIcon> entry : ImageLibrary.instance.iconMap.entrySet()) {
            if (entry.getValue() != icon) continue;
            return entry.getKey();
        }
        return null;
    }
}

