/*
 * Decompiled with CFR 0.152.
 */
package jams.workspace.stores;

import jams.JAMS;
import jams.tools.StringTools;
import jams.workspace.DataReader;
import jams.workspace.DataSet;
import jams.workspace.DataSetDefinition;
import jams.workspace.DataValue;
import jams.workspace.DefaultDataSetDefinition;
import jams.workspace.JAMSWorkspace;
import jams.workspace.Workspace;
import jams.workspace.stores.InputDataStore;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class StandardInputDataStore
implements InputDataStore,
Serializable {
    protected HashMap<String, DataReader> dataIO = new HashMap();
    protected transient Workspace ws;
    protected DataSetDefinition dsd;
    protected int bufferSize = 0;
    protected String id;
    protected String description = "";
    protected String missingDataValue = "";
    protected String displayName = "";
    protected int accessMode = 0;
    protected boolean writeCache = false;

    public StandardInputDataStore(JAMSWorkspace ws) {
        this.ws = ws;
    }

    public StandardInputDataStore(JAMSWorkspace ws, String id, Document doc) throws ClassNotFoundException {
        Element missingdataElement;
        Element accessmodeElement;
        Node displaynameNode;
        this.ws = ws;
        this.id = id;
        Node descriptionNode = doc.getDocumentElement().getElementsByTagName("description").item(0);
        if (descriptionNode != null) {
            this.description = descriptionNode.getTextContent();
        }
        this.displayName = (displaynameNode = doc.getDocumentElement().getElementsByTagName("displayname").item(0)) != null ? displaynameNode.getTextContent() : id;
        Element parameterElement = (Element)doc.getDocumentElement().getElementsByTagName("parameter").item(0);
        Element bufferSizeElement = (Element)parameterElement.getElementsByTagName("buffersize").item(0);
        if (bufferSizeElement != null) {
            this.bufferSize = Integer.parseInt(bufferSizeElement.getAttribute("value"));
        }
        if ((accessmodeElement = (Element)parameterElement.getElementsByTagName("accessmode").item(0)) != null) {
            this.accessMode = Integer.parseInt(accessmodeElement.getAttribute("value"));
        }
        if ((missingdataElement = (Element)parameterElement.getElementsByTagName("missingdatavalue").item(0)) != null) {
            this.missingDataValue = missingdataElement.getAttribute("value");
        }
        if (this.accessMode == 1) {
            File file = null;
            file = new File(ws.getLocalDumpDirectory(), id + ".dump");
            if (!file.exists()) {
                this.writeCache = true;
                ws.getRuntime().sendInfoMsg("Writing cache file .. " + file.getPath());
            }
        }
        if (!this.readCache()) {
            this.dataIO = this.createDataIO(doc);
            this.dsd = this.createDataSetDefinitionFromDocument(doc);
        }
    }

    protected boolean readCache() {
        return !this.writeCache && this.accessMode == 1;
    }

    private DefaultDataSetDefinition createDataSetDefinitionFromDocument(Document doc) {
        DataReader metadataIO;
        Element columnElement;
        int i;
        ArrayList<Class> dataTypes = new ArrayList<Class>();
        Element metadataElement = (Element)doc.getElementsByTagName("metadata").item(0);
        NodeList columnList = metadataElement.getElementsByTagName("column");
        for (int i2 = 0; i2 < columnList.getLength(); ++i2) {
            Element columnElement2 = (Element)columnList.item(i2);
            try {
                Class<?> type = Class.forName(columnElement2.getAttribute("type"));
                dataTypes.add(type);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                this.ws.getRuntime().handle((Throwable)cnfe);
            }
        }
        DefaultDataSetDefinition def = new DefaultDataSetDefinition(dataTypes);
        NodeList rowList = metadataElement.getElementsByTagName("row");
        for (i = 0; i < rowList.getLength(); ++i) {
            Element rowElement = (Element)rowList.item(i);
            try {
                Class<?> type = Class.forName(rowElement.getAttribute("type"));
                def.addAttribute(rowElement.getAttribute("id"), type);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                this.ws.getRuntime().handle((Throwable)cnfe);
            }
        }
        for (i = 0; i < columnList.getLength(); ++i) {
            columnElement = (Element)columnList.item(i);
            metadataIO = this.dataIO.get(columnElement.getAttribute("metadataio"));
            if (metadataIO != null) {
                int result = metadataIO.init();
                if (result >= 0) continue;
                this.ws.getRuntime().sendErrorMsg(JAMS.i18n("Initialization_of_data_I/O_component_") + this.getID() + JAMS.i18n("_(") + this.getClass().getName() + JAMS.i18n(")_failed!"));
                return null;
            }
            this.ws.getRuntime().sendErrorMsg(JAMS.i18n("Initialization_of_data_I/O_component_") + this.getID() + JAMS.i18n("_(") + this.getClass().getName() + JAMS.i18n(")_failed!"));
            return null;
        }
        for (i = 0; i < columnList.getLength(); ++i) {
            columnElement = (Element)columnList.item(i);
            metadataIO = this.dataIO.get(columnElement.getAttribute("metadataio"));
            int source = Integer.parseInt(columnElement.getAttribute("source"));
            DataSet metadataSet = metadataIO.getMetadata(source - 1);
            ArrayList<Object> values = new ArrayList<Object>();
            for (DataValue value : metadataSet.getData()) {
                values.add(value.getObject());
            }
            def.setAttributeValues(i, values);
        }
        for (i = 0; i < columnList.getLength(); ++i) {
            columnElement = (Element)columnList.item(i);
            metadataIO = this.dataIO.get(columnElement.getAttribute("metadataio"));
        }
        return def;
    }

    private HashMap<String, DataReader> createDataIO(Document doc) throws ClassNotFoundException {
        int n;
        HashMap<String, DataReader> _dataIO = new HashMap<String, DataReader>();
        Element ioElement = (Element)doc.getElementsByTagName("dataio").item(0);
        if (ioElement == null) {
            return null;
        }
        HashMap<String, String> varMap = new HashMap<String, String>();
        Element variableElement = (Element)ioElement.getElementsByTagName("variables").item(0);
        if (variableElement != null) {
            NodeList varNodes = variableElement.getElementsByTagName("var");
            for (n = 0; n < varNodes.getLength(); ++n) {
                Element varNode = (Element)varNodes.item(n);
                varMap.put(varNode.getAttribute("id"), varNode.getAttribute("value"));
            }
        }
        NodeList ioNodes = ioElement.getElementsByTagName("plugin");
        for (n = 0; n < ioNodes.getLength(); ++n) {
            Element ioNode = (Element)ioNodes.item(n);
            String className = ioNode.getAttribute("type");
            String nodeID = ioNode.getAttribute("id");
            ClassLoader loader = this.ws.getClassLoader();
            try {
                Class<?> clazz = loader.loadClass(className);
                DataReader io = (DataReader)clazz.newInstance();
                NodeList parameterNodes = ioNode.getElementsByTagName("parameter");
                for (int i = 0; i < parameterNodes.getLength(); ++i) {
                    Element parameterNode = (Element)parameterNodes.item(i);
                    String attributeName = parameterNode.getAttribute("id");
                    String attributeValue = "";
                    if (parameterNode.hasAttribute("value")) {
                        attributeValue = parameterNode.getAttribute("value");
                    } else {
                        String varID = parameterNode.getAttribute("varid");
                        attributeValue = (String)varMap.get(varID);
                    }
                    String methodName = StringTools.getSetterName(attributeName);
                    Method method = clazz.getMethod(methodName, String.class);
                    method.invoke((Object)io, attributeValue);
                }
                _dataIO.put(nodeID, io);
                continue;
            }
            catch (InstantiationException ie) {
                this.ws.getRuntime().handle((Throwable)ie);
                return null;
            }
            catch (IllegalAccessException iae) {
                this.ws.getRuntime().handle((Throwable)iae);
                return null;
            }
            catch (NoSuchMethodException nsme) {
                this.ws.getRuntime().handle((Throwable)nsme);
                return null;
            }
            catch (InvocationTargetException ite) {
                this.ws.getRuntime().handle((Throwable)ite);
                return null;
            }
        }
        return _dataIO;
    }

    protected String getNodeValue(Element theElement, String theNodeName) {
        Element uriNode;
        String theNodeValue = null;
        NodeList uriNodes = theElement.getElementsByTagName(theNodeName);
        if (uriNodes != null && (uriNode = (Element)uriNodes.item(0)) != null) {
            theNodeValue = uriNode.getTextContent();
        }
        return theNodeValue;
    }

    public String getID() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public DataSetDefinition getDataSetDefinition() {
        return this.dsd;
    }

    public DataReader getDataIO(String id) {
        return this.dataIO.get(id);
    }

    public String getMissingDataValue() {
        return this.missingDataValue;
    }

    public int getAccessMode() {
        return this.accessMode;
    }
}

