/*
 * Decompiled with CFR 0.152.
 */
package jams.meta;

import jams.JAMSException;
import jams.JAMSProperties;
import jams.data.JAMSEntity;
import jams.meta.ComponentDescriptor;
import jams.meta.ComponentField;
import jams.meta.ContextAttribute;
import jams.meta.ContextDescriptor;
import jams.meta.ModelDescriptor;
import jams.meta.ModelIO;
import jams.meta.ModelNode;
import jams.meta.NodeFactory;
import jams.runtime.JAMSClassLoader;
import jams.runtime.RuntimeLogger;
import jams.runtime.StandardRuntime;
import jams.tools.StringTools;
import jams.tools.XMLTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;

public class IOTest {
    public static void main(String[] args) throws IOException {
        JAMSProperties properties = JAMSProperties.createProperties();
        properties.load("d:/jamsapplication/nsk.jap");
        String[] libs = StringTools.toArray(properties.getProperty("libs", ""), ";");
        StandardRuntime runtime = new StandardRuntime(properties);
        ClassLoader classLoader = JAMSClassLoader.createClassLoader(libs, new RuntimeLogger());
        ModelIO io = new ModelIO(new NodeFactory(){

            @Override
            public ModelNode createNode(ComponentDescriptor cd) {
                return new ModelNode(cd);
            }
        });
        Document doc = XMLTools.getDocument("d:/jamsapplication/JAMS-Gehlberg/j2k_gehlberg.jam");
        ModelDescriptor md = null;
        try {
            md = io.loadModelDescriptor(doc, classLoader, true);
        }
        catch (JAMSException jex) {
            System.out.println((Object)jex);
        }
        System.out.println(md.getAuthor());
        System.out.println(md.getDescription());
        ArrayList<ComponentField> fields = md.getParameterFields();
        for (ComponentField field : fields) {
            System.out.println(field.getParent().getInstanceName() + "." + field.getName());
        }
        ComponentDescriptor cd = md.getComponentDescriptor("TmeanRegionaliser");
        ComponentField dataValueField = cd.getComponentFields().get("dataValue");
        ArrayList<ContextAttribute> tmean = dataValueField.getContextAttributes();
        ContextAttribute ca = tmean.get(0);
        ca.setName("mytmean");
        IOTest.output(md.getRootNode(), 0);
        ContextDescriptor context = (ContextDescriptor)md.getComponentDescriptor("HRULoop");
        HashMap<String, ContextAttribute> attribs = context.getAttributes(JAMSEntity.class);
        for (ContextAttribute attrib : attribs.values()) {
            System.out.println(attrib.getName() + " [" + attrib.getType() + "]");
        }
        ContextDescriptor ccopy = context.cloneNode();
        attribs = ccopy.getAttributes(JAMSEntity.class);
        for (ContextAttribute attrib : attribs.values()) {
            attrib.setName(attrib.getName() + "__");
            System.out.println(attrib.getName() + " [" + attrib.getType() + "]");
        }
        attribs = context.getAttributes(JAMSEntity.class);
        for (ContextAttribute attrib : attribs.values()) {
            System.out.println(attrib.getName() + " [" + attrib.getType() + "]");
        }
        Document doc2 = io.getModelDocument(md);
        XMLTools.writeXmlFile(doc, "d:/doc1.xml");
        XMLTools.writeXmlFile(doc2, "d:/doc2.xml");
    }

    static void output(ComponentDescriptor cd, String indent) {
        System.out.println(indent + cd.getInstanceName() + " [" + cd.getClazz() + "] " + cd.getNode().getType());
        HashMap<String, ComponentField> fields = cd.getComponentFields();
        for (String fieldName : fields.keySet()) {
            ComponentField field = fields.get(fieldName);
            System.out.println(indent + "    " + fieldName + " [" + field.getContext() + "->" + field.getAttribute() + "] [" + field.getValue() + "]");
        }
    }

    static void output(ModelNode node, int level) {
        int i;
        String indent = "";
        for (i = 0; i < level; ++i) {
            indent = indent + "    ";
        }
        IOTest.output((ComponentDescriptor)node.getUserObject(), indent);
        for (i = 0; i < node.getChildCount(); ++i) {
            IOTest.output((ModelNode)node.getChildAt(i), level + 1);
        }
    }
}

