/*
 * Decompiled with CFR 0.152.
 */
package jams.meta;

import jams.tools.StringTools;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HelpComponent {
    private String helpURL = "";
    private String helpText = "";

    public HelpComponent() {
    }

    public HelpComponent(Element domElement) {
        NodeList childNodes = domElement.getChildNodes();
        for (int pindex = 0; pindex < childNodes.getLength(); ++pindex) {
            Node node = childNodes.item(pindex);
            if (!node.getNodeName().equalsIgnoreCase("help")) continue;
            Element helpElement = (Element)node;
            NodeList helpTextNodes = helpElement.getElementsByTagName("text");
            for (int l = 0; l < helpTextNodes.getLength(); ++l) {
                Node helpTextNode = helpTextNodes.item(l);
                this.helpText = helpTextNode.getTextContent();
            }
            NodeList helpURLNodes = helpElement.getElementsByTagName("url");
            for (int l = 0; l < helpURLNodes.getLength(); ++l) {
                Node helpURLNode = helpURLNodes.item(l);
                this.helpURL = helpURLNode.getTextContent();
            }
        }
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public void setHelpURL(String helpURL) {
        this.helpURL = helpURL;
    }

    public boolean isEmpty() {
        return !this.hasHelpText() && !this.hasHelpURL();
    }

    public boolean hasHelpText() {
        return !StringTools.isEmptyString(this.helpText);
    }

    public boolean hasHelpURL() {
        return !StringTools.isEmptyString(this.helpURL);
    }

    public Element createDOMElement(Document document) throws DOMException {
        Element helpElement = document.createElement("help");
        if (this.hasHelpText()) {
            Element helpTextElement = document.createElement("text");
            helpTextElement.setTextContent(this.getHelpText());
            helpElement.appendChild(helpTextElement);
        }
        if (this.hasHelpURL()) {
            Element helpURLElement = document.createElement("url");
            helpURLElement.setTextContent(this.getHelpURL());
            helpElement.appendChild(helpURLElement);
        }
        return helpElement;
    }
}

