/*
 * Decompiled with CFR 0.152.
 */
package jams.meta;

import jams.JAMS;
import jams.JAMSLogging;
import jams.meta.ComponentDescriptor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.logging.Logger;

public class ComponentCollection {
    private HashMap<String, ComponentDescriptor> componentDescriptors = new HashMap();

    public String registerComponentDescriptor(String oldName, String newName, ComponentDescriptor cd) {
        String newNewName = this.createComponentInstanceName(newName);
        if (cd.equals(this.componentDescriptors.get(oldName))) {
            this.componentDescriptors.remove(oldName);
        }
        this.componentDescriptors.put(newNewName, cd);
        if (!newName.equals(newNewName)) {
            JAMSLogging.registerLogger(Logger.getLogger(this.getClass().getName()));
            Logger.getLogger(this.getClass().getName()).fine(MessageFormat.format(JAMS.i18n("Component_name_is_already_in_use._Renamed_component_to_"), newName, newNewName));
        }
        return newNewName;
    }

    public void unRegisterComponentDescriptor(ComponentDescriptor cd) {
        this.componentDescriptors.remove(cd.getInstanceName());
    }

    public String createComponentInstanceName(String name) {
        return name;
    }

    public HashMap<String, ComponentDescriptor> getComponentDescriptors() {
        return this.componentDescriptors;
    }

    public ComponentDescriptor getComponentDescriptor(String name) {
        return this.componentDescriptors.get(name);
    }
}

