/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.layout;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.layout.ObservableCachingLayout;
import edu.uci.ics.jung.visualization.layout.PersistentLayout;
import edu.uci.ics.jung.visualization.util.Caching;
import edu.uci.ics.jung.visualization.util.ChangeEventSupport;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.map.LazyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentLayoutImpl<V, E>
extends ObservableCachingLayout<V, E>
implements PersistentLayout<V, E>,
ChangeEventSupport,
Caching {
    protected Map<V, PersistentLayout.Point> map = LazyMap.decorate(new HashMap(), new RandomPointFactory(this.getSize()));
    protected Set<V> dontmove = new HashSet<V>();
    protected boolean locked;

    public PersistentLayoutImpl(Layout<V, E> layout) {
        super(layout);
    }

    protected void initializeLocations() {
        for (Object v : this.getGraph().getVertices()) {
            Point2D coord = (Point2D)this.delegate.transform(v);
            if (this.dontmove.contains(v)) continue;
            this.initializeLocation(v, coord, this.getSize());
        }
    }

    protected void initializeLocation(V v, Point2D coord, Dimension d) {
        PersistentLayout.Point point = this.map.get(v);
        coord.setLocation(point.x, point.y);
    }

    @Override
    public void persist(String fileName) throws IOException {
        for (Object v : this.getGraph().getVertices()) {
            PersistentLayout.Point p = new PersistentLayout.Point((Point2D)this.transform(v));
            this.map.put((PersistentLayout.Point)v, p);
        }
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fileName));
        oos.writeObject(this.map);
        oos.close();
    }

    @Override
    public void restore(String fileName) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(fileName));
        this.map = (Map)ois.readObject();
        ois.close();
        this.initializeLocations();
        this.locked = true;
        this.fireStateChanged();
    }

    @Override
    public void lock(boolean locked) {
        this.locked = locked;
    }

    @Override
    public boolean done() {
        return super.done() || this.locked;
    }

    public void lock(V v, boolean state) {
        this.dontmove.add(v);
        this.delegate.lock(v, state);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RandomPointFactory
    implements Factory<PersistentLayout.Point>,
    Serializable {
        Dimension d;

        public RandomPointFactory(Dimension d) {
            this.d = d;
        }

        @Override
        public PersistentLayout.Point create() {
            double x = Math.random() * (double)this.d.width;
            double y = Math.random() * (double)this.d.height;
            return new PersistentLayout.Point(x, y);
        }
    }
}

