/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.MapTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelEditingGraphMousePlugin<V, E>
extends AbstractGraphMousePlugin
implements MouseListener {
    protected V vertex;
    protected E edge;

    public LabelEditingGraphMousePlugin() {
        this(16);
    }

    public LabelEditingGraphMousePlugin(int selectionModifiers) {
        super(selectionModifiers);
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getModifiers() == this.modifiers && e.getClickCount() == 2) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            GraphElementAccessor pickSupport = vv.getPickSupport();
            if (pickSupport != null) {
                Transformer es;
                Transformer vs = vv.getRenderContext().getVertexLabelTransformer();
                if (vs instanceof MapTransformer) {
                    Point p;
                    Map map = ((MapTransformer)vs).getMap();
                    Layout layout = vv.getGraphLayout();
                    Object vertex = pickSupport.getVertex(layout, ((Point2D)(p = e.getPoint())).getX(), ((Point2D)p).getY());
                    if (vertex != null) {
                        String newLabel = vs.transform(vertex);
                        newLabel = JOptionPane.showInputDialog("New Vertex Label for " + vertex);
                        if (newLabel != null) {
                            map.put(vertex, newLabel);
                            vv.repaint();
                        }
                        return;
                    }
                }
                if ((es = vv.getRenderContext().getEdgeLabelTransformer()) instanceof MapTransformer) {
                    Map map = ((MapTransformer)es).getMap();
                    Layout layout = vv.getGraphLayout();
                    Point p = e.getPoint();
                    Point2D ip = vv.getRenderContext().getMultiLayerTransformer().inverseTransform(Layer.VIEW, p);
                    Object edge = pickSupport.getEdge(layout, ip.getX(), ip.getY());
                    if (edge != null) {
                        String newLabel = JOptionPane.showInputDialog("New Edge Label for " + edge);
                        if (newLabel != null) {
                            map.put(edge, newLabel);
                            vv.repaint();
                        }
                        return;
                    }
                }
            }
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

