/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.xswingx.demo;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.xswingx.JXSearchField;
import org.jdesktop.xswingx.NativeSearchFieldSupport;
import org.jdesktop.xswingx.demo.CustomizePanel;
import org.jdesktop.xswingx.demo.TitledSeparator;

public class CustomizeSearchPanel
extends CustomizePanel {
    private TitledSeparator titledSeparator1;
    private JLabel label1;
    private JRadioButton rbRegular;
    private JPanel panel1;
    private JLabel label3;
    private JRadioButton rbInstant;
    private JSpinner spnDelay;
    private JLabel label2;
    private JPanel panel2;
    private JLabel label4;
    private JLabel label5;
    private JPanel panel3;
    private JRadioButton rbMac;
    private JRadioButton rbVista;
    private JCheckBox cbWithPopup;
    private JPanel panel5;
    private JCheckBox cbUseSeperate;
    private JCheckBox cbUseNative;
    private JPanel panel4;
    private JButton btnResetStyle;
    private JLabel label6;

    public CustomizeSearchPanel() {
        this.initComponents();
    }

    public void setField(JTextComponent textComponent) {
        super.setField(textComponent);
        this.spnDelay.setValue(this.getSearchField().getInstantSearchDelay());
        this.cbUseNative.setSelected(this.getSearchField().isUseNativeSearchFieldIfPossible());
        this.cbUseNative.setEnabled(NativeSearchFieldSupport.isNativeSearchFieldSupported());
        this.cbUseSeperate.setSelected(this.getSearchField().isUseSeperatePopupButton());
        if (this.getSearchField().isVistaLayoutStyle()) {
            this.rbVista.setSelected(true);
        } else {
            this.rbMac.setSelected(true);
        }
    }

    private JXSearchField getSearchField() {
        return (JXSearchField)this.getField();
    }

    private void searchModeChanged(ChangeEvent e) {
        if (this.rbRegular.isSelected()) {
            this.getSearchField().setSearchMode(JXSearchField.SearchMode.REGULAR);
        } else {
            this.getSearchField().setSearchMode(JXSearchField.SearchMode.INSTANT);
        }
        this.changed();
    }

    private void spnDelayStateChanged(ChangeEvent e) {
        this.getSearchField().setInstantSearchDelay((Integer)this.spnDelay.getValue());
    }

    private void cbUseNativeStateChanged(ChangeEvent e) {
        this.getSearchField().setUseNativeSearchFieldIfPossible(this.cbUseNative.isSelected());
        boolean nat = this.cbUseNative.isSelected() && this.cbUseNative.isEnabled();
        this.rbMac.setEnabled(!nat);
        this.rbVista.setEnabled(!nat);
        this.cbUseSeperate.setEnabled(!nat);
        this.changed();
    }

    private void styleChanged(ChangeEvent e) {
        if (this.rbMac.isSelected()) {
            this.getSearchField().setLayoutStyle(JXSearchField.LayoutStyle.MAC);
        } else {
            this.getSearchField().setLayoutStyle(JXSearchField.LayoutStyle.VISTA);
        }
        this.changed();
    }

    private void cbWithPopupStateChanged(ChangeEvent e) {
        if (this.cbWithPopup.isSelected()) {
            this.getSearchField().setRecentSearchesSaveKey("demoSearch");
        } else {
            this.getSearchField().setRecentSearchesSaveKey(null);
        }
    }

    private void cbUseSeperateStateChanged(ChangeEvent e) {
        this.getSearchField().setUseSeperatePopupButton(this.cbUseSeperate.isSelected());
    }

    private void btnResetStyleActionPerformed(ActionEvent e) {
        if (UIManager.getBoolean("SearchField.useSeperatePopupButton")) {
            this.getSearchField().customSetUIProperty("useSeperatePopupButton", Boolean.TRUE, true);
        } else {
            this.getSearchField().customSetUIProperty("useSeperatePopupButton", Boolean.FALSE, true);
        }
        this.getSearchField().customSetUIProperty("layoutStyle", UIManager.get("SearchField.layoutStyle"), true);
        this.getSearchField().customSetUIProperty("promptFontStyle", UIManager.get("SearchField.promptFontStyle"), true);
        this.setField(this.getSearchField());
    }

    private void initComponents() {
        this.titledSeparator1 = new TitledSeparator();
        this.label1 = new JLabel();
        this.rbRegular = new JRadioButton();
        this.panel1 = new JPanel();
        this.label3 = new JLabel();
        this.rbInstant = new JRadioButton();
        this.spnDelay = new JSpinner();
        this.label2 = new JLabel();
        this.panel2 = new JPanel();
        this.label4 = new JLabel();
        this.label5 = new JLabel();
        this.panel3 = new JPanel();
        this.rbMac = new JRadioButton();
        this.rbVista = new JRadioButton();
        this.cbWithPopup = new JCheckBox();
        this.panel5 = new JPanel();
        this.cbUseSeperate = new JCheckBox();
        this.cbUseNative = new JCheckBox();
        this.panel4 = new JPanel();
        this.btnResetStyle = new JButton();
        this.label6 = new JLabel();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.PARAGRAPH_GAP_ROWSPEC, new RowSpec(RowSpec.TOP, (Size)Sizes.DEFAULT, 0.0), FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.titledSeparator1.setTitle("Search");
        this.add((Component)this.titledSeparator1, cc.xywh(1, 1, 8, 1));
        this.label1.setText("Search Mode:");
        this.add((Component)this.label1, cc.xy(2, 3));
        this.rbRegular.setText("Regular");
        this.rbRegular.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeSearchPanel.this.searchModeChanged(e);
            }
        });
        this.add((Component)this.rbRegular, cc.xy(4, 3));
        this.panel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs((String)"default")));
        this.label3.setText("<html>Search when the user clicks the search icon or presses Enter.");
        this.label3.setFont(this.label3.getFont().deriveFont((float)this.label3.getFont().getSize() - 1.0f));
        this.panel1.add((Component)this.label3, cc.xywh(2, 1, 5, 1));
        this.add((Component)this.panel1, cc.xywh(4, 5, 5, 1));
        this.rbInstant.setText("Instant, with");
        this.rbInstant.setSelected(true);
        this.rbInstant.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeSearchPanel.this.searchModeChanged(e);
            }
        });
        this.add((Component)this.rbInstant, cc.xy(4, 7));
        this.spnDelay.setModel(new SpinnerNumberModel(200, 0, 999, 1));
        this.spnDelay.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeSearchPanel.this.spnDelayStateChanged(e);
            }
        });
        this.add((Component)this.spnDelay, cc.xy(6, 7));
        this.label2.setText("Milliseconds delay.");
        this.add((Component)this.label2, cc.xy(8, 7));
        this.panel2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs((String)"default")));
        this.label4.setText("<html>Also search when the text search string changes.");
        this.label4.setFont(this.label4.getFont().deriveFont((float)this.label4.getFont().getSize() - 1.0f));
        this.panel2.add((Component)this.label4, cc.xywh(2, 1, 5, 1));
        this.add((Component)this.panel2, cc.xywh(4, 9, 5, 1));
        this.label5.setText("Style:");
        this.add((Component)this.label5, cc.xy(2, 11));
        this.panel3.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.rbMac.setText("Mac");
        this.rbMac.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeSearchPanel.this.styleChanged(e);
            }
        });
        this.panel3.add((Component)this.rbMac, cc.xy(1, 1));
        this.rbVista.setText("Vista");
        this.rbVista.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeSearchPanel.this.styleChanged(e);
            }
        });
        this.panel3.add((Component)this.rbVista, cc.xy(3, 1));
        this.cbWithPopup.setText("With Popup Menu (Recent Searches)");
        this.cbWithPopup.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeSearchPanel.this.cbWithPopupStateChanged(e);
            }
        });
        this.panel3.add((Component)this.cbWithPopup, cc.xywh(1, 3, 5, 1));
        this.panel5.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs((String)"default")));
        this.cbUseSeperate.setText("Use Seperate Popup Button");
        this.cbUseSeperate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeSearchPanel.this.cbUseSeperateStateChanged(e);
            }
        });
        this.panel5.add((Component)this.cbUseSeperate, cc.xywh(2, 1, 2, 1));
        this.panel3.add((Component)this.panel5, cc.xywh(1, 5, 5, 1));
        this.cbUseNative.setText("Use Native Search Field (Mac OS X Leopard only)");
        this.cbUseNative.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizeSearchPanel.this.cbUseNativeStateChanged(e);
            }
        });
        this.panel3.add((Component)this.cbUseNative, cc.xywh(1, 7, 5, 1));
        this.add((Component)this.panel3, cc.xywh(4, 11, 5, 1));
        this.panel4.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, RowSpec.decodeSpecs((String)"default")));
        this.btnResetStyle.setText("Set Default Style");
        this.btnResetStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomizeSearchPanel.this.btnResetStyleActionPerformed(e);
            }
        });
        this.panel4.add((Component)this.btnResetStyle, cc.xy(1, 1));
        this.label6.setText("Depending on the current Look and Feel.");
        this.label6.setEnabled(false);
        this.panel4.add((Component)this.label6, cc.xywh(3, 1, 3, 1));
        this.add((Component)this.panel4, cc.xywh(4, 13, 5, 1));
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.rbRegular);
        buttonGroup1.add(this.rbInstant);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.rbMac);
        buttonGroup2.add(this.rbVista);
    }
}

