/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.xswingx.demo;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.xswingx.PromptSupport;
import org.jdesktop.xswingx.demo.CustomizePanel;
import org.jdesktop.xswingx.demo.TitledSeparator;

public class CustomizePromptPanel
extends CustomizePanel {
    private TitledSeparator titledSeparator1;
    private JLabel label5;
    private JTextField txtPrompt;
    private JPanel panel1;
    private JLabel label1;
    private JRadioButton rbHide;
    private JRadioButton rbShow;
    private JRadioButton rbHighlight;
    private JPanel panel2;
    private JLabel label2;
    private JRadioButton rbDefaultForeground;
    private JRadioButton rbRedForeground;
    private JLabel label3;
    private JRadioButton rbDefaultBackground;
    private JRadioButton rbYelowBackground;
    private JLabel label4;
    private JRadioButton rbDefaultFont;
    private JRadioButton rbItalicFont;
    private JRadioButton rbBoldFont;
    private JRadioButton rbBoldItalicFont;

    public CustomizePromptPanel() {
        this.initComponents();
    }

    public void setField(JTextComponent textComponent) {
        super.setField(textComponent);
        this.promptChanged(null);
        this.focusBehaviorChanged(null);
        this.backgroundChanged(null);
        this.foregroundChanged(null);
        this.fontChanged(null);
    }

    private void promptChanged(KeyEvent e) {
        PromptSupport.setPrompt(this.txtPrompt.getText(), this.getField());
        this.changed();
    }

    private void focusBehaviorChanged(ChangeEvent e) {
        PromptSupport.FocusBehavior fb = PromptSupport.FocusBehavior.HIDE_PROMPT;
        if (this.rbShow.isSelected()) {
            fb = PromptSupport.FocusBehavior.SHOW_PROMPT;
        } else if (this.rbHighlight.isSelected()) {
            fb = PromptSupport.FocusBehavior.HIGHLIGHT_PROMPT;
        }
        PromptSupport.setFocusBehavior(fb, this.getField());
        this.changed();
    }

    private void foregroundChanged(ChangeEvent e) {
        Color fg = this.getField().getDisabledTextColor();
        if (this.rbRedForeground.isSelected()) {
            fg = Color.red;
        }
        PromptSupport.setForeground(fg, this.getField());
        this.changed();
    }

    private void backgroundChanged(ChangeEvent e) {
        Color bg = this.getField().getBackground();
        if (this.rbYelowBackground.isSelected()) {
            bg = Color.yellow;
        }
        PromptSupport.setBackground(bg, this.getField());
        this.changed();
    }

    private void fontChanged(ChangeEvent e) {
        if (this.rbBoldFont.isSelected()) {
            PromptSupport.setFontStyle(1, this.getField());
        } else if (this.rbItalicFont.isSelected()) {
            PromptSupport.setFontStyle(2, this.getField());
        } else if (this.rbBoldItalicFont.isSelected()) {
            PromptSupport.setFontStyle(3, this.getField());
        } else {
            PromptSupport.setFontStyle(null, this.getField());
        }
        this.changed();
    }

    public void setPrompt(String prompt) {
        this.txtPrompt.setText(prompt);
        this.promptChanged(null);
    }

    public String getPrompt() {
        return this.txtPrompt.getText();
    }

    private void initComponents() {
        this.titledSeparator1 = new TitledSeparator();
        this.label5 = new JLabel();
        this.txtPrompt = new JTextField();
        this.panel1 = new JPanel();
        this.label1 = new JLabel();
        this.rbHide = new JRadioButton();
        this.rbShow = new JRadioButton();
        this.rbHighlight = new JRadioButton();
        this.panel2 = new JPanel();
        this.label2 = new JLabel();
        this.rbDefaultForeground = new JRadioButton();
        this.rbRedForeground = new JRadioButton();
        this.label3 = new JLabel();
        this.rbDefaultBackground = new JRadioButton();
        this.rbYelowBackground = new JRadioButton();
        this.label4 = new JLabel();
        this.rbDefaultFont = new JRadioButton();
        this.rbItalicFont = new JRadioButton();
        this.rbBoldFont = new JRadioButton();
        this.rbBoldItalicFont = new JRadioButton();
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.UNRELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.titledSeparator1.setTitle("Prompt");
        this.add((Component)this.titledSeparator1, cc.xywh(1, 1, 4, 1));
        this.label5.setText("Prompt:");
        this.add((Component)this.label5, cc.xy(2, 3));
        this.txtPrompt.setText("Hello, I'm a plain JTextField. Come play with me...");
        this.txtPrompt.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                CustomizePromptPanel.this.promptChanged(e);
            }

            public void keyPressed(KeyEvent e) {
                CustomizePromptPanel.this.promptChanged(e);
            }

            public void keyReleased(KeyEvent e) {
                CustomizePromptPanel.this.promptChanged(e);
            }
        });
        this.add((Component)this.txtPrompt, cc.xy(4, 3));
        this.panel1.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.UNRELATED_GAP_COLSPEC, FormFactory.PREF_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0)}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.label1.setText("When this component has the focus, the prompt should be:");
        this.panel1.add((Component)this.label1, cc.xywh(1, 1, 10, 1));
        this.rbHide.setText("Hidden");
        this.rbHide.setSelected(true);
        this.rbHide.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizePromptPanel.this.focusBehaviorChanged(e);
            }
        });
        this.panel1.add((Component)this.rbHide, cc.xy(2, 3));
        this.rbShow.setText("Shown");
        this.rbShow.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizePromptPanel.this.focusBehaviorChanged(e);
            }
        });
        this.panel1.add((Component)this.rbShow, cc.xy(4, 3));
        this.rbHighlight.setText("Highlighted (Selected)");
        this.rbHighlight.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizePromptPanel.this.focusBehaviorChanged(e);
            }
        });
        this.panel1.add((Component)this.rbHighlight, cc.xy(6, 3));
        this.add((Component)this.panel1, cc.xywh(2, 5, 3, 1));
        this.panel2.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{new ColumnSpec(ColumnSpec.RIGHT, (Size)Sizes.PREFERRED, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.UNRELATED_GAP_COLSPEC, new ColumnSpec(ColumnSpec.LEFT, (Size)Sizes.DEFAULT, 0.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.label2.setText("Foreground:");
        this.label2.setHorizontalAlignment(4);
        this.panel2.add((Component)this.label2, cc.xy(1, 1));
        this.rbDefaultForeground.setText("Default");
        this.rbDefaultForeground.setSelected(true);
        this.rbDefaultForeground.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizePromptPanel.this.foregroundChanged(e);
            }
        });
        this.panel2.add((Component)this.rbDefaultForeground, cc.xy(3, 1));
        this.rbRedForeground.setText("Red");
        this.rbRedForeground.setForeground(Color.red);
        this.rbRedForeground.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizePromptPanel.this.foregroundChanged(e);
            }
        });
        this.panel2.add((Component)this.rbRedForeground, cc.xy(5, 1));
        this.label3.setText("Background:");
        this.label3.setHorizontalAlignment(4);
        this.panel2.add((Component)this.label3, cc.xy(1, 3));
        this.rbDefaultBackground.setText("Default");
        this.rbDefaultBackground.setSelected(true);
        this.rbDefaultBackground.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizePromptPanel.this.backgroundChanged(e);
            }
        });
        this.panel2.add((Component)this.rbDefaultBackground, cc.xy(3, 3));
        this.rbYelowBackground.setText("Yellow");
        this.rbYelowBackground.setBackground(Color.yellow);
        this.rbYelowBackground.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizePromptPanel.this.backgroundChanged(e);
            }
        });
        this.panel2.add((Component)this.rbYelowBackground, cc.xy(5, 3));
        this.label4.setText("Font:");
        this.label4.setHorizontalAlignment(4);
        this.panel2.add((Component)this.label4, cc.xy(1, 5));
        this.rbDefaultFont.setText("Default");
        this.rbDefaultFont.setSelected(true);
        this.rbDefaultFont.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizePromptPanel.this.fontChanged(e);
            }
        });
        this.panel2.add((Component)this.rbDefaultFont, cc.xy(3, 5));
        this.rbItalicFont.setText("Italic");
        this.rbItalicFont.setFont(this.rbItalicFont.getFont().deriveFont(this.rbItalicFont.getFont().getStyle() | 2));
        this.rbItalicFont.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizePromptPanel.this.fontChanged(e);
            }
        });
        this.panel2.add((Component)this.rbItalicFont, cc.xy(5, 5));
        this.rbBoldFont.setText("Bold");
        this.rbBoldFont.setFont(this.rbBoldFont.getFont().deriveFont(this.rbBoldFont.getFont().getStyle() | 1));
        this.rbBoldFont.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizePromptPanel.this.fontChanged(e);
            }
        });
        this.panel2.add((Component)this.rbBoldFont, cc.xy(7, 5));
        this.rbBoldItalicFont.setText("Bold & Italic");
        this.rbBoldItalicFont.setFont(this.rbBoldItalicFont.getFont().deriveFont(3));
        this.rbBoldItalicFont.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomizePromptPanel.this.fontChanged(e);
            }
        });
        this.panel2.add((Component)this.rbBoldItalicFont, cc.xy(9, 5));
        this.add((Component)this.panel2, cc.xywh(2, 7, 3, 1));
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.rbHide);
        buttonGroup1.add(this.rbShow);
        buttonGroup1.add(this.rbHighlight);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.rbDefaultForeground);
        buttonGroup2.add(this.rbRedForeground);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.rbDefaultBackground);
        buttonGroup3.add(this.rbYelowBackground);
        ButtonGroup buttonGroup4 = new ButtonGroup();
        buttonGroup4.add(this.rbDefaultFont);
        buttonGroup4.add(this.rbItalicFont);
        buttonGroup4.add(this.rbBoldFont);
        buttonGroup4.add(this.rbBoldItalicFont);
    }
}

