/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.view.ViewPropertyLimits;

public class BasicViewPropertyLimits
implements ViewPropertyLimits {
    protected Sector eyeLocationLimits = Sector.FULL_SPHERE;
    protected Angle minHeading;
    protected Angle maxHeading;
    protected Angle minPitch;
    protected Angle maxPitch;
    protected Angle minRoll;
    protected Angle maxRoll;
    protected double minEyeElevation = -1.7976931348623157E308;
    protected double maxEyeElevation = Double.MAX_VALUE;

    public BasicViewPropertyLimits() {
        this.minHeading = Angle.NEG180;
        this.maxHeading = Angle.POS180;
        this.minPitch = Angle.ZERO;
        this.maxPitch = Angle.POS90;
        this.minRoll = Angle.NEG180;
        this.maxRoll = Angle.POS180;
    }

    @Override
    public Sector getEyeLocationLimits() {
        return this.eyeLocationLimits;
    }

    @Override
    public void setEyeLocationLimits(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.eyeLocationLimits = sector;
    }

    @Override
    public double[] getEyeElevationLimits() {
        return new double[]{this.minEyeElevation, this.maxEyeElevation};
    }

    @Override
    public void setEyeElevationLimits(double d, double d2) {
        this.minEyeElevation = d;
        this.maxEyeElevation = d2;
    }

    @Override
    public Angle[] getHeadingLimits() {
        return new Angle[]{this.minHeading, this.maxHeading};
    }

    @Override
    public void setHeadingLimits(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.MinOrMaxAngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minHeading = angle;
        this.maxHeading = angle2;
    }

    @Override
    public Angle[] getPitchLimits() {
        return new Angle[]{this.minPitch, this.maxPitch};
    }

    @Override
    public void setPitchLimits(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.MinOrMaxAngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minPitch = angle;
        this.maxPitch = angle2;
    }

    @Override
    public Angle[] getRollLimits() {
        return new Angle[]{this.minRoll, this.maxRoll};
    }

    @Override
    public void setRollLimits(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.MinOrMaxAngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.minRoll = angle;
        this.maxRoll = angle2;
    }

    public static Angle limitHeading(Angle angle, ViewPropertyLimits viewPropertyLimits) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (viewPropertyLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle[] angleArray = viewPropertyLimits.getHeadingLimits();
        Angle angle2 = angle;
        if (angle.compareTo(angleArray[0]) < 0) {
            angle2 = angleArray[0];
        } else if (angle.compareTo(angleArray[1]) > 0) {
            angle2 = angleArray[1];
        }
        return angle2;
    }

    public static Angle limitPitch(Angle angle, ViewPropertyLimits viewPropertyLimits) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (viewPropertyLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle[] angleArray = viewPropertyLimits.getPitchLimits();
        Angle angle2 = angle;
        if (angle.compareTo(angleArray[0]) < 0) {
            angle2 = angleArray[0];
        } else if (angle.compareTo(angleArray[1]) > 0) {
            angle2 = angleArray[1];
        }
        return angle2;
    }

    public static Angle limitRoll(Angle angle, ViewPropertyLimits viewPropertyLimits) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (viewPropertyLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle[] angleArray = viewPropertyLimits.getRollLimits();
        Angle angle2 = angle;
        if (angle.compareTo(angleArray[0]) < 0) {
            angle2 = angleArray[0];
        } else if (angle.compareTo(angleArray[1]) > 0) {
            angle2 = angleArray[1];
        }
        return angle2;
    }

    public static double limitEyeElevation(double d, ViewPropertyLimits viewPropertyLimits) {
        if (viewPropertyLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = d;
        double[] dArray = viewPropertyLimits.getEyeElevationLimits();
        if (d < dArray[0]) {
            d2 = dArray[0];
        } else if (d > dArray[1]) {
            d2 = dArray[1];
        }
        return d2;
    }

    public static LatLon limitEyePositionLocation(Angle angle, Angle angle2, ViewPropertyLimits viewPropertyLimits) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (viewPropertyLimits == null) {
            String string = Logging.getMessage("nullValue.ViewLimitsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Sector sector = viewPropertyLimits.getEyeLocationLimits();
        Angle angle3 = angle;
        Angle angle4 = angle2;
        if (angle.compareTo(sector.getMinLatitude()) < 0) {
            angle3 = sector.getMinLatitude();
        } else if (angle.compareTo(sector.getMaxLatitude()) > 0) {
            angle3 = sector.getMaxLatitude();
        }
        if (angle2.compareTo(sector.getMinLongitude()) < 0) {
            angle4 = sector.getMinLongitude();
        } else if (angle2.compareTo(sector.getMaxLongitude()) > 0) {
            angle4 = sector.getMaxLongitude();
        }
        return new LatLon(angle3, angle4);
    }

    @Override
    public void getRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        restorableSupport.addStateValueAsSector(stateObject, "eyeLocationLimits", this.eyeLocationLimits);
        restorableSupport.addStateValueAsDouble(stateObject, "minEyeElevation", this.minEyeElevation);
        restorableSupport.addStateValueAsDouble(stateObject, "maxEyeElevation", this.maxEyeElevation);
        restorableSupport.addStateValueAsDouble(stateObject, "minHeadingDegrees", this.minHeading.degrees);
        restorableSupport.addStateValueAsDouble(stateObject, "maxHeadingDegrees", this.maxHeading.degrees);
        restorableSupport.addStateValueAsDouble(stateObject, "minPitchDegrees", this.minPitch.degrees);
        restorableSupport.addStateValueAsDouble(stateObject, "maxPitchDegrees", this.maxPitch.degrees);
    }

    @Override
    public void restoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Double d;
        Sector sector = restorableSupport.getStateValueAsSector(stateObject, "eyeLocationLimits");
        if (sector != null) {
            this.setEyeLocationLimits(sector);
        }
        double[] dArray = this.getEyeElevationLimits();
        Double d2 = restorableSupport.getStateValueAsDouble(stateObject, "minEyeElevation");
        if (d2 != null) {
            dArray[0] = d2;
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "maxEyeElevation")) != null) {
            dArray[1] = d;
        }
        if (d2 != null || d != null) {
            this.setEyeElevationLimits(dArray[0], dArray[1]);
        }
        Angle[] angleArray = this.getHeadingLimits();
        d2 = restorableSupport.getStateValueAsDouble(stateObject, "minHeadingDegrees");
        if (d2 != null) {
            angleArray[0] = Angle.fromDegrees(d2);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "maxHeadingDegrees")) != null) {
            angleArray[1] = Angle.fromDegrees(d);
        }
        if (d2 != null || d != null) {
            this.setHeadingLimits(angleArray[0], angleArray[1]);
        }
        angleArray = this.getPitchLimits();
        d2 = restorableSupport.getStateValueAsDouble(stateObject, "minPitchDegrees");
        if (d2 != null) {
            angleArray[0] = Angle.fromDegrees(d2);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "maxPitchDegrees")) != null) {
            angleArray[1] = Angle.fromDegrees(d);
        }
        if (d2 != null || d != null) {
            this.setPitchLimits(angleArray[0], angleArray[1]);
        }
    }
}

