/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import com.jogamp.common.nio.Buffers;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.event.BulkRetrievalListener;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.retrieve.AbstractRetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.BulkRetrievable;
import gov.nasa.worldwind.retrieve.BulkRetrievalThread;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.RetrieverFactory;
import gov.nasa.worldwind.terrain.AbstractElevationModel;
import gov.nasa.worldwind.terrain.BasicElevationModelBulkDownloader;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.DataConfigurationUtils;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.SessionCacheUtils;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileKey;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.xml.xpath.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicElevationModel
extends AbstractElevationModel
implements BulkRetrievable {
    protected final LevelSet levels;
    protected final double minElevation;
    protected final double maxElevation;
    protected String elevationDataType = "gov.nasa.worldwind.avkey.Int16";
    protected String elevationDataByteOrder = "gov.nasa.worldwind.avkey.LittleEndian";
    protected double detailHint = 0.0;
    protected final Object fileLock = new Object();
    protected ConcurrentHashMap<TileKey, ElevationTile> levelZeroTiles = new ConcurrentHashMap();
    protected MemoryCache memoryCache;
    protected int extremesLevel = -1;
    protected BufferWrapper extremes = null;
    protected MemoryCache extremesLookupCache;
    protected static final int RESOURCE_ID_OGC_CAPABILITIES = 1;

    public BasicElevationModel(AVList aVList) {
        Boolean bl;
        Double d;
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ElevationModelConfigParams");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.ByteOrder");
        if (string != null) {
            this.setByteOrder(string);
        }
        if ((d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.DetailHint")) != null) {
            this.setDetailHint(d);
        }
        if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.DisplayName")) != null) {
            this.setName(string);
        }
        this.minElevation = (d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.ElevationMinKey")) != null ? d : 0.0;
        d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.ElevationMaxKey");
        this.maxElevation = d != null ? d : 0.0;
        Long l = (Long)aVList.getValue("gov.nasa.worldwind.avkey.ExpiryTime");
        if (l != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ExpiryTime", l);
        }
        if ((d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.MissingDataFlag")) != null) {
            this.setMissingDataSignal(d);
        }
        if ((d = (Double)aVList.getValue("gov.nasa.worldwind.avkey.MissingDataValue")) != null) {
            this.setMissingDataReplacement(d);
        }
        if ((bl = (Boolean)aVList.getValue("gov.nasa.worldwind.avkey.NetworkRetrievalEnabled")) != null) {
            this.setNetworkRetrievalEnabled(bl);
        }
        if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.DataType")) != null) {
            this.setElevationDataType(string);
        }
        if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.ElevationExtremesFileKey")) != null) {
            this.loadExtremeElevations(string);
        }
        BasicElevationModel.setFallbacks(aVList);
        this.levels = new LevelSet(aVList);
        if (this.levels.getSector() != null && this.getValue("gov.nasa.worldwind.avKey.Sector") == null) {
            this.setValue("gov.nasa.worldwind.avKey.Sector", this.levels.getSector());
        }
        this.memoryCache = this.createMemoryCache(ElevationTile.class.getName());
        this.setValue("gov.nasa.worldwind.avkey.ConstructionParameters", aVList.copy());
        if (this.isRetrieveResources()) {
            this.startResourceRetrieval();
        }
    }

    public BasicElevationModel(Document document, AVList aVList) {
        this(document.getDocumentElement(), aVList);
    }

    public BasicElevationModel(Element element, AVList aVList) {
        this(BasicElevationModel.getBasicElevationModelConfigParams(element, aVList));
    }

    public BasicElevationModel(String string) {
        this(BasicElevationModel.restorableStateToParams(string));
        RestorableSupport restorableSupport;
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string2 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    @Override
    public Object setValue(String string, Object object) {
        if (this.getLevels() != null) {
            this.getLevels().setValue(string, object);
        }
        return super.setValue(string, object);
    }

    @Override
    public Object getValue(String string) {
        Object object = super.getValue(string);
        return object != null ? object : this.getLevels().getValue(string);
    }

    protected static void setFallbacks(AVList aVList) {
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileWidthKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 150);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.TileHeightKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 150);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".bil");
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", 2);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.NumEmptyLevels") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        }
    }

    protected MemoryCache getMemoryCache() {
        return this.memoryCache;
    }

    protected MemoryCache createMemoryCache(String string) {
        if (WorldWind.getMemoryCacheSet().containsCache(string)) {
            return WorldWind.getMemoryCache(string);
        }
        long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.ElevationTileCacheSize", 20000000L);
        BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
        basicMemoryCache.setName("Elevation Tiles");
        WorldWind.getMemoryCacheSet().addCache(string, basicMemoryCache);
        return basicMemoryCache;
    }

    public LevelSet getLevels() {
        return this.levels;
    }

    protected Map<TileKey, ElevationTile> getLevelZeroTiles() {
        return this.levelZeroTiles;
    }

    protected int getExtremesLevel() {
        return this.extremesLevel;
    }

    protected BufferWrapper getExtremes() {
        return this.extremes;
    }

    @Override
    public void setExpiryTime(long l) {
        super.setExpiryTime(l);
        if (l > 0L) {
            this.levels.setExpiryTime(l);
        }
    }

    @Override
    public double getMaxElevation() {
        return this.maxElevation;
    }

    @Override
    public double getMinElevation() {
        return this.minElevation;
    }

    @Override
    public double getBestResolution(Sector sector) {
        if (sector == null) {
            return this.levels.getLastLevel().getTexelSize();
        }
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel(sector);
        return level != null ? level.getTexelSize() : Double.MAX_VALUE;
    }

    @Override
    public double getDetailHint(Sector sector) {
        return this.detailHint;
    }

    public void setDetailHint(double d) {
        this.detailHint = d;
    }

    public String getElevationDataType() {
        return this.elevationDataType;
    }

    public void setElevationDataType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.DataTypeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.elevationDataType = string;
    }

    public String getElevationDataByteOrder() {
        return this.elevationDataByteOrder;
    }

    public void setByteOrder(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ByteOrderIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.elevationDataByteOrder = string;
    }

    @Override
    public int intersects(Sector sector) {
        if (this.levels.getSector().contains(sector)) {
            return 0;
        }
        return this.levels.getSector().intersects(sector) ? 1 : -1;
    }

    @Override
    public boolean contains(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.levels.getSector().contains(angle, angle2);
    }

    protected ElevationTile createTile(TileKey tileKey) {
        gov.nasa.worldwind.util.Level level = this.levels.getLevel(tileKey.getLevelNumber());
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = this.levels.getTileOrigin().getLatitude();
        Angle angle4 = this.levels.getTileOrigin().getLongitude();
        Angle angle5 = ElevationTile.computeRowLatitude(tileKey.getRow(), angle, angle3);
        Angle angle6 = ElevationTile.computeColumnLongitude(tileKey.getColumn(), angle2, angle4);
        Sector sector = new Sector(angle5, angle5.add(angle), angle6, angle6.add(angle2));
        return new ElevationTile(sector, level, tileKey.getRow(), tileKey.getColumn());
    }

    protected void requestTile(TileKey tileKey) {
        if (WorldWind.getTaskService().isFull()) {
            return;
        }
        if (this.getLevels().isResourceAbsent(tileKey)) {
            return;
        }
        RequestTask requestTask = new RequestTask(tileKey, this);
        WorldWind.getTaskService().addTask(requestTask);
    }

    protected boolean isFileExpired(Tile tile, URL uRL, FileStore fileStore) {
        if (!WWIO.isFileOutOfDate(uRL, tile.getLevel().getExpiryTime())) {
            return false;
        }
        fileStore.removeFile(uRL);
        String string = Logging.getMessage("generic.DataFileExpired", uRL);
        Logging.logger().fine(string);
        return true;
    }

    protected boolean loadElevations(ElevationTile elevationTile, URL uRL) throws IOException {
        BufferWrapper bufferWrapper = this.readElevations(uRL);
        if (bufferWrapper == null || bufferWrapper.length() == 0) {
            return false;
        }
        elevationTile.setElevations(bufferWrapper, this);
        this.addTileToCache(elevationTile, bufferWrapper);
        return true;
    }

    protected void addTileToCache(ElevationTile elevationTile, BufferWrapper bufferWrapper) {
        if (elevationTile.getLevelNumber() == 0) {
            this.levelZeroTiles.put(elevationTile.getTileKey(), elevationTile);
        } else {
            this.getMemoryCache().add(elevationTile.getTileKey(), elevationTile, bufferWrapper.getSizeInBytes());
        }
    }

    protected boolean areElevationsInMemory(TileKey tileKey) {
        ElevationTile elevationTile = this.getTileFromMemory(tileKey);
        return elevationTile != null && elevationTile.getElevations() != null && !elevationTile.isElevationsExpired();
    }

    protected ElevationTile getTileFromMemory(TileKey tileKey) {
        if (tileKey.getLevelNumber() == 0) {
            return this.levelZeroTiles.get(tileKey);
        }
        return (ElevationTile)this.getMemoryCache().getObject(tileKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferWrapper readElevations(URL uRL) throws IOException {
        try {
            ByteBuffer byteBuffer;
            Object object = this.fileLock;
            synchronized (object) {
                byteBuffer = WWIO.readURLContentToBuffer(uRL);
            }
            object = new AVListImpl();
            object.setValue("gov.nasa.worldwind.avkey.DataType", this.elevationDataType);
            object.setValue("gov.nasa.worldwind.avkey.ByteOrder", this.elevationDataByteOrder);
            return BufferWrapper.wrap(byteBuffer, (AVList)object);
        }
        catch (IOException iOException) {
            Logging.logger().log(Level.SEVERE, "ElevationModel.ExceptionReadingElevationFile", uRL.toString());
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ByteBuffer convertImageToElevations(ByteBuffer byteBuffer, String string) throws IOException {
        File file = File.createTempFile("wwj-", WWIO.makeSuffixForMimeType(string));
        try {
            WWIO.saveBuffer(byteBuffer, file);
            BufferedImage bufferedImage = ImageIO.read(file);
            ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(bufferedImage.getWidth() * bufferedImage.getHeight() * 2);
            byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
            ShortBuffer shortBuffer = byteBuffer2.asShortBuffer();
            WritableRaster writableRaster = bufferedImage.getRaster();
            int[] nArray = new int[writableRaster.getWidth() * writableRaster.getHeight()];
            writableRaster.getSamples(0, 0, writableRaster.getWidth(), writableRaster.getHeight(), 0, nArray);
            for (int n : nArray) {
                shortBuffer.put((short)n);
            }
            ByteBuffer byteBuffer3 = byteBuffer2;
            return byteBuffer3;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    @Override
    public BulkRetrievalThread makeLocal(Sector sector, double d, BulkRetrievalListener bulkRetrievalListener) {
        return this.makeLocal(sector, d, null, bulkRetrievalListener);
    }

    @Override
    public BulkRetrievalThread makeLocal(Sector sector, double d, FileStore fileStore, BulkRetrievalListener bulkRetrievalListener) {
        Sector sector2;
        Sector sector3 = sector2 = sector != null ? this.getLevels().getSector().intersection(sector) : null;
        if (sector2 == null) {
            return null;
        }
        BasicElevationModelBulkDownloader basicElevationModelBulkDownloader = new BasicElevationModelBulkDownloader(this, sector2, d, fileStore != null ? fileStore : this.getDataFileStore(), bulkRetrievalListener);
        basicElevationModelBulkDownloader.setDaemon(true);
        basicElevationModelBulkDownloader.start();
        return basicElevationModelBulkDownloader;
    }

    @Override
    public long getEstimatedMissingDataSize(Sector sector, double d) {
        return this.getEstimatedMissingDataSize(sector, d, null);
    }

    @Override
    public long getEstimatedMissingDataSize(Sector sector, double d, FileStore fileStore) {
        Sector sector2;
        Sector sector3 = sector2 = sector != null ? this.getLevels().getSector().intersection(sector) : null;
        if (sector2 == null) {
            return 0L;
        }
        BasicElevationModelBulkDownloader basicElevationModelBulkDownloader = new BasicElevationModelBulkDownloader(this, sector2, d, fileStore != null ? fileStore : this.getDataFileStore(), null);
        return basicElevationModelBulkDownloader.getEstimatedMissingDataSize();
    }

    protected void downloadElevations(Tile tile) {
        this.retrieveElevations(tile, new DownloadPostProcessor(tile, this));
    }

    protected void downloadElevations(Tile tile, DownloadPostProcessor downloadPostProcessor) {
        this.retrieveElevations(tile, downloadPostProcessor);
    }

    protected void retrieveElevations(Tile tile, DownloadPostProcessor downloadPostProcessor) {
        if (this.getValue("gov.nasa.worldwind.avkey.RetrieverFactoryLocal") != null) {
            this.retrieveLocalElevations(tile, downloadPostProcessor);
        } else {
            this.retrieveRemoteElevations(tile, downloadPostProcessor);
        }
    }

    protected void retrieveLocalElevations(Tile tile, DownloadPostProcessor downloadPostProcessor) {
        if (!WorldWind.getLocalRetrievalService().isAvailable()) {
            return;
        }
        RetrieverFactory retrieverFactory = (RetrieverFactory)this.getValue("gov.nasa.worldwind.avkey.RetrieverFactoryLocal");
        if (retrieverFactory == null) {
            return;
        }
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", tile.getSector());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.Width", tile.getWidth());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.Height", tile.getHeight());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FileName", tile.getPath());
        Retriever retriever = retrieverFactory.createRetriever(aVListImpl, downloadPostProcessor);
        WorldWind.getLocalRetrievalService().runRetriever(retriever, tile.getPriority());
    }

    protected void retrieveRemoteElevations(Tile tile, DownloadPostProcessor downloadPostProcessor) {
        if (!this.isNetworkRetrievalEnabled()) {
            this.getLevels().markResourceAbsent(tile);
            return;
        }
        if (!WorldWind.getRetrievalService().isAvailable()) {
            return;
        }
        URL uRL = null;
        try {
            uRL = tile.getResourceURL();
            if (WorldWind.getNetworkStatus().isHostUnavailable(uRL)) {
                this.getLevels().markResourceAbsent(tile);
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("TiledElevationModel.ExceptionCreatingElevationsUrl", uRL), malformedURLException);
            return;
        }
        if (downloadPostProcessor == null) {
            downloadPostProcessor = new DownloadPostProcessor(tile, this);
        }
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, downloadPostProcessor);
        hTTPRetriever.setValue("URLRetriever.ExtractZipEntry", "true");
        if (WorldWind.getRetrievalService().contains(hTTPRetriever)) {
            return;
        }
        WorldWind.getRetrievalService().runRetriever(hTTPRetriever, 0.0);
    }

    protected void determineExtremes(double d, double[] dArray) {
        if (d == this.getMissingDataSignal()) {
            d = this.getMissingDataReplacement();
        }
        if (d < dArray[0]) {
            dArray[0] = d;
        }
        if (d > dArray[1]) {
            dArray[1] = d;
        }
    }

    @Override
    public double getUnmappedElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.contains(angle, angle2)) {
            return this.getMissingDataSignal();
        }
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel(angle, angle2);
        TileKey tileKey = new TileKey(angle, angle2, this.levels, level.getLevelNumber());
        ElevationTile elevationTile = this.getTileFromMemory(tileKey);
        if (elevationTile == null) {
            int n = tileKey.getRow();
            int n2 = tileKey.getColumn();
            for (int i = tileKey.getLevelNumber() - 1; i >= 0; --i) {
                n /= 2;
                n2 /= 2;
                if (this.levels.getLevel(i).isEmpty()) {
                    return this.getExtremeElevations(angle, angle2)[0];
                }
                TileKey tileKey2 = new TileKey(i, n, n2, this.levels.getLevel(i).getCacheName());
                elevationTile = this.getTileFromMemory(tileKey2);
                if (elevationTile != null) break;
            }
        }
        if (elevationTile == null && !this.levels.getFirstLevel().isEmpty()) {
            gov.nasa.worldwind.util.Level level2 = this.levels.getFirstLevel();
            TileKey tileKey3 = new TileKey(angle, angle2, this.levels, level2.getLevelNumber());
            this.requestTile(tileKey3);
            return this.getExtremeElevations(angle, angle2)[0];
        }
        if (this.getExpiryTime() > 0L && this.getExpiryTime() < System.currentTimeMillis() && elevationTile != null) {
            this.checkElevationExpiration(elevationTile);
        }
        return this.lookupElevation(angle, angle2, elevationTile);
    }

    @Override
    public double getElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        return this.getElevations(sector, list, d, dArray, true);
    }

    @Override
    public double getUnmappedElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        return this.getElevations(sector, list, d, dArray, false);
    }

    protected double getElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray, boolean bl) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LatLonListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ElevationsBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length < list.size()) {
            String string = Logging.getMessage("ElevationModel.ElevationsBufferTooSmall", list.size());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gov.nasa.worldwind.util.Level level = this.getTargetLevel(sector, d);
        if (level == null) {
            return Double.MAX_VALUE;
        }
        Elevations elevations = this.getElevations(sector, this.levels, level.getLevelNumber());
        if (elevations == null) {
            return Double.MAX_VALUE;
        }
        if (this.intersects(sector) == -1) {
            return Double.MAX_VALUE;
        }
        this.setValue("gov.nasa.worldwind.avkey.FrameTimestamp", System.currentTimeMillis());
        for (int i = 0; i < list.size(); ++i) {
            Double d2;
            LatLon latLon = list.get(i);
            if (latLon == null || this.isTransparentValue(d2 = elevations.getElevation(latLon.getLatitude(), latLon.getLongitude()))) continue;
            if (d2 != null && d2.doubleValue() != this.getMissingDataSignal()) {
                dArray[i] = d2;
                continue;
            }
            if (!this.contains(latLon.getLatitude(), latLon.getLongitude())) continue;
            if (d2 == null) {
                dArray[i] = this.getExtremeElevations(sector)[0];
                continue;
            }
            if (!bl || d2.doubleValue() != this.getMissingDataSignal()) continue;
            dArray[i] = this.getMissingDataReplacement();
        }
        return elevations.achievedResolution;
    }

    protected gov.nasa.worldwind.util.Level getTargetLevel(Sector sector, double d) {
        gov.nasa.worldwind.util.Level level = this.levels.getLastLevel(sector);
        if (level == null) {
            return null;
        }
        if (level.getTexelSize() >= d) {
            return level;
        }
        for (gov.nasa.worldwind.util.Level level2 : this.levels.getLevels()) {
            if (level2.getTexelSize() <= d) {
                return !level2.isEmpty() ? level2 : null;
            }
            if (level2 != level) continue;
            break;
        }
        return level;
    }

    protected double lookupElevation(Angle angle, Angle angle2, ElevationTile elevationTile) {
        double d;
        BufferWrapper bufferWrapper = elevationTile.getElevations();
        Sector sector = elevationTile.getSector();
        int n = elevationTile.getHeight();
        int n2 = elevationTile.getWidth();
        double d2 = sector.getDeltaLat().radians;
        double d3 = sector.getDeltaLon().radians;
        double d4 = sector.getMaxLatitude().radians - angle.radians;
        double d5 = angle2.radians - sector.getMinLongitude().radians;
        double d6 = d4 / d2;
        double d7 = d5 / d3;
        int n3 = (int)((double)(n - 1) * d6);
        int n4 = (int)((double)(n2 - 1) * d7);
        int n5 = n3 * n2 + n4;
        double d8 = bufferWrapper.getDouble(n5);
        double d9 = d = n4 < n2 - 1 ? bufferWrapper.getDouble(n5 + 1) : d8;
        if (this.getMissingDataSignal() == d8 || this.getMissingDataSignal() == d) {
            return this.getMissingDataSignal();
        }
        double d10 = d3 / (double)(n2 - 1);
        double d11 = d2 / (double)(n - 1);
        double d12 = (d5 - (double)n4 * d10) / d10;
        double d13 = (d4 - (double)n3 * d11) / d11;
        double d14 = d8 + d12 * (d - d8);
        if (n3 < n - 1 && n4 < n2 - 1) {
            d8 = bufferWrapper.getDouble(n5 + n2);
            d = bufferWrapper.getDouble(n5 + n2 + 1);
            if (this.getMissingDataSignal() == d8 || this.getMissingDataSignal() == d) {
                return this.getMissingDataSignal();
            }
        }
        double d15 = d8 + d12 * (d - d8);
        return d14 + d13 * (d15 - d14);
    }

    @Override
    public double[] getExtremeElevations(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.extremesLevel < 0 || this.extremes == null) {
            return new double[]{this.getMinElevation(), this.getMaxElevation()};
        }
        try {
            LatLon latLon = this.levels.getLevel(this.extremesLevel).getTileDelta();
            LatLon latLon2 = this.levels.getTileOrigin();
            int n = ElevationTile.computeRow(latLon.getLatitude(), angle, latLon2.getLatitude());
            int n2 = ElevationTile.computeColumn(latLon.getLongitude(), angle2, latLon2.getLongitude());
            int n3 = ElevationTile.computeColumn(latLon.getLongitude(), Angle.POS180, Angle.NEG180) + 1;
            int n4 = 2 * (n * n3 + n2);
            double d = this.extremes.getDouble(n4);
            double d2 = this.extremes.getDouble(n4 + 1);
            if (d == this.getMissingDataSignal()) {
                d = this.getMissingDataReplacement();
            }
            if (d2 == this.getMissingDataSignal()) {
                d2 = this.getMissingDataReplacement();
            }
            return new double[]{d, d2};
        }
        catch (Exception exception) {
            String string = Logging.getMessage("BasicElevationModel.ExceptionDeterminingExtremes", new LatLon(angle, angle2));
            Logging.logger().log(Level.WARNING, string, exception);
            return new double[]{this.getMinElevation(), this.getMaxElevation()};
        }
    }

    @Override
    public double[] getExtremeElevations(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            double[] dArray;
            double[] dArray2 = (double[])this.getExtremesLookupCache().getObject(sector);
            if (dArray2 != null) {
                return new double[]{dArray2[0], dArray2[1]};
            }
            if (this.extremesLevel < 0 || this.extremes == null) {
                return new double[]{this.getMinElevation(), this.getMaxElevation()};
            }
            dArray2 = this.computeExtremeElevations(sector);
            if (dArray2 != null) {
                this.getExtremesLookupCache().add(sector, dArray2, 16L);
            }
            if (dArray2 != null) {
                double[] dArray3 = new double[2];
                dArray3[0] = dArray2[0];
                dArray = dArray3;
                dArray3[1] = dArray2[1];
            } else {
                dArray = null;
            }
            return dArray;
        }
        catch (Exception exception) {
            String string = Logging.getMessage("BasicElevationModel.ExceptionDeterminingExtremes", sector);
            Logging.logger().log(Level.WARNING, string, exception);
            return new double[]{this.getMinElevation(), this.getMaxElevation()};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadExtremeElevations(String string) {
        InputStream inputStream;
        block13: {
            String[] stringArray;
            block12: {
                if (string == null) {
                    String string2 = Logging.getMessage("nullValue.ExtremeElevationsFileName");
                    Logging.logger().severe(string2);
                    throw new IllegalArgumentException(string2);
                }
                inputStream = null;
                inputStream = this.getClass().getResourceAsStream("/" + string);
                if (inputStream == null) {
                    stringArray = new File(string);
                    if (stringArray.exists()) {
                        inputStream = new FileInputStream((File)stringArray);
                    } else {
                        Logging.logger().log(Level.WARNING, "BasicElevationModel.UnavailableExtremesFile", string);
                    }
                }
                if (inputStream != null) break block12;
                WWIO.closeStream(inputStream, string);
                if (this.extremesLookupCache == null) return;
                this.extremesLookupCache.clear();
                return;
            }
            stringArray = string.substring(0, string.lastIndexOf(".")).split("_");
            this.extremesLevel = Integer.parseInt(stringArray[stringArray.length - 1]);
            if (this.extremesLevel >= 0) break block13;
            this.extremes = null;
            Logging.logger().log(Level.WARNING, "BasicElevationModel.UnavailableExtremesLevel", string);
            WWIO.closeStream(inputStream, string);
            if (this.extremesLookupCache == null) return;
            this.extremesLookupCache.clear();
            return;
        }
        try {
            AVListImpl aVListImpl = new AVListImpl();
            aVListImpl.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int16");
            aVListImpl.setValue("gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.BigEndian");
            this.extremes = BufferWrapper.wrap(WWIO.readStreamToBuffer(inputStream, true), aVListImpl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logging.logger().log(Level.WARNING, Logging.getMessage("BasicElevationModel.ExceptionReadingExtremeElevations", string), fileNotFoundException);
            this.extremes = null;
            this.extremesLevel = -1;
            this.extremesLookupCache = null;
            WWIO.closeStream(inputStream, string);
            if (this.extremesLookupCache == null) return;
            this.extremesLookupCache.clear();
            return;
        }
        catch (IOException iOException) {
            Logging.logger().log(Level.WARNING, Logging.getMessage("BasicElevationModel.ExceptionReadingExtremeElevations", string), iOException);
            this.extremes = null;
            this.extremesLevel = -1;
            this.extremesLookupCache = null;
            {
                catch (Throwable throwable) {
                    WWIO.closeStream(inputStream, string);
                    if (this.extremesLookupCache == null) throw throwable;
                    this.extremesLookupCache.clear();
                    throw throwable;
                }
            }
            WWIO.closeStream(inputStream, string);
            if (this.extremesLookupCache == null) return;
            this.extremesLookupCache.clear();
            return;
        }
        WWIO.closeStream(inputStream, string);
        if (this.extremesLookupCache == null) return;
        this.extremesLookupCache.clear();
        return;
    }

    protected double[] computeExtremeElevations(Sector sector) {
        LatLon latLon = this.levels.getLevel(this.extremesLevel).getTileDelta();
        LatLon latLon2 = this.levels.getTileOrigin();
        int n = ElevationTile.computeRow(latLon.getLatitude(), sector.getMaxLatitude(), latLon2.getLatitude());
        int n2 = ElevationTile.computeColumn(latLon.getLongitude(), sector.getMinLongitude(), latLon2.getLongitude());
        int n3 = ElevationTile.computeRow(latLon.getLatitude(), sector.getMinLatitude(), latLon2.getLatitude());
        int n4 = ElevationTile.computeColumn(latLon.getLongitude(), sector.getMaxLongitude(), latLon2.getLongitude());
        int n5 = ElevationTile.computeColumn(latLon.getLongitude(), Angle.POS180, Angle.NEG180) + 1;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        for (int i = n2; i <= n4; ++i) {
            for (int j = n3; j <= n; ++j) {
                int n6 = 2 * (j * n5 + i);
                double d3 = this.extremes.getDouble(n6);
                double d4 = this.extremes.getDouble(n6 + 1);
                if (d3 == this.getMissingDataSignal()) {
                    d3 = this.getMissingDataReplacement();
                }
                if (d4 == this.getMissingDataSignal()) {
                    d4 = this.getMissingDataReplacement();
                }
                if (d3 > d2) {
                    d2 = d3;
                }
                if (d3 < d) {
                    d = d3;
                }
                if (d4 > d2) {
                    d2 = d4;
                }
                if (!(d4 < d)) continue;
                d = d4;
            }
        }
        if (d == Double.MAX_VALUE) {
            d = this.getMinElevation();
        }
        if (d2 == Double.MAX_VALUE) {
            d2 = this.getMaxElevation();
        }
        return new double[]{d, d2};
    }

    protected synchronized MemoryCache getExtremesLookupCache() {
        if (this.extremesLookupCache == null) {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.ElevationExtremesLookupCacheSize", 2000000L);
            this.extremesLookupCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
        }
        return this.extremesLookupCache;
    }

    protected Elevations getElevations(Sector sector, LevelSet levelSet, int n) {
        Elevations elevations;
        Object object;
        Sector sector2 = sector.intersection(levelSet.getSector());
        gov.nasa.worldwind.util.Level level = levelSet.getLevel(n);
        LatLon latLon = level.getTileDelta();
        LatLon latLon2 = levelSet.getTileOrigin();
        int n2 = Tile.computeRow(latLon.getLatitude(), sector2.getMaxLatitude(), latLon2.getLatitude());
        int n3 = Tile.computeColumn(latLon.getLongitude(), sector2.getMinLongitude(), latLon2.getLongitude());
        int n4 = Tile.computeRow(latLon.getLatitude(), sector2.getMinLatitude(), latLon2.getLatitude());
        int n5 = Tile.computeColumn(latLon.getLongitude(), sector2.getMaxLongitude(), latLon2.getLongitude());
        TreeSet<ElevationTile> treeSet = new TreeSet<ElevationTile>(new Comparator<ElevationTile>(){

            @Override
            public int compare(ElevationTile elevationTile, ElevationTile elevationTile2) {
                if (elevationTile2.getLevelNumber() == elevationTile.getLevelNumber() && elevationTile2.getRow() == elevationTile.getRow() && elevationTile2.getColumn() == elevationTile.getColumn()) {
                    return 0;
                }
                return elevationTile.getLevelNumber() > elevationTile2.getLevelNumber() ? -1 : 1;
            }
        });
        ArrayList<TileKey> arrayList = new ArrayList<TileKey>();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = n4; i <= n2; ++i) {
            for (int j = n3; j <= n5; ++j) {
                object = new TileKey(level.getLevelNumber(), i, j, level.getCacheName());
                ElevationTile elevationTile = this.getTileFromMemory((TileKey)object);
                if (elevationTile != null) {
                    treeSet.add(elevationTile);
                    continue;
                }
                bl = true;
                this.requestTile((TileKey)object);
                TileKey tileKey = null;
                int n6 = i;
                int n7 = j;
                for (int k = ((TileKey)object).getLevelNumber() - 1; k >= 0; --k) {
                    TileKey tileKey2 = new TileKey(k, n6 /= 2, n7 /= 2, this.levels.getLevel(k).getCacheName());
                    elevationTile = this.getTileFromMemory(tileKey2);
                    if (elevationTile != null) {
                        if (treeSet.contains(elevationTile)) break;
                        treeSet.add(elevationTile);
                        break;
                    }
                    if (k == 0) {
                        bl2 = true;
                    }
                    tileKey = tileKey2;
                }
                if (tileKey == null || arrayList.contains(tileKey)) continue;
                this.requestTile(tileKey);
                arrayList.add(tileKey);
            }
        }
        if (bl2 || treeSet.isEmpty()) {
            elevations = new Elevations(this, Double.MAX_VALUE);
            elevations.tiles = treeSet;
        } else if (bl) {
            elevations = new Elevations(this, treeSet.last().getLevel().getTexelSize());
            elevations.tiles = treeSet;
        } else {
            elevations = new Elevations(this, treeSet.last().getLevel().getTexelSize());
            if (treeSet.size() > 0) {
                elevations.tiles = treeSet;
                double[] dArray = elevations.getTileExtremes();
                if (dArray != null && ((object = (Object)((double[])this.getExtremesLookupCache().getObject(sector))) == null || object[0] != dArray[0] || object[1] != dArray[1])) {
                    this.getExtremesLookupCache().add(sector, dArray, 16L);
                }
            }
        }
        if (this.getExpiryTime() > 0L && this.getExpiryTime() < System.currentTimeMillis()) {
            this.checkElevationExpiration(treeSet);
        }
        return elevations;
    }

    protected void checkElevationExpiration(ElevationTile elevationTile) {
        if (elevationTile.isElevationsExpired()) {
            this.requestTile(elevationTile.getTileKey());
        }
    }

    protected void checkElevationExpiration(Iterable<? extends ElevationTile> iterable) {
        for (ElevationTile elevationTile : iterable) {
            if (!elevationTile.isElevationsExpired()) continue;
            this.requestTile(elevationTile.getTileKey());
        }
    }

    public ByteBuffer generateExtremeElevations(int n) {
        return null;
    }

    protected String retrieveResources() {
        AVList aVList = (AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters");
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ConstructionParametersIsNull");
            Logging.logger().warning(string);
            return "gov.nasa.worldwind.avkey.RetrievalStateSuccessful";
        }
        URL uRL = DataConfigurationUtils.getOGCGetCapabilitiesURL(aVList);
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.CapabilitiesURLIsNull");
            Logging.logger().warning(string);
            return "gov.nasa.worldwind.avkey.RetrievalStateSuccessful";
        }
        WMSCapabilities wMSCapabilities = this.isNetworkRetrievalEnabled() ? SessionCacheUtils.getOrRetrieveSessionCapabilities(uRL, WorldWind.getSessionCache(), uRL.toString(), null, 1L, null, null) : SessionCacheUtils.getSessionCapabilities(WorldWind.getSessionCache(), uRL.toString(), uRL.toString());
        if (wMSCapabilities == null) {
            return null;
        }
        this.initFromOGCCapabilitiesResource(wMSCapabilities, aVList);
        return "gov.nasa.worldwind.avkey.RetrievalStateSuccessful";
    }

    protected void initFromOGCCapabilitiesResource(WMSCapabilities wMSCapabilities, AVList aVList) {
        if (wMSCapabilities == null) {
            String string = Logging.getMessage("nullValue.CapabilitiesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = DataConfigurationUtils.getOGCLayerNames(aVList);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        final Long l = wMSCapabilities.getLayerLatestLastUpdateTime(stringArray);
        if (l == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BasicElevationModel.this.setExpiryTime(l);
                BasicElevationModel.this.firePropertyChange("gov.nasa.worldwind.avkey.ElevationModel", null, BasicElevationModel.this);
            }
        });
    }

    protected boolean isRetrieveResources() {
        AVList aVList = (AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters");
        if (aVList == null) {
            return false;
        }
        Boolean bl = (Boolean)aVList.getValue("gov.nasa.worldwind.avkey.RetrievePropertiesFromService");
        return bl != null && bl != false;
    }

    protected void startResourceRetrieval() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                BasicElevationModel.this.retrieveResources();
            }
        });
        thread.setName("Capabilities retrieval for " + this.getName());
        thread.start();
    }

    public static Document createBasicElevationModelConfigDocument(AVList aVList) {
        Document document = WWXML.createDocumentBuilder(true).newDocument();
        Element element = WWXML.setDocumentElement(document, "ElevationModel");
        WWXML.setIntegerAttribute(element, "version", 1);
        BasicElevationModel.createBasicElevationModelConfigElements(aVList, element);
        return document;
    }

    public static Element createBasicElevationModelConfigElements(AVList aVList, Element element) {
        Object object;
        Object object2;
        Object object3;
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParametersIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (element == null) {
            String string = Logging.getMessage("nullValue.ContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        XPath xPath = WWXML.makeXPath();
        AbstractElevationModel.createElevationModelConfigElements(aVList, element);
        DataConfigurationUtils.createLevelSetConfigElements(aVList, element);
        String string = AVListImpl.getStringValue(aVList, "gov.nasa.worldwind.avkey.ServiceName", "WWTileService");
        if (string != null && string.length() > 0) {
            object3 = WWXML.getElement(element, "Service", xPath);
            if (object3 == null) {
                object3 = WWXML.appendElementPath(element, "Service");
            }
            WWXML.setTextAttribute((Element)object3, "serviceName", string);
        }
        WWXML.checkAndAppendBooleanElement(aVList, "gov.nasa.worldwind.avkey.RetrievePropertiesFromService", element, "RetrievePropertiesFromService");
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.ImageFormat", element, "ImageFormat");
        object3 = aVList.getValue("gov.nasa.worldwind.avkey.AvailableImageFormats");
        if (object3 != null && object3 instanceof String[] && ((String[])(object2 = (String[])object3)).length > 0) {
            object = WWXML.getElement(element, "AvailableImageFormats", xPath);
            if (object == null) {
                object = WWXML.appendElementPath(element, "AvailableImageFormats");
            }
            WWXML.appendTextArray((Element)object, "ImageFormat", object2);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataType") != null || aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder") != null) {
            object2 = WWXML.getElement(element, "DataType", null);
            if (object2 == null) {
                object2 = WWXML.appendElementPath(element, "DataType");
            }
            if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.DataType")) != null && string.length() > 0 && (string = WWXML.dataTypeAsText(string)) != null && string.length() > 0) {
                WWXML.setTextAttribute((Element)object2, "type", string);
            }
            if ((string = aVList.getStringValue("gov.nasa.worldwind.avkey.ByteOrder")) != null && string.length() > 0 && (string = WWXML.byteOrderAsText(string)) != null && string.length() > 0) {
                WWXML.setTextAttribute((Element)object2, "byteOrder", string);
            }
        }
        object2 = WWXML.appendElementPath(element, "ExtremeElevations");
        WWXML.checkAndAppendTextElement(aVList, "gov.nasa.worldwind.avkey.ElevationExtremesFileKey", (Element)object2, "FileName");
        object = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.avkey.ElevationMaxKey");
        if (object != null) {
            WWXML.setDoubleAttribute((Element)object2, "max", (Double)object);
        }
        if ((object = AVListImpl.getDoubleValue(aVList, "gov.nasa.worldwind.avkey.ElevationMinKey")) != null) {
            WWXML.setDoubleAttribute((Element)object2, "min", (Double)object);
        }
        return element;
    }

    public static AVList getBasicElevationModelConfigParams(Element element, AVList aVList) {
        String string;
        if (element == null) {
            String string2 = Logging.getMessage("nullValue.DocumentIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        XPath xPath = WWXML.makeXPath();
        AbstractElevationModel.getElevationModelConfigParams(element, aVList);
        DataConfigurationUtils.getLevelSetConfigParams(element, aVList);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.ServiceName", "Service/@serviceName", xPath);
        WWXML.checkAndSetBooleanParam(element, aVList, "gov.nasa.worldwind.avkey.RetrievePropertiesFromService", "RetrievePropertiesFromService", xPath);
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.ImageFormat", "ImageFormat", xPath);
        WWXML.checkAndSetUniqueStringsParam(element, aVList, "gov.nasa.worldwind.avkey.AvailableImageFormats", "AvailableImageFormats/ImageFormat", xPath);
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataType") == null && (string = WWXML.getText(element, "DataType/@type", xPath)) != null && string.length() > 0 && (string = WWXML.parseDataType(string)) != null && string.length() > 0) {
            aVList.setValue("gov.nasa.worldwind.avkey.DataType", string);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder") == null && (string = WWXML.getText(element, "DataType/@byteOrder", xPath)) != null && string.length() > 0 && (string = WWXML.parseByteOrder(string)) != null && string.length() > 0) {
            aVList.setValue("gov.nasa.worldwind.avkey.ByteOrder", string);
        }
        WWXML.checkAndSetStringParam(element, aVList, "gov.nasa.worldwind.avkey.ElevationExtremesFileKey", "ExtremeElevations/FileName", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.ElevationMaxKey", "ExtremeElevations/@max", xPath);
        WWXML.checkAndSetDoubleParam(element, aVList, "gov.nasa.worldwind.avkey.ElevationMinKey", "ExtremeElevations/@min", xPath);
        return aVList;
    }

    protected void writeConfigurationFile(FileStore fileStore) {
        try {
            AVList aVList = this.getConfigurationParams(null);
            this.writeConfigurationParams(aVList, fileStore);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToWriteConfigurationFile");
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeConfigurationParams(AVList aVList, FileStore fileStore) {
        String string = DataConfigurationUtils.getDataConfigFilename(aVList, ".xml");
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        if (!this.needsConfigurationFile(fileStore, string, aVList, false)) {
            return;
        }
        Object object = this.fileLock;
        synchronized (object) {
            if (!this.needsConfigurationFile(fileStore, string, aVList, true)) {
                return;
            }
            this.doWriteConfigurationParams(fileStore, string, aVList);
        }
    }

    protected void doWriteConfigurationParams(FileStore fileStore, String string, AVList aVList) {
        File file = fileStore.newFile(string);
        if (file == null) {
            String string2 = Logging.getMessage("generic.CannotCreateFile", string);
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        Document document = this.createConfigurationDocument(aVList);
        WWXML.saveDocumentToFile(document, file.getPath());
        String string3 = Logging.getMessage("generic.ConfigurationFileCreated", string);
        Logging.logger().fine(string3);
    }

    protected boolean needsConfigurationFile(FileStore fileStore, String string, AVList aVList, boolean bl) {
        long l = this.getExpiryTime();
        if (l <= 0L) {
            l = AVListImpl.getLongValue(aVList, "gov.nasa.worldwind.avkey.ExpiryTime", 0L);
        }
        return !DataConfigurationUtils.hasDataConfigFile(fileStore, string, bl, l);
    }

    protected AVList getConfigurationParams(AVList aVList) {
        AVList aVList2;
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        if ((aVList2 = (AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters")) != null) {
            aVList.setValues(aVList2);
        }
        DataConfigurationUtils.getLevelSetConfigParams(this.getLevels(), aVList);
        if (aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ByteOrder", this.getElevationDataByteOrder());
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataType") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DataType", this.getElevationDataType());
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.MissingDataFlag") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.MissingDataFlag", this.getMissingDataSignal());
        }
        return aVList;
    }

    protected Document createConfigurationDocument(AVList aVList) {
        return BasicElevationModel.createBasicElevationModelConfigDocument(aVList);
    }

    @Override
    public String getRestorableState() {
        AVList aVList = (AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters");
        if (aVList == null) {
            return null;
        }
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        String string2 = Logging.getMessage("RestorableSupport.RestoreRequiresConstructor");
        Logging.logger().severe(string2);
        throw new UnsupportedOperationException(string2);
    }

    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        AVList aVList = (AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters");
        if (aVList != null) {
            for (Map.Entry<String, Object> object : aVList.getEntries()) {
                this.getRestorableStateForAVPair(object.getKey(), object.getValue(), restorableSupport, stateObject);
            }
        }
        restorableSupport.addStateValueAsString(stateObject, "ElevationModel.Name", this.getName());
        restorableSupport.addStateValueAsDouble(stateObject, "ElevationModel.MissingDataFlag", this.getMissingDataSignal());
        restorableSupport.addStateValueAsDouble(stateObject, "ElevationModel.MissingDataValue", this.getMissingDataReplacement());
        restorableSupport.addStateValueAsBoolean(stateObject, "ElevationModel.NetworkRetrievalEnabled", this.isNetworkRetrievalEnabled());
        restorableSupport.addStateValueAsDouble(stateObject, "ElevationModel.MinElevation", this.getMinElevation());
        restorableSupport.addStateValueAsDouble(stateObject, "ElevationModel.MaxElevation", this.getMaxElevation());
        restorableSupport.addStateValueAsString(stateObject, "BasicElevationModel.DataType", this.getElevationDataType());
        restorableSupport.addStateValueAsString(stateObject, "BasicElevationModel.DataByteOrder", this.getElevationDataByteOrder());
        if (this.detailHint != 0.0) {
            restorableSupport.addStateValueAsDouble(stateObject, "BasicElevationModel.DetailHint", this.detailHint);
        }
        RestorableSupport.StateObject stateObject2 = restorableSupport.addStateObject(stateObject, "avlist");
        for (Map.Entry<String, Object> entry : this.getEntries()) {
            this.getRestorableStateForAVPair(entry.getKey(), entry.getValue(), restorableSupport, stateObject2);
        }
    }

    @Override
    public void getRestorableStateForAVPair(String string, Object object, RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (object == null) {
            return;
        }
        if (string.equals("gov.nasa.worldwind.avkey.ConstructionParameters")) {
            return;
        }
        if (object instanceof LatLon) {
            restorableSupport.addStateValueAsLatLon(stateObject, string, (LatLon)object);
        } else if (object instanceof Sector) {
            restorableSupport.addStateValueAsSector(stateObject, string, (Sector)object);
        } else {
            super.getRestorableStateForAVPair(string, object, restorableSupport, stateObject);
        }
    }

    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        RestorableSupport.StateObject[] stateObjectArray;
        RestorableSupport.StateObject stateObject2;
        Boolean bl;
        Double d;
        String string = restorableSupport.getStateValueAsString(stateObject, "ElevationModel.Name");
        if (string != null) {
            this.setName(string);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "ElevationModel.MissingDataFlag")) != null) {
            this.setMissingDataSignal(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "ElevationModel.MissingDataValue")) != null) {
            this.setMissingDataReplacement(d);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "ElevationModel.NetworkRetrievalEnabled")) != null) {
            this.setNetworkRetrievalEnabled(bl);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "BasicElevationModel.DataType")) == null) {
            string = restorableSupport.getStateValueAsString(stateObject, "BasicElevationModel.DataPixelType");
        }
        if (string != null) {
            this.setElevationDataType(string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "BasicElevationModel.DataByteOrder")) != null) {
            this.setByteOrder(string);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "BasicElevationModel.DetailHint")) != null) {
            this.setDetailHint(d);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "avlist")) != null && (stateObjectArray = restorableSupport.getAllStateObjects(stateObject2, "")) != null) {
            for (RestorableSupport.StateObject stateObject3 : stateObjectArray) {
                if (stateObject3 == null) continue;
                this.doRestoreStateForObject(restorableSupport, stateObject3);
            }
        }
    }

    protected void doRestoreStateForObject(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (stateObject == null) {
            return;
        }
        if ("gov.nasa.worldwind.avkey.PixelType".equals(stateObject.getName())) {
            this.setValue("gov.nasa.worldwind.avkey.DataType", stateObject.getValue());
        } else {
            this.setValue(stateObject.getName(), stateObject.getValue());
        }
    }

    protected static AVList restorableStateToParams(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        AVListImpl aVListImpl = new AVListImpl();
        BasicElevationModel.restoreStateForParams(restorableSupport, null, aVListImpl);
        return aVListImpl;
    }

    protected static void restoreStateForParams(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject, AVList aVList) {
        Double d;
        Sector sector;
        LatLon latLon;
        Long l;
        Integer n;
        StringBuilder stringBuilder = new StringBuilder();
        String string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.DataCacheNameKey");
        if (string != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.ServiceURLKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.DatasetNameKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "gov.nasa.worldwind.avkey.FormatSuffixKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", string);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "gov.nasa.worldwind.avkey.NumEmptyLevels")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "gov.nasa.worldwind.avkey.NumLevels")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.NumLevels", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "gov.nasa.worldwind.avkey.TileWidthKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileWidthKey", n);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "gov.nasa.worldwind.avkey.TileHeightKey")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileHeightKey", n);
        }
        if ((l = restorableSupport.getStateValueAsLong(stateObject, "gov.nasa.worldwind.avkey.ExpiryTime")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ExpiryTime", l);
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon(stateObject, "gov.nasa.worldwind.avkey.LevelZeroTileDelta")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", latLon);
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon(stateObject, "gov.nasa.worldwind.avkey.TileOrigin")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileOrigin", latLon);
        }
        if ((sector = restorableSupport.getStateValueAsSector(stateObject, "gov.nasa.worldwind.avKey.Sector")) != null) {
            aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        }
        if ((d = restorableSupport.getStateValueAsDouble("ElevationModel.MinElevation")) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", d);
        } else {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("term.minElevation");
        }
        d = restorableSupport.getStateValueAsDouble("ElevationModel.MaxElevation");
        if (d != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", d);
        } else {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("term.maxElevation");
        }
        if (stringBuilder.length() > 0) {
            String string2 = Logging.getMessage("BasicElevationModel.InvalidDescriptorFields", stringBuilder.toString());
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
    }

    @Override
    public double getLocalDataAvailability(Sector sector, Double d) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LevelSet levelSet = this.getLevels();
        Sector sector2 = sector.intersection(levelSet.getSector());
        if (sector2 == null) {
            return 1.0;
        }
        gov.nasa.worldwind.util.Level level = d != null ? this.getTargetLevel(sector2, d) : levelSet.getLastLevel();
        long l = 0L;
        long l2 = 0L;
        LatLon latLon = level.getTileDelta();
        LatLon latLon2 = levelSet.getTileOrigin();
        int n = Tile.computeRow(latLon.getLatitude(), sector2.getMaxLatitude(), latLon2.getLatitude());
        int n2 = Tile.computeColumn(latLon.getLongitude(), sector2.getMinLongitude(), latLon2.getLongitude());
        int n3 = Tile.computeRow(latLon.getLatitude(), sector2.getMinLatitude(), latLon2.getLatitude());
        int n4 = Tile.computeColumn(latLon.getLongitude(), sector2.getMaxLongitude(), latLon2.getLongitude());
        for (int i = n; i >= n3; --i) {
            for (int j = n2; j <= n4; ++j) {
                TileKey tileKey = new TileKey(level.getLevelNumber(), i, j, level.getCacheName());
                Sector sector3 = levelSet.computeSectorForKey(tileKey);
                Tile tile = new Tile(sector3, level, i, j);
                if (!this.isTileLocalOrAbsent(tile)) {
                    ++l2;
                    continue;
                }
                ++l;
            }
        }
        return l > 0L ? (double)l / (double)(l + l2) : 0.0;
    }

    protected boolean isTileLocalOrAbsent(Tile tile) {
        if (this.getLevels().isResourceAbsent(tile)) {
            return true;
        }
        URL uRL = this.getDataFileStore().findFile(tile.getPath(), false);
        return uRL != null && !this.isFileExpired(tile, uRL, this.getDataFileStore());
    }

    protected static class ElevationTile
    extends Tile
    implements Cacheable {
        protected BufferWrapper elevations;
        protected long updateTime = 0L;
        protected double[] extremes = new double[2];

        protected ElevationTile(Sector sector, gov.nasa.worldwind.util.Level level, int n, int n2) {
            super(sector, level, n, n2);
        }

        public BufferWrapper getElevations() {
            return this.elevations;
        }

        public void setElevations(BufferWrapper bufferWrapper, BasicElevationModel basicElevationModel) {
            this.elevations = bufferWrapper;
            this.updateTime = System.currentTimeMillis();
            for (int i = 0; i < this.elevations.length(); ++i) {
                basicElevationModel.determineExtremes(this.elevations.getDouble(i), this.extremes);
            }
        }

        public boolean isElevationsExpired() {
            return this.isElevationsExpired(this.getLevel().getExpiryTime());
        }

        public boolean isElevationsExpired(long l) {
            return this.updateTime > 0L && this.updateTime < l;
        }

        public int computeElevationIndex(LatLon latLon) {
            Sector sector = this.getSector();
            int n = this.getHeight();
            int n2 = this.getWidth();
            double d = sector.getDeltaLat().radians;
            double d2 = sector.getDeltaLon().radians;
            double d3 = sector.getMaxLatitude().radians - latLon.getLatitude().radians;
            double d4 = latLon.getLongitude().radians - sector.getMinLongitude().radians;
            double d5 = d3 / d;
            double d6 = d4 / d2;
            int n3 = (int)((double)(n - 1) * d5);
            int n4 = (int)((double)(n2 - 1) * d6);
            return n3 * n2 + n4;
        }

        public double[] getExtremes(Sector sector, BasicElevationModel basicElevationModel, double[] dArray) {
            int n;
            int n2;
            Sector sector2 = this.getSector().intersection(sector);
            if (sector2 == null) {
                return dArray;
            }
            LatLon[] latLonArray = sector2.getCorners();
            int[] nArray = new int[4];
            for (n2 = 0; n2 < 4; ++n2) {
                n = this.computeElevationIndex(latLonArray[n2]);
                nArray[n2] = n < 0 ? 0 : (n > this.elevations.length() - 1 ? this.elevations.length() - 1 : n);
            }
            n2 = nArray[0];
            n = nArray[1];
            int n3 = nArray[3];
            int n4 = n - n2 + 1;
            if (dArray == null) {
                dArray = WWUtil.defaultMinMix();
            }
            while (n3 <= n2) {
                for (int i = 0; i < n4; ++i) {
                    int n5 = n3 + i;
                    basicElevationModel.determineExtremes(this.elevations.getDouble(n5), dArray);
                }
                n3 += this.getWidth();
            }
            return dArray;
        }
    }

    protected static class Elevations {
        protected final BasicElevationModel elevationModel;
        protected Set<ElevationTile> tiles;
        protected double[] extremes = null;
        protected final double achievedResolution;

        protected Elevations(BasicElevationModel basicElevationModel, double d) {
            this.elevationModel = basicElevationModel;
            this.achievedResolution = d;
        }

        protected Double getElevation(Angle angle, Angle angle2) {
            if (angle == null || angle2 == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (this.tiles == null) {
                return null;
            }
            try {
                for (ElevationTile elevationTile : this.tiles) {
                    if (!elevationTile.getSector().contains(angle, angle2)) continue;
                    return this.elevationModel.lookupElevation(angle, angle2, elevationTile);
                }
                return null;
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, Logging.getMessage("BasicElevationModel.ExceptionComputingElevation", angle, angle2), exception);
                return null;
            }
        }

        protected double[] getExtremes(Angle angle, Angle angle2) {
            if (angle == null || angle2 == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (this.extremes != null) {
                return this.extremes;
            }
            if (this.tiles == null || this.tiles.size() == 0) {
                return this.elevationModel.getExtremeElevations(angle, angle2);
            }
            return this.getExtremes();
        }

        protected double[] getExtremes() {
            if (this.extremes != null) {
                return this.extremes;
            }
            if (this.tiles == null || this.tiles.size() == 0) {
                this.extremes = new double[]{this.elevationModel.getMinElevation(), this.elevationModel.getMaxElevation()};
                return this.extremes;
            }
            this.extremes = WWUtil.defaultMinMix();
            for (ElevationTile elevationTile : this.tiles) {
                BufferWrapper bufferWrapper = elevationTile.getElevations();
                int n = bufferWrapper.length();
                if (n == 0) {
                    return null;
                }
                for (int i = 0; i < n; ++i) {
                    this.elevationModel.determineExtremes(bufferWrapper.getDouble(i), this.extremes);
                }
            }
            return new double[]{this.extremes[0], this.extremes[1]};
        }

        protected double[] getExtremes(Sector sector) {
            if (this.extremes != null) {
                return this.extremes;
            }
            Iterator<ElevationTile> iterator = this.tiles.iterator();
            if (!iterator.hasNext()) {
                this.extremes = new double[]{this.elevationModel.getMinElevation(), this.elevationModel.getMaxElevation()};
                return this.extremes;
            }
            this.extremes = WWUtil.defaultMinMix();
            for (ElevationTile elevationTile : this.tiles) {
                elevationTile.getExtremes(sector, this.elevationModel, this.extremes);
            }
            return this.extremes;
        }

        protected double[] getTileExtremes() {
            if (this.extremes != null) {
                return this.extremes;
            }
            Iterator<ElevationTile> iterator = this.tiles.iterator();
            if (!iterator.hasNext()) {
                this.extremes = new double[]{this.elevationModel.getMinElevation(), this.elevationModel.getMaxElevation()};
                return this.extremes;
            }
            this.extremes = WWUtil.defaultMinMix();
            for (ElevationTile elevationTile : this.tiles) {
                if (elevationTile.extremes[0] < this.extremes[0]) {
                    this.extremes[0] = elevationTile.extremes[0];
                }
                if (!(elevationTile.extremes[1] > this.extremes[1])) continue;
                this.extremes[1] = elevationTile.extremes[1];
            }
            return this.extremes;
        }
    }

    protected static class DownloadPostProcessor
    extends AbstractRetrievalPostProcessor {
        protected final Tile tile;
        protected final BasicElevationModel elevationModel;
        protected final FileStore fileStore;

        public DownloadPostProcessor(Tile tile, BasicElevationModel basicElevationModel) {
            this(tile, basicElevationModel, null);
        }

        public DownloadPostProcessor(Tile tile, BasicElevationModel basicElevationModel, FileStore fileStore) {
            super(basicElevationModel);
            this.tile = tile;
            this.elevationModel = basicElevationModel;
            this.fileStore = fileStore;
        }

        protected FileStore getFileStore() {
            return this.fileStore != null ? this.fileStore : this.elevationModel.getDataFileStore();
        }

        @Override
        protected boolean overwriteExistingFile() {
            return true;
        }

        @Override
        protected void markResourceAbsent() {
            this.elevationModel.getLevels().markResourceAbsent(this.tile);
        }

        @Override
        protected Object getFileLock() {
            return this.elevationModel.fileLock;
        }

        @Override
        protected File doGetOutputFile() {
            return this.getFileStore().newFile(this.tile.getPath());
        }

        @Override
        protected ByteBuffer handleSuccessfulRetrieval() {
            ByteBuffer byteBuffer = super.handleSuccessfulRetrieval();
            if (byteBuffer != null) {
                this.elevationModel.writeConfigurationFile(this.getFileStore());
                this.elevationModel.firePropertyChange("gov.nasa.worldwind.avkey.ElevationModel", null, this);
            }
            return byteBuffer;
        }

        @Override
        protected ByteBuffer handleTextContent() throws IOException {
            this.markResourceAbsent();
            return super.handleTextContent();
        }
    }

    protected static class RequestTask
    implements Runnable {
        protected final BasicElevationModel elevationModel;
        protected final TileKey tileKey;

        protected RequestTask(TileKey tileKey, BasicElevationModel basicElevationModel) {
            this.elevationModel = basicElevationModel;
            this.tileKey = tileKey;
        }

        @Override
        public final void run() {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            try {
                if (this.elevationModel.areElevationsInMemory(this.tileKey)) {
                    return;
                }
                ElevationTile elevationTile = this.elevationModel.createTile(this.tileKey);
                URL uRL = this.elevationModel.getDataFileStore().findFile(elevationTile.getPath(), false);
                if (uRL != null && !this.elevationModel.isFileExpired(elevationTile, uRL, this.elevationModel.getDataFileStore())) {
                    if (this.elevationModel.loadElevations(elevationTile, uRL)) {
                        this.elevationModel.levels.unmarkResourceAbsent(elevationTile);
                        this.elevationModel.firePropertyChange("gov.nasa.worldwind.avkey.ElevationModel", null, this);
                        return;
                    }
                    this.elevationModel.getDataFileStore().removeFile(uRL);
                    this.elevationModel.levels.markResourceAbsent(elevationTile);
                    String string = Logging.getMessage("generic.DeletedCorruptDataFile", uRL);
                    Logging.logger().info(string);
                }
                this.elevationModel.downloadElevations(elevationTile);
            }
            catch (IOException iOException) {
                String string = Logging.getMessage("ElevationModel.ExceptionRequestingElevations", this.tileKey.toString());
                Logging.logger().log(Level.FINE, string, iOException);
            }
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            return !(this.tileKey != null ? !this.tileKey.equals(requestTask.tileKey) : requestTask.tileKey != null);
        }

        public final int hashCode() {
            return this.tileKey != null ? this.tileKey.hashCode() : 0;
        }

        public final String toString() {
            return this.tileKey.toString();
        }
    }
}

