/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.impl;

import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.ogc.kml.KMLAbstractGeometry;
import gov.nasa.worldwind.ogc.kml.KMLAbstractSubStyle;
import gov.nasa.worldwind.ogc.kml.KMLIcon;
import gov.nasa.worldwind.ogc.kml.KMLIconStyle;
import gov.nasa.worldwind.ogc.kml.KMLLabelStyle;
import gov.nasa.worldwind.ogc.kml.KMLLineStyle;
import gov.nasa.worldwind.ogc.kml.KMLPlacemark;
import gov.nasa.worldwind.ogc.kml.KMLPoint;
import gov.nasa.worldwind.ogc.kml.KMLVec2;
import gov.nasa.worldwind.ogc.kml.impl.KMLRenderable;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.ogc.kml.impl.KMLUtil;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.PointPlacemark;
import gov.nasa.worldwind.render.PointPlacemarkAttributes;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.io.IOException;

public class KMLPointPlacemarkImpl
extends PointPlacemark
implements KMLRenderable {
    protected final KMLPlacemark parent;
    protected boolean highlightAttributesResolved = false;
    protected boolean normalAttributesResolved = false;
    protected long iconRetrievalTime;
    protected long highlightIconRetrievalTime;
    public static final double DEFAULT_LABEL_SCALE_THRESHOLD = 1.0;
    protected double labelScaleThreshold = 1.0;

    public KMLPointPlacemarkImpl(KMLTraversalContext kMLTraversalContext, KMLPlacemark kMLPlacemark, KMLAbstractGeometry kMLAbstractGeometry) {
        super(((KMLPoint)kMLAbstractGeometry).getCoordinates());
        String string;
        String string2;
        if (kMLTraversalContext == null) {
            String string3 = Logging.getMessage("nullValue.TraversalContextIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (kMLPlacemark == null) {
            String string4 = Logging.getMessage("nullValue.ParentIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.parent = kMLPlacemark;
        KMLPoint kMLPoint = (KMLPoint)kMLAbstractGeometry;
        this.setAltitudeMode(1);
        if (kMLPoint.isExtrude()) {
            this.setLineEnabled(true);
        }
        if (!WWUtil.isEmpty(string2 = kMLPoint.getAltitudeMode())) {
            if ("clampToGround".equals(string2)) {
                this.setAltitudeMode(1);
            } else if ("relativeToGround".equals(string2)) {
                this.setAltitudeMode(2);
            } else if ("absolute".equals(string2)) {
                this.setAltitudeMode(0);
            }
        }
        if (this.parent.getVisibility() != null) {
            this.setVisible(this.parent.getVisibility());
        }
        if (kMLPlacemark.getName() != null) {
            this.setLabelText(kMLPlacemark.getName());
            this.setValue("gov.nasa.worldwind.avkey.DisplayName", kMLPlacemark.getName());
        }
        if ((string = kMLPlacemark.getDescription()) != null) {
            this.setValue("gov.nasa.worldwind.avkey.Description", string);
        }
        if (kMLPlacemark.getSnippetText() != null) {
            this.setValue("gov.nasa.worldwind.avkey.Server.ShortDescription", kMLPlacemark.getSnippetText());
        }
        this.setValue("gov.nasa.worldwind.avkey.Context", this.parent);
    }

    @Override
    public void preRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
    }

    @Override
    public void render(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        PointPlacemarkAttributes pointPlacemarkAttributes;
        if (this.isHighlighted()) {
            PointPlacemarkAttributes pointPlacemarkAttributes2;
            if (!this.highlightAttributesResolved && ((pointPlacemarkAttributes2 = this.getHighlightAttributes()) == null || pointPlacemarkAttributes2.isUnresolved())) {
                pointPlacemarkAttributes2 = this.makeAttributesCurrent("highlight");
                if (pointPlacemarkAttributes2 != null) {
                    this.setHighlightAttributes(pointPlacemarkAttributes2);
                    if (!pointPlacemarkAttributes2.isUnresolved()) {
                        this.highlightAttributesResolved = true;
                    }
                } else {
                    this.highlightAttributesResolved = true;
                }
            }
        } else if (!this.normalAttributesResolved && ((pointPlacemarkAttributes = this.getAttributes()) == null || pointPlacemarkAttributes.isUnresolved())) {
            pointPlacemarkAttributes = this.makeAttributesCurrent("normal");
            if (pointPlacemarkAttributes != null) {
                this.setAttributes(pointPlacemarkAttributes);
                if (!pointPlacemarkAttributes.isUnresolved()) {
                    this.normalAttributesResolved = true;
                }
            } else {
                this.normalAttributesResolved = true;
            }
        }
        this.render(drawContext);
    }

    @Override
    protected void determineActiveAttributes() {
        String string;
        super.determineActiveAttributes();
        if (this.mustRefreshIcon() && !WWUtil.isEmpty(string = this.getActiveAttributes().getImageAddress())) {
            boolean bl = this.isHighlighted();
            this.parent.getRoot().evictIfExpired(string, bl ? this.highlightIconRetrievalTime : this.iconRetrievalTime);
            this.textures.remove(string);
        }
    }

    protected boolean mustRefreshIcon() {
        long l;
        String string;
        if (this.isHighlighted()) {
            string = "highlight";
            l = this.highlightIconRetrievalTime;
        } else {
            string = "normal";
            l = this.iconRetrievalTime;
        }
        KMLIconStyle kMLIconStyle = (KMLIconStyle)this.parent.getSubStyle(new KMLIconStyle(null), string);
        KMLIcon kMLIcon = kMLIconStyle.getIcon();
        return kMLIcon != null && kMLIcon.getUpdateTime() > l;
    }

    @Override
    protected WWTexture initializeTexture(String string) {
        WWTexture wWTexture = super.initializeTexture(string);
        if (wWTexture != null) {
            long l = this.parent.getRoot().getExpiration(string);
            String string2 = this.isHighlighted() ? "highlight" : "normal";
            KMLIconStyle kMLIconStyle = (KMLIconStyle)this.parent.getSubStyle(new KMLIconStyle(null), string2);
            KMLIcon kMLIcon = kMLIconStyle.getIcon();
            if (kMLIcon != null) {
                kMLIcon.setExpirationTime(l);
            }
            if (this.isHighlighted()) {
                this.highlightIconRetrievalTime = System.currentTimeMillis();
            } else {
                this.iconRetrievalTime = System.currentTimeMillis();
            }
        }
        return wWTexture;
    }

    @Override
    protected PickedObject createPickedObject(DrawContext drawContext, Color color) {
        PickedObject pickedObject = super.createPickedObject(drawContext, color);
        pickedObject.setValue("gov.nasa.worldwind.avkey.Context", this.parent);
        return pickedObject;
    }

    @Override
    protected boolean mustDrawLabel() {
        double d = this.getActiveAttributes().getLabelScale() != null ? this.getActiveAttributes().getLabelScale() : PointPlacemarkAttributes.DEFAULT_LABEL_SCALE;
        double d2 = this.getActiveAttributes().getScale() != null ? this.getActiveAttributes().getScale() : PointPlacemarkAttributes.DEFAULT_IMAGE_SCALE;
        return this.isHighlighted() || d >= this.getLabelScaleThreshold() || d2 == 0.0;
    }

    protected PointPlacemarkAttributes makeAttributesCurrent(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        PointPlacemarkAttributes pointPlacemarkAttributes = this.getInitialAttributes(this.isHighlighted() ? "highlight" : "normal");
        KMLAbstractSubStyle kMLAbstractSubStyle = this.parent.getSubStyle(new KMLLineStyle(null), string);
        if (kMLAbstractSubStyle.hasFields() && (!this.isHighlighted() || KMLUtil.isHighlightStyleState(kMLAbstractSubStyle))) {
            bl = true;
            this.assembleLineAttributes(pointPlacemarkAttributes, (KMLLineStyle)kMLAbstractSubStyle);
            if (kMLAbstractSubStyle.hasField("gov.nasa.worldwind.avkey.Unresolved")) {
                pointPlacemarkAttributes.setUnresolved(true);
            }
        }
        if ((kMLAbstractSubStyle = this.parent.getSubStyle(new KMLIconStyle(null), string)).hasFields() && (!this.isHighlighted() || KMLUtil.isHighlightStyleState(kMLAbstractSubStyle))) {
            bl2 = true;
            this.assemblePointAttributes(pointPlacemarkAttributes, (KMLIconStyle)kMLAbstractSubStyle);
            if (kMLAbstractSubStyle.hasField("gov.nasa.worldwind.avkey.Unresolved")) {
                pointPlacemarkAttributes.setUnresolved(true);
            }
        }
        if ((kMLAbstractSubStyle = this.parent.getSubStyle(new KMLLabelStyle(null), string)).hasFields() && (!this.isHighlighted() || KMLUtil.isHighlightStyleState(kMLAbstractSubStyle))) {
            bl3 = true;
            this.assembleLabelAttributes(pointPlacemarkAttributes, (KMLLabelStyle)kMLAbstractSubStyle);
            if (kMLAbstractSubStyle.hasField("gov.nasa.worldwind.avkey.Unresolved")) {
                pointPlacemarkAttributes.setUnresolved(true);
            }
        }
        if (bl || bl2 || bl3) {
            return pointPlacemarkAttributes;
        }
        return null;
    }

    protected PointPlacemarkAttributes assemblePointAttributes(PointPlacemarkAttributes pointPlacemarkAttributes, KMLIconStyle kMLIconStyle) {
        Object object;
        KMLIcon kMLIcon = kMLIconStyle.getIcon();
        if (kMLIcon != null && kMLIcon.getHref() != null) {
            object = kMLIcon.getHref();
            String string = null;
            try {
                string = this.parent.getRoot().getSupportFilePath((String)object);
            }
            catch (IOException iOException) {
                String string2 = Logging.getMessage("generic.UnableToResolveReference", (String)object);
                Logging.logger().warning(string2);
            }
            pointPlacemarkAttributes.setImageAddress((String)(string != null ? string : object));
        } else if (kMLIcon != null && WWUtil.isEmpty(kMLIcon.getHref())) {
            pointPlacemarkAttributes.setUsePointAsDefaultImage(true);
        }
        if (kMLIconStyle.getColor() != null) {
            pointPlacemarkAttributes.setImageColor(WWUtil.decodeColorABGR(kMLIconStyle.getColor()));
        }
        if (kMLIconStyle.getColorMode() != null && "random".equals(kMLIconStyle.getColorMode())) {
            pointPlacemarkAttributes.setImageColor(WWUtil.makeRandomColor(pointPlacemarkAttributes.getImageColor()));
        }
        if (kMLIconStyle.getScale() != null) {
            pointPlacemarkAttributes.setScale(kMLIconStyle.getScale());
        }
        if (kMLIconStyle.getHeading() != null) {
            pointPlacemarkAttributes.setHeading(kMLIconStyle.getHeading());
            pointPlacemarkAttributes.setHeadingReference("gov.nasa.worldwind.avkey.RelativeToGlobe");
        }
        if (kMLIconStyle.getHotSpot() != null) {
            object = kMLIconStyle.getHotSpot();
            pointPlacemarkAttributes.setImageOffset(new Offset(((KMLVec2)object).getX(), ((KMLVec2)object).getY(), KMLUtil.kmlUnitsToWWUnits(((KMLVec2)object).getXunits()), KMLUtil.kmlUnitsToWWUnits(((KMLVec2)object).getYunits())));
        } else {
            pointPlacemarkAttributes.setImageOffset(new Offset(0.5, 0.5, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction"));
        }
        return pointPlacemarkAttributes;
    }

    protected PointPlacemarkAttributes assembleLineAttributes(PointPlacemarkAttributes pointPlacemarkAttributes, KMLLineStyle kMLLineStyle) {
        if (kMLLineStyle.getWidth() != null) {
            pointPlacemarkAttributes.setLineWidth(kMLLineStyle.getWidth());
        }
        if (kMLLineStyle.getColor() != null) {
            pointPlacemarkAttributes.setLineColor(kMLLineStyle.getColor());
        }
        if (kMLLineStyle.getColorMode() != null && "random".equals(kMLLineStyle.getColorMode())) {
            pointPlacemarkAttributes.setLineMaterial(new Material(WWUtil.makeRandomColor(pointPlacemarkAttributes.getLineColor())));
        }
        return pointPlacemarkAttributes;
    }

    protected PointPlacemarkAttributes assembleLabelAttributes(PointPlacemarkAttributes pointPlacemarkAttributes, KMLLabelStyle kMLLabelStyle) {
        if (kMLLabelStyle.getScale() != null) {
            pointPlacemarkAttributes.setLabelScale(kMLLabelStyle.getScale());
        }
        if (kMLLabelStyle.getColor() != null) {
            pointPlacemarkAttributes.setLabelColor(kMLLabelStyle.getColor());
        }
        if (kMLLabelStyle.getColorMode() != null && "random".equals(kMLLabelStyle.getColorMode())) {
            pointPlacemarkAttributes.setLabelMaterial(new Material(WWUtil.makeRandomColor(pointPlacemarkAttributes.getLabelColor())));
        }
        return pointPlacemarkAttributes;
    }

    protected PointPlacemarkAttributes getInitialAttributes(String string) {
        return new PointPlacemarkAttributes();
    }

    public double getLabelScaleThreshold() {
        return this.labelScaleThreshold;
    }

    public void setLabelScaleThreshold(double d) {
        this.labelScaleThreshold = d;
    }

    @Override
    public void onMessage(Message message) {
        super.onMessage(message);
        if ("KMLAbstractObject.StyleChanged".equals(message.getName())) {
            this.normalAttributesResolved = false;
            this.highlightAttributesResolved = false;
            if (this.getAttributes() != null) {
                this.getAttributes().setUnresolved(true);
            }
            if (this.getHighlightAttributes() != null) {
                this.getHighlightAttributes().setUnresolved(true);
            }
        }
    }
}

