/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.gx;

import gov.nasa.worldwind.ogc.kml.KMLTimeSpan;
import gov.nasa.worldwind.ogc.kml.KMLTimeStamp;
import gov.nasa.worldwind.ogc.kml.gx.GXAnimatedUpdate;
import gov.nasa.worldwind.ogc.kml.gx.GXFlyTo;
import gov.nasa.worldwind.ogc.kml.gx.GXLatLongQuad;
import gov.nasa.worldwind.ogc.kml.gx.GXPlaylist;
import gov.nasa.worldwind.ogc.kml.gx.GXSoundCue;
import gov.nasa.worldwind.ogc.kml.gx.GXTour;
import gov.nasa.worldwind.ogc.kml.gx.GXTourControl;
import gov.nasa.worldwind.ogc.kml.gx.GXWait;
import gov.nasa.worldwind.util.xml.BasicXMLEventParserContext;
import gov.nasa.worldwind.util.xml.BooleanXMLEventParser;
import gov.nasa.worldwind.util.xml.DoubleXMLEventParser;
import gov.nasa.worldwind.util.xml.StringXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;

public class GXParserContext
extends BasicXMLEventParserContext {
    protected static final String[] StringFields = new String[]{"altitudeMode", "description", "flyToMode", "playMode"};
    protected static final String[] DoubleFields = new String[]{"duration"};
    protected static final String[] BooleanFields = new String[]{"balloonVisibility"};

    public static Map<QName, XMLEventParser> getDefaultParsers() {
        ConcurrentHashMap<QName, XMLEventParser> concurrentHashMap = new ConcurrentHashMap<QName, XMLEventParser>();
        String string = "http://www.google.com/kml/ext/2.2";
        concurrentHashMap.put(new QName(string, "AnimatedUpdate"), new GXAnimatedUpdate(string));
        concurrentHashMap.put(new QName(string, "FlyTo"), new GXFlyTo(string));
        concurrentHashMap.put(new QName(string, "LatLonQuad"), new GXLatLongQuad(string));
        concurrentHashMap.put(new QName(string, "Playlist"), new GXPlaylist(string));
        concurrentHashMap.put(new QName(string, "SoundCue"), new GXSoundCue(string));
        concurrentHashMap.put(new QName(string, "TimeSpan"), new KMLTimeSpan(string));
        concurrentHashMap.put(new QName(string, "TimeStamp"), new KMLTimeStamp(string));
        concurrentHashMap.put(new QName(string, "Tour"), new GXTour(string));
        concurrentHashMap.put(new QName(string, "TourControl"), new GXTourControl(string));
        concurrentHashMap.put(new QName(string, "Wait"), new GXWait(string));
        StringXMLEventParser stringXMLEventParser = new StringXMLEventParser();
        for (String string2 : StringFields) {
            concurrentHashMap.put(new QName(string, string2), stringXMLEventParser);
        }
        DoubleXMLEventParser doubleXMLEventParser = new DoubleXMLEventParser();
        for (String string3 : DoubleFields) {
            concurrentHashMap.put(new QName(string, string3), doubleXMLEventParser);
        }
        BooleanXMLEventParser booleanXMLEventParser = new BooleanXMLEventParser();
        for (String string4 : BooleanFields) {
            concurrentHashMap.put(new QName(string, string4), booleanXMLEventParser);
        }
        return concurrentHashMap;
    }
}

