/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLAbstractOverlay;
import gov.nasa.worldwind.ogc.kml.KMLLatLonBox;
import gov.nasa.worldwind.ogc.kml.gx.GXLatLongQuad;
import gov.nasa.worldwind.ogc.kml.impl.KMLGroundOverlayPolygonImpl;
import gov.nasa.worldwind.ogc.kml.impl.KMLRenderable;
import gov.nasa.worldwind.ogc.kml.impl.KMLSurfaceImageImpl;
import gov.nasa.worldwind.ogc.kml.impl.KMLSurfacePolygonImpl;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.ogc.kml.impl.KMLUtil;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;

public class KMLGroundOverlay
extends KMLAbstractOverlay
implements KMLRenderable {
    protected KMLRenderable renderable;

    public KMLGroundOverlay(String string) {
        super(string);
    }

    public Double getAltitude() {
        return (Double)this.getField("altitude");
    }

    public String getAltitudeMode() {
        return (String)this.getField("altitudeMode");
    }

    public KMLLatLonBox getLatLonBox() {
        return (KMLLatLonBox)this.getField("LatLonBox");
    }

    public GXLatLongQuad getLatLonQuad() {
        return (GXLatLongQuad)this.getField("LatLonQuad");
    }

    @Override
    protected void doPreRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        KMLRenderable kMLRenderable;
        if (this.getRenderable() == null) {
            this.initializeRenderable(kMLTraversalContext);
        }
        if ((kMLRenderable = this.getRenderable()) != null) {
            kMLRenderable.preRender(kMLTraversalContext, drawContext);
        }
    }

    @Override
    protected void doRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        KMLRenderable kMLRenderable = this.getRenderable();
        if (kMLRenderable != null) {
            kMLRenderable.render(kMLTraversalContext, drawContext);
        }
        this.renderBalloon(kMLTraversalContext, drawContext);
    }

    protected void initializeRenderable(KMLTraversalContext kMLTraversalContext) {
        String string = this.getAltitudeMode();
        this.renderable = "absolute".equals(string) ? new KMLGroundOverlayPolygonImpl(kMLTraversalContext, this) : (this.getIcon() != null && this.getIcon().getHref() != null ? new KMLSurfaceImageImpl(kMLTraversalContext, this) : new KMLSurfacePolygonImpl(kMLTraversalContext, this));
    }

    public KMLRenderable getRenderable() {
        return this.renderable;
    }

    public Position.PositionList getPositions() {
        ArrayList<Position> arrayList;
        block3: {
            double d;
            block2: {
                d = this.getAltitude() != null ? this.getAltitude() : 0.0;
                arrayList = new ArrayList<Position>(4);
                KMLLatLonBox kMLLatLonBox = this.getLatLonBox();
                if (kMLLatLonBox == null) break block2;
                Sector sector = KMLUtil.createSectorFromLatLonBox(kMLLatLonBox);
                for (LatLon latLon : sector.getCorners()) {
                    arrayList.add(new Position(latLon, d));
                }
                break block3;
            }
            GXLatLongQuad gXLatLongQuad = this.getLatLonQuad();
            if (gXLatLongQuad == null || gXLatLongQuad.getCoordinates() == null) break block3;
            for (Position position : gXLatLongQuad.getCoordinates().list) {
                arrayList.add(new Position(position, d));
            }
        }
        return new Position.PositionList(arrayList);
    }

    @Override
    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (!(kMLAbstractObject instanceof KMLGroundOverlay)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        this.renderable = null;
        super.applyChange(kMLAbstractObject);
    }

    @Override
    public void onChange(Message message) {
        if ("KMLAbstractObject.LinkChanged".equals(message.getName())) {
            this.renderable = null;
        }
        if ("KMLAbstractObject.BoxChanged".equals(message.getName())) {
            this.renderable = null;
        }
        super.onChange(message);
    }
}

