/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.BasicRasterServer;
import gov.nasa.worldwind.data.RasterServer;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.retrieve.LocalRasterServerRetriever;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.RetrieverFactory;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.io.File;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LocalRasterServerLayer
extends BasicTiledImageLayer {
    public LocalRasterServerLayer(AVList aVList) {
        super(aVList);
        this.createRasterServer(aVList);
    }

    public LocalRasterServerLayer(Document document, AVList aVList) {
        super(document, aVList);
        this.createRasterServer(aVList != null ? aVList : (AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters"));
    }

    public LocalRasterServerLayer(Element element, AVList aVList) {
        super(element, aVList);
        this.createRasterServer(aVList != null ? aVList : (AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters"));
    }

    public LocalRasterServerLayer(String string) {
        super(string);
        this.createRasterServer((AVList)this.getValue("gov.nasa.worldwind.avkey.ConstructionParameters"));
    }

    protected void createRasterServer(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParamsIsNull");
            String string2 = Logging.getMessage("generic.CannotCreateRasterServer", string);
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        if (this.getDataFileStore() == null) {
            String string = Logging.getMessage("nullValue.FileStoreIsNull");
            String string3 = Logging.getMessage("generic.CannotCreateRasterServer", string);
            Logging.logger().severe(string3);
            throw new IllegalStateException(string3);
        }
        String string = aVList.getStringValue("gov.nasa.worldwind.avkey.DatasetNameKey");
        if (WWUtil.isEmpty(string)) {
            String string4 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.DatasetNameKey");
            String string5 = Logging.getMessage("generic.CannotCreateRasterServer", string4);
            Logging.logger().severe(string5);
            throw new IllegalStateException(string5);
        }
        String string6 = aVList.getStringValue("gov.nasa.worldwind.avkey.DataCacheNameKey");
        if (WWUtil.isEmpty(string6)) {
            String string7 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.DataCacheNameKey");
            String string8 = Logging.getMessage("generic.CannotCreateRasterServer", string7);
            Logging.logger().severe(string8);
            throw new IllegalStateException(string8);
        }
        String string9 = string6 + File.separator + string + ".RasterServer.xml";
        final URL uRL = this.getDataFileStore().findFile(string9, false);
        if (WWUtil.isEmpty(uRL)) {
            String string10 = Logging.getMessage("Configuration.ConfigNotFound", string9);
            String string11 = Logging.getMessage("generic.CannotCreateRasterServer", string10);
            Logging.logger().severe(string11);
            throw new IllegalStateException(string11);
        }
        final AVList aVList2 = aVList.copy();
        aVList2.setValue("gov.nasa.worldwind.avkey.FileStore", this.getDataFileStore());
        RetrieverFactory retrieverFactory = new RetrieverFactory(){
            protected final RasterServer rasterServer;
            {
                this.rasterServer = new BasicRasterServer(uRL, aVList2);
            }

            @Override
            public Retriever createRetriever(AVList aVList, RetrievalPostProcessor retrievalPostProcessor) {
                LocalRasterServerRetriever localRasterServerRetriever = new LocalRasterServerRetriever(aVList, this.rasterServer, retrievalPostProcessor);
                String[] stringArray = new String[]{"gov.nasa.worldwind.avkey.DatasetNameKey", "gov.nasa.worldwind.avkey.DisplayName", "gov.nasa.worldwind.avkey.FileStore", "gov.nasa.worldwind.avkey.ImageFormat", "gov.nasa.worldwind.avkey.FormatSuffixKey"};
                WWUtil.copyValues(aVList2, localRasterServerRetriever, stringArray, false);
                return localRasterServerRetriever;
            }
        };
        aVList.setValue("gov.nasa.worldwind.avkey.RetrieverFactoryLocal", retrieverFactory);
        this.setValue("gov.nasa.worldwind.avkey.RetrieverFactoryLocal", retrieverFactory);
    }
}

