/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.rpf;

import gov.nasa.worldwind.formats.rpf.RPFDataSeries;
import gov.nasa.worldwind.formats.rpf.RPFNonpolarFrameTransform;
import gov.nasa.worldwind.formats.rpf.RPFPolarFrameTransform;
import gov.nasa.worldwind.formats.rpf.RPFZone;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import java.awt.image.BufferedImage;

public abstract class RPFFrameTransform {
    RPFFrameTransform() {
    }

    public static RPFFrameTransform createFrameTransform(char c, String string, double d) {
        if (!RPFZone.isZoneCode(c)) {
            String string2 = Logging.getMessage("RPFZone.UnknownZoneCode", Character.valueOf(c));
            Logging.logger().fine(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null || !RPFDataSeries.isRPFDataType(string)) {
            String string3 = Logging.getMessage("RPFDataSeries.UnkownDataType", string);
            Logging.logger().fine(string3);
            throw new IllegalArgumentException(string3);
        }
        if (d < 0.0) {
            String string4 = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().fine(string4);
            throw new IllegalArgumentException(string4);
        }
        return RPFFrameTransform.newFrameTransform(c, string, d);
    }

    private static RPFFrameTransform newFrameTransform(char c, String string, double d) {
        boolean bl;
        boolean bl2 = bl = !RPFZone.isPolarZone(c);
        if (bl) {
            return RPFNonpolarFrameTransform.createNonpolarFrameTransform(c, string, d);
        }
        return RPFPolarFrameTransform.createPolarFrameTransform(c, string, d);
    }

    public abstract int getFrameNumber(int var1, int var2);

    public abstract int getMaximumFrameNumber();

    public abstract int getRows();

    public abstract int getColumns();

    public abstract LatLon computeFrameOrigin(int var1);

    public abstract Sector computeFrameCoverage(int var1);

    public abstract RPFImage[] deproject(int var1, BufferedImage var2);

    static int frameNumber(int n, int n2, int n3) {
        return n2 + n * n3;
    }

    static int maxFrameNumber(int n, int n2) {
        return n * n2 - 1;
    }

    static int frameRow(int n, int n2) {
        return (int)((double)n / (double)n2);
    }

    static int frameColumn(int n, int n2, int n3) {
        return n - n2 * n3;
    }

    public class RPFImage {
        public Sector sector;
        public BufferedImage image;

        RPFImage(Sector sector, BufferedImage bufferedImage) {
            this.sector = sector;
            this.image = bufferedImage;
        }

        public Sector getSector() {
            return this.sector;
        }

        public BufferedImage getImage() {
            return this.image;
        }
    }
}

