/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.AbstractDataRasterWriter;
import gov.nasa.worldwind.data.ByteBufferRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BILRasterWriter
extends AbstractDataRasterWriter {
    protected static final String[] bilMimeTypes = new String[]{"image/bil"};
    protected static final String[] bilSuffixes = new String[]{"bil"};
    protected boolean writeGeoreferenceFiles;

    public BILRasterWriter(boolean bl) {
        super(bilMimeTypes, bilSuffixes);
        this.writeGeoreferenceFiles = bl;
    }

    public BILRasterWriter() {
        this(true);
    }

    public boolean isWriteGeoreferenceFiles() {
        return this.writeGeoreferenceFiles;
    }

    public void setWriteGeoreferenceFiles(boolean bl) {
        this.writeGeoreferenceFiles = bl;
    }

    @Override
    protected boolean doCanWrite(DataRaster dataRaster, String string, File file) {
        return dataRaster != null && dataRaster instanceof ByteBufferRaster;
    }

    @Override
    protected void doWrite(DataRaster dataRaster, String string, File file) throws IOException {
        this.writeRaster(dataRaster, file);
        if (this.isWriteGeoreferenceFiles()) {
            AVListImpl aVListImpl = new AVListImpl();
            this.initWorldFileParams(dataRaster, aVListImpl);
            String string2 = this.validate(aVListImpl, dataRaster);
            if (string2 != null) {
                Logging.logger().severe(string2);
                throw new IOException(string2);
            }
            File file2 = file.getParentFile();
            String string3 = WWIO.replaceSuffix(file.getName(), "");
            this.writeWorldFile(aVListImpl, new File(file2, string3 + ".blw"));
            this.writeHdrFile(aVListImpl, new File(file2, string3 + ".hdr"));
        }
    }

    protected void writeRaster(DataRaster dataRaster, File file) throws IOException {
        ByteBufferRaster byteBufferRaster = (ByteBufferRaster)dataRaster;
        ByteBuffer byteBuffer = byteBufferRaster.getByteBuffer();
        boolean bl = false;
        WWIO.saveBuffer(byteBuffer, file, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeWorldFile(AVList aVList, File file) throws IOException {
        Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        int[] nArray = (int[])aVList.getValue("gov.nasa.worldwind.worldFile.ImageSize");
        double d = sector.getDeltaLonDegrees() / (double)(nArray[0] - 1);
        double d2 = -sector.getDeltaLatDegrees() / (double)(nArray[1] - 1);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = sector.getMinLongitude().degrees;
        double d6 = sector.getMaxLatitude().degrees;
        PrintWriter printWriter = new PrintWriter(file);
        try {
            printWriter.println(d);
            printWriter.println(d3);
            printWriter.println(d4);
            printWriter.println(d2);
            printWriter.println(d5);
            printWriter.println(d6);
        }
        finally {
            printWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHdrFile(AVList aVList, File file) throws IOException {
        int[] nArray = (int[])aVList.getValue("gov.nasa.worldwind.worldFile.ImageSize");
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder");
        Object object2 = aVList.getValue("gov.nasa.worldwind.avkey.DataType");
        int n = 0;
        if ("gov.nasa.worldwind.avkey.Int8".equals(object2)) {
            n = 8;
        } else if ("gov.nasa.worldwind.avkey.Int16".equals(object2)) {
            n = 16;
        } else if ("gov.nasa.worldwind.avkey.Int32".equals(object2) || "gov.nasa.worldwind.avkey.Float32".equals(object2)) {
            n = 32;
        }
        int n2 = nArray[0] * (n / 8);
        PrintWriter printWriter = new PrintWriter(file);
        try {
            printWriter.append("BYTEORDER      ").println("gov.nasa.worldwind.avkey.BigEndian".equals(object) ? "M" : "I");
            printWriter.append("LAYOUT         ").println("BIL");
            printWriter.append("NROWS          ").println(nArray[1]);
            printWriter.append("NCOLS          ").println(nArray[0]);
            printWriter.append("NBANDS         ").println(1);
            printWriter.append("NBITS          ").println(n);
            printWriter.append("BANDROWBYTES   ").println(n2);
            printWriter.append("TOTALROWBYTES  ").println(n2);
            printWriter.append("BANDGAPBYTES   ").println(0);
            Object object3 = aVList.getValue("gov.nasa.worldwind.avkey.MissingDataValue");
            if (object3 != null) {
                printWriter.append("NODATA         ").println(object3);
            }
        }
        finally {
            printWriter.close();
        }
    }

    protected void initWorldFileParams(DataRaster dataRaster, AVList aVList) {
        ByteBufferRaster byteBufferRaster = (ByteBufferRaster)dataRaster;
        int[] nArray = new int[]{dataRaster.getWidth(), dataRaster.getHeight()};
        aVList.setValue("gov.nasa.worldwind.worldFile.ImageSize", nArray);
        Sector sector = dataRaster.getSector();
        aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        aVList.setValue("gov.nasa.worldwind.avkey.ByteOrder", BILRasterWriter.getByteOrder(byteBufferRaster.getByteBuffer()));
        aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Elevation");
        aVList.setValue("gov.nasa.worldwind.avkey.DataType", BILRasterWriter.getDataType(byteBufferRaster.getBuffer()));
        double d = byteBufferRaster.getTransparentValue();
        if (d != Double.MAX_VALUE) {
            aVList.setValue("gov.nasa.worldwind.avkey.MissingDataValue", d);
        }
    }

    private static Object getDataType(BufferWrapper bufferWrapper) {
        String string = null;
        if (bufferWrapper instanceof BufferWrapper.ByteBufferWrapper) {
            string = "gov.nasa.worldwind.avkey.Int8";
        } else if (bufferWrapper instanceof BufferWrapper.ShortBufferWrapper) {
            string = "gov.nasa.worldwind.avkey.Int16";
        } else if (bufferWrapper instanceof BufferWrapper.IntBufferWrapper) {
            string = "gov.nasa.worldwind.avkey.Int32";
        } else if (bufferWrapper instanceof BufferWrapper.FloatBufferWrapper) {
            string = "gov.nasa.worldwind.avkey.Float32";
        }
        return string;
    }

    private static Object getByteOrder(ByteBuffer byteBuffer) {
        return ByteOrder.LITTLE_ENDIAN.equals(byteBuffer.order()) ? "gov.nasa.worldwind.avkey.LittleEndian" : "gov.nasa.worldwind.avkey.BigEndian";
    }

    protected String validate(AVList aVList, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = aVList.getValue("gov.nasa.worldwind.worldFile.ImageSize");
        if (object2 == null || !(object2 instanceof int[])) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoSizeSpecified", object));
        }
        if ((object2 = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) == null || !(object2 instanceof Sector)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoSectorSpecified", object));
        }
        if ((object2 = aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder")) == null || !(object2 instanceof String)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoByteOrderSpecified", object));
        }
        if ((object2 = aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat")) == null) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoPixelFormatSpecified", object));
        } else if (!"gov.nasa.worldwind.avkey.Elevation".equals(object2)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.InvalidPixelFormat", object));
        }
        object2 = aVList.getValue("gov.nasa.worldwind.avkey.DataType");
        if (object2 == null) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("WorldFile.NoDataTypeSpecified", object));
        }
        if (stringBuilder.length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }
}

