/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.bufr.BufrConfig;
import ucar.nc2.iosp.bufr.BufrNumbers;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.tables.CodeFlagTables;

class BufrIospBuilder {
    private static Logger log = LoggerFactory.getLogger(BufrIospBuilder.class);
    private static final boolean warnUnits = false;
    private final Group.Builder rootGroup;
    private final Sequence.Builder recordStructure;
    private final Formatter coordinates = new Formatter();
    private int tempNo = 1;
    private Map<String, Integer> names = new HashMap<String, Integer>(100);

    BufrIospBuilder(Message proto, BufrConfig bufrConfig, Group.Builder root, String location) {
        this.rootGroup = root;
        this.recordStructure = (Sequence.Builder)Sequence.builder().setName("obs");
        this.rootGroup.addVariable(this.recordStructure);
        AttributeContainerMutable atts = root.getAttributeContainer();
        atts.addAttribute("history", "Read using CDM BufrIosp2");
        if (bufrConfig.getFeatureType() != null) {
            atts.addAttribute("featureType", bufrConfig.getFeatureType().toString());
        }
        atts.addAttribute("location", location);
        atts.addAttribute("BUFR:categoryName", proto.getLookup().getCategoryName());
        atts.addAttribute("BUFR:subCategoryName", proto.getLookup().getSubCategoryName());
        atts.addAttribute("BUFR:centerName", proto.getLookup().getCenterName());
        atts.addAttribute("BUFR:category", proto.ids.getCategory());
        atts.addAttribute("BUFR:subCategory", proto.ids.getSubCategory());
        atts.addAttribute("BUFR:localSubCategory", proto.ids.getLocalSubCategory());
        atts.addAttribute("BUFR:centerId", proto.ids.getCenterId());
        atts.addAttribute("BUFR:subCenter", proto.ids.getSubCenterId());
        atts.addAttribute("BUFR:table", proto.ids.getMasterTableId());
        atts.addAttribute("BUFR:tableVersion", proto.ids.getMasterTableVersion());
        atts.addAttribute("BUFR:localTableVersion", proto.ids.getLocalTableVersion());
        atts.addAttribute("Conventions", "BUFR/CDM");
        atts.addAttribute("BUFR:edition", proto.is.getBufrEdition());
        String header = proto.getHeader();
        if (header != null && !header.isEmpty()) {
            atts.addAttribute("WMO Header", header);
        }
        this.makeObsRecord(bufrConfig);
        String coordS = this.coordinates.toString();
        if (!coordS.isEmpty()) {
            this.recordStructure.addAttribute(new Attribute("coordinates", coordS));
        }
    }

    Sequence.Builder getObsStructure() {
        return this.recordStructure;
    }

    private void makeObsRecord(BufrConfig bufrConfig) {
        BufrConfig.FieldConverter root = bufrConfig.getRootConverter();
        for (BufrConfig.FieldConverter fld : root.flds) {
            DataDescriptor dkey = fld.dds;
            if (!dkey.isOkForVariable()) continue;
            if (dkey.replication == 0) {
                this.addSequence(this.rootGroup, this.recordStructure, fld);
                continue;
            }
            if (dkey.replication > 1) {
                List<BufrConfig.FieldConverter> subFlds = fld.flds;
                List<DataDescriptor> subKeys = dkey.subKeys;
                if (subKeys.size() == 1) {
                    DataDescriptor subDds = dkey.subKeys.get(0);
                    BufrConfig.FieldConverter subFld = subFlds.get(0);
                    if (subDds.dpi != null) {
                        this.addDpiStructure(this.recordStructure, fld, subFld);
                        continue;
                    }
                    if (subDds.replication == 1) {
                        Variable.Builder v = this.addVariable(this.rootGroup, this.recordStructure, subFld, dkey.replication);
                        v.setSPobject(fld);
                        continue;
                    }
                    this.addStructure(this.rootGroup, this.recordStructure, fld, dkey.replication);
                    continue;
                }
                if (subKeys.size() <= 1) continue;
                this.addStructure(this.rootGroup, this.recordStructure, fld, dkey.replication);
                continue;
            }
            this.addVariable(this.rootGroup, this.recordStructure, fld, dkey.replication);
        }
    }

    private void addStructure(Group.Builder group, Structure.Builder parent, BufrConfig.FieldConverter fld, int count) {
        String uname;
        DataDescriptor dkey = fld.dds;
        dkey.name = uname = this.findUniqueName(parent, fld.getName(), "struct");
        Structure.Builder struct = (Structure.Builder)Structure.builder().setName(uname);
        struct.setDimensionsAnonymous(new int[]{count});
        for (BufrConfig.FieldConverter subKey : fld.flds) {
            this.addMember(group, struct, subKey);
        }
        parent.addMemberVariable(struct);
        struct.setSPobject(fld);
    }

    private void addSequence(Group.Builder group, Structure.Builder parent, BufrConfig.FieldConverter fld) {
        String uname;
        DataDescriptor dkey = fld.dds;
        dkey.name = uname = this.findUniqueName(parent, fld.getName(), "seq");
        Sequence.Builder seq = (Sequence.Builder)Sequence.builder().setName(uname);
        for (BufrConfig.FieldConverter subKey : fld.flds) {
            this.addMember(group, seq, subKey);
        }
        parent.addMemberVariable(seq);
        seq.setSPobject(fld);
    }

    private void addMember(Group.Builder group, Structure.Builder parent, BufrConfig.FieldConverter fld) {
        DataDescriptor dkey = fld.dds;
        if (dkey.replication == 0) {
            this.addSequence(group, parent, fld);
        } else if (dkey.replication > 1) {
            List<DataDescriptor> subKeys = dkey.subKeys;
            if (subKeys.size() == 1) {
                BufrConfig.FieldConverter subFld = fld.flds.get(0);
                Variable.Builder v = this.addVariable(group, parent, subFld, dkey.replication);
                v.setSPobject(fld);
            } else {
                this.addStructure(group, parent, fld, dkey.replication);
            }
        } else {
            this.addVariable(group, parent, fld, dkey.replication);
        }
    }

    private void addDpiStructure(Structure.Builder parent, BufrConfig.FieldConverter parentFld, BufrConfig.FieldConverter dpiField) {
        String uname;
        DataDescriptor dpiKey = dpiField.dds;
        dpiKey.name = uname = this.findUniqueName(parent, dpiField.getName(), "struct");
        Structure.Builder struct = (Structure.Builder)Structure.builder().setName(uname);
        parent.addMemberVariable(struct);
        int n = parentFld.dds.replication;
        struct.setDimensionsAnonymous(new int[]{n});
        Object v = Variable.builder().setName("name");
        ((Variable.Builder)v).setDataType(DataType.STRING);
        struct.addMemberVariable((Variable.Builder<?>)v);
        v = Variable.builder().setName("data");
        ((Variable.Builder)v).setDataType(DataType.FLOAT);
        struct.addMemberVariable((Variable.Builder<?>)v);
        struct.setSPobject(dpiField);
    }

    private void addDpiSequence(Structure.Builder parent, BufrConfig.FieldConverter fld) {
        Structure.Builder struct = (Structure.Builder)Structure.builder().setName("statistics");
        struct.setDimensionsAnonymous(new int[]{fld.dds.replication});
        Object v = Variable.builder().setName("name");
        ((Variable.Builder)v).setDataType(DataType.STRING);
        struct.addMemberVariable((Variable.Builder<?>)v);
        v = Variable.builder().setName("data");
        ((Variable.Builder)v).setDataType(DataType.FLOAT);
        struct.addMemberVariable((Variable.Builder<?>)v);
        parent.addMemberVariable(struct);
    }

    private Variable.Builder addVariable(Group.Builder group, Structure.Builder struct, BufrConfig.FieldConverter fld, int count) {
        String uname;
        DataDescriptor dkey = fld.dds;
        dkey.name = uname = this.findGloballyUniqueName(fld.getName(), "unknown");
        Object v = Variable.builder().setName(uname);
        if (count > 1) {
            ((Variable.Builder)v).setDimensionsAnonymous(new int[]{count});
        }
        if (fld.getDesc() != null) {
            ((Variable.Builder)v).addAttribute(new Attribute("long_name", fld.getDesc()));
        }
        if (fld.getUnits() != null) {
            String units = fld.getUnits();
            if (DataDescriptor.isCodeTableUnit(units)) {
                ((Variable.Builder)v).addAttribute(new Attribute("units", "CodeTable " + fld.dds.getFxyName()));
            } else if (DataDescriptor.isFlagTableUnit(units)) {
                ((Variable.Builder)v).addAttribute(new Attribute("units", "FlagTable " + fld.dds.getFxyName()));
            } else if (!DataDescriptor.isInternationalAlphabetUnit(units) && !units.startsWith("Numeric")) {
                ((Variable.Builder)v).addAttribute(new Attribute("units", units));
            }
        }
        DataDescriptor dataDesc = fld.dds;
        if (dataDesc.type == 1) {
            ((Variable.Builder)v).setDataType(DataType.CHAR);
            int size = dataDesc.bitWidth / 8;
            ((Variable.Builder)v).setDimensionsAnonymous(new int[]{size});
        } else if (dataDesc.type == 2 && CodeFlagTables.hasTable(dataDesc.fxy)) {
            int nbits = dataDesc.bitWidth;
            int nbytes = nbits % 8 == 0 ? nbits / 8 : nbits / 8 + 1;
            CodeFlagTables ct = CodeFlagTables.getTable(dataDesc.fxy);
            if (nbytes == 1) {
                ((Variable.Builder)v).setDataType(DataType.ENUM1);
            } else if (nbytes == 2) {
                ((Variable.Builder)v).setDataType(DataType.ENUM2);
            } else if (nbytes == 4) {
                ((Variable.Builder)v).setDataType(DataType.ENUM4);
            }
            ((Variable.Builder)v).addAttribute(new Attribute("BUFR:CodeTable", ct.getName() + " (" + dataDesc.getFxyName() + ")"));
            EnumTypedef type = group.findOrAddEnumTypedef(ct.getName(), ct.getMap());
            ((Variable.Builder)v).setEnumTypeName(type.getShortName());
        } else {
            double scale;
            int nbits = dataDesc.bitWidth;
            if (nbits < 9) {
                ((Variable.Builder)v).setDataType(DataType.BYTE);
                if (nbits == 8) {
                    ((Variable.Builder)v).addAttribute(new Attribute("_Unsigned", "true"));
                    ((Variable.Builder)v).addAttribute(new Attribute("missing_value", (short)BufrNumbers.missingValue(nbits)));
                } else {
                    ((Variable.Builder)v).addAttribute(new Attribute("missing_value", (byte)BufrNumbers.missingValue(nbits)));
                }
            } else if (nbits < 17) {
                ((Variable.Builder)v).setDataType(DataType.SHORT);
                if (nbits == 16) {
                    ((Variable.Builder)v).addAttribute(new Attribute("_Unsigned", "true"));
                    ((Variable.Builder)v).addAttribute(new Attribute("missing_value", (int)BufrNumbers.missingValue(nbits)));
                } else {
                    ((Variable.Builder)v).addAttribute(new Attribute("missing_value", (short)BufrNumbers.missingValue(nbits)));
                }
            } else if (nbits < 33) {
                ((Variable.Builder)v).setDataType(DataType.INT);
                if (nbits == 32) {
                    ((Variable.Builder)v).addAttribute(new Attribute("_Unsigned", "true"));
                    ((Variable.Builder)v).addAttribute(new Attribute("missing_value", (int)BufrNumbers.missingValue(nbits)));
                } else {
                    ((Variable.Builder)v).addAttribute(new Attribute("missing_value", (int)BufrNumbers.missingValue(nbits)));
                }
            } else {
                ((Variable.Builder)v).setDataType(DataType.LONG);
                ((Variable.Builder)v).addAttribute(new Attribute("missing_value", BufrNumbers.missingValue(nbits)));
            }
            int scale10 = dataDesc.scale;
            double d = scale = scale10 == 0 ? 1.0 : Math.pow(10.0, -scale10);
            if (scale10 != 0) {
                ((Variable.Builder)v).addAttribute(new Attribute("scale_factor", Float.valueOf((float)scale)));
            }
            if (dataDesc.refVal != 0) {
                ((Variable.Builder)v).addAttribute(new Attribute("add_offset", Float.valueOf((float)scale * (float)dataDesc.refVal)));
            }
        }
        this.annotate((Variable.Builder)v, fld);
        ((Variable.Builder)v).addAttribute(new Attribute("BUFR:TableB_descriptor", dataDesc.getFxyName()));
        ((Variable.Builder)v).addAttribute(new Attribute("BUFR:bitWidth", dataDesc.bitWidth));
        struct.addMemberVariable((Variable.Builder<?>)v);
        ((Variable.Builder)v).setSPobject(fld);
        return v;
    }

    private String findUniqueName(Structure.Builder<?> struct, String want, String def) {
        if (want == null) {
            return def + this.tempNo++;
        }
        String vwant = NetcdfFiles.makeValidCdmObjectName(want);
        Optional<Variable.Builder<?>> oldV = struct.findMemberVariable(vwant);
        if (!oldV.isPresent()) {
            return vwant;
        }
        int seq = 2;
        String wantSeq;
        while ((oldV = struct.findMemberVariable(wantSeq = vwant + "-" + seq)).isPresent()) {
            ++seq;
        }
        return wantSeq;
    }

    private String findGloballyUniqueName(String want, String def) {
        if (want == null) {
            return def + this.tempNo++;
        }
        String vwant = NetcdfFiles.makeValidCdmObjectName(want);
        Integer have = this.names.get(vwant);
        if (have == null) {
            this.names.put(vwant, 1);
            return vwant;
        }
        have = have + 1;
        String wantSeq = vwant + "-" + have;
        this.names.put(vwant, have);
        return wantSeq;
    }

    private void annotate(Variable.Builder v, BufrConfig.FieldConverter fld) {
        if (fld.type == null) {
            return;
        }
        switch (fld.type) {
            case lat: {
                v.addAttribute(new Attribute("units", "degrees_north"));
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
                this.coordinates.format("%s ", v.shortName);
                break;
            }
            case lon: {
                v.addAttribute(new Attribute("units", "degrees_east"));
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
                this.coordinates.format("%s ", v.shortName);
                break;
            }
            case height: 
            case heightOfStation: 
            case heightAboveStation: {
                v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
                this.coordinates.format("%s ", v.shortName);
                break;
            }
            case stationId: {
                v.addAttribute(new Attribute("standard_name", "station_id"));
                break;
            }
            case wmoId: {
                v.addAttribute(new Attribute("standard_name", "station_WMO_id"));
            }
        }
    }
}

