/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.entropy;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import ucar.jpeg.jj2000.j2k.ModuleSpec;
import ucar.jpeg.jj2000.j2k.util.MathUtil;
import ucar.jpeg.jj2000.j2k.util.ParameterList;

public class CBlkSizeSpec
extends ModuleSpec {
    private static final String optName = "Cblksiz";
    private int maxCBlkWidth = 0;
    private int maxCBlkHeight = 0;

    public CBlkSizeSpec(int nt, int nc, byte type) {
        super(nt, nc, type);
    }

    public CBlkSizeSpec(int nt, int nc, byte type, ParameterList pl) {
        super(nt, nc, type);
        boolean firstVal = true;
        String param = pl.getParameter(optName);
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecType = 0;
        boolean[] tileSpec = null;
        boolean[] compSpec = null;
        String word = null;
        String errMsg = null;
        block15: while (stk.hasMoreTokens()) {
            int ci;
            int ti;
            word = stk.nextToken();
            switch (word.charAt(0)) {
                case 't': {
                    tileSpec = CBlkSizeSpec.parseIdx(word, this.nTiles);
                    if (curSpecType == 1) {
                        curSpecType = 3;
                        continue block15;
                    }
                    curSpecType = 2;
                    continue block15;
                }
                case 'c': {
                    compSpec = CBlkSizeSpec.parseIdx(word, this.nComp);
                    if (curSpecType == 2) {
                        curSpecType = 3;
                        continue block15;
                    }
                    curSpecType = 1;
                    continue block15;
                }
            }
            if (!Character.isDigit(word.charAt(0))) {
                errMsg = "Bad construction for parameter: " + word;
                throw new IllegalArgumentException(errMsg);
            }
            Integer[] dim = new Integer[2];
            try {
                dim[0] = new Integer(word);
                if (dim[0] > 1024) {
                    errMsg = "'Cblksiz' option : the code-block's width cannot be greater than 1024";
                    throw new IllegalArgumentException(errMsg);
                }
                if (dim[0] < 4) {
                    errMsg = "'Cblksiz' option : the code-block's width cannot be less than 4";
                    throw new IllegalArgumentException(errMsg);
                }
                if (dim[0] != 1 << MathUtil.log2(dim[0])) {
                    errMsg = "'Cblksiz' option : the code-block's width must be a power of 2";
                    throw new IllegalArgumentException(errMsg);
                }
            }
            catch (NumberFormatException e) {
                errMsg = "'Cblksiz' option : the code-block's width could not be parsed.";
                throw new IllegalArgumentException(errMsg);
            }
            try {
                word = stk.nextToken();
            }
            catch (NoSuchElementException e) {
                errMsg = "'Cblksiz' option : could not parse the code-block's height";
                throw new IllegalArgumentException(errMsg);
            }
            try {
                dim[1] = new Integer(word);
                if (dim[1] > 1024) {
                    errMsg = "'Cblksiz' option : the code-block's height cannot be greater than 1024";
                    throw new IllegalArgumentException(errMsg);
                }
                if (dim[1] < 4) {
                    errMsg = "'Cblksiz' option : the code-block's height cannot be less than 4";
                    throw new IllegalArgumentException(errMsg);
                }
                if (dim[1] != 1 << MathUtil.log2(dim[1])) {
                    errMsg = "'Cblksiz' option : the code-block's height must be a power of 2";
                    throw new IllegalArgumentException(errMsg);
                }
                if (dim[0] * dim[1] > 4096) {
                    errMsg = "'Cblksiz' option : The code-block's area (i.e. width*height) cannot be greater than 4096";
                    throw new IllegalArgumentException(errMsg);
                }
            }
            catch (NumberFormatException e) {
                errMsg = "'Cblksiz' option : the code-block's height could not be parsed.";
                throw new IllegalArgumentException(errMsg);
            }
            if (dim[0] > this.maxCBlkWidth) {
                this.maxCBlkWidth = dim[0];
            }
            if (dim[1] > this.maxCBlkHeight) {
                this.maxCBlkHeight = dim[1];
            }
            if (firstVal) {
                this.setDefault(dim);
                firstVal = false;
            }
            switch (curSpecType) {
                case 0: {
                    this.setDefault(dim);
                    continue block15;
                }
                case 2: {
                    for (ti = tileSpec.length - 1; ti >= 0; --ti) {
                        if (!tileSpec[ti]) continue;
                        this.setTileDef(ti, dim);
                    }
                    continue block15;
                }
                case 1: {
                    for (ci = compSpec.length - 1; ci >= 0; --ci) {
                        if (!compSpec[ci]) continue;
                        this.setCompDef(ci, dim);
                    }
                    continue block15;
                }
            }
            for (ti = tileSpec.length - 1; ti >= 0; --ti) {
                for (ci = compSpec.length - 1; ci >= 0; --ci) {
                    if (!tileSpec[ti] || !compSpec[ci]) continue;
                    this.setTileCompVal(ti, ci, dim);
                }
            }
        }
    }

    public int getMaxCBlkWidth() {
        return this.maxCBlkWidth;
    }

    public int getMaxCBlkHeight() {
        return this.maxCBlkHeight;
    }

    public int getCBlkWidth(byte type, int t, int c) {
        Integer[] dim = null;
        switch (type) {
            case 0: {
                dim = (Integer[])this.getDefault();
                break;
            }
            case 1: {
                dim = (Integer[])this.getCompDef(c);
                break;
            }
            case 2: {
                dim = (Integer[])this.getTileDef(t);
                break;
            }
            case 3: {
                dim = (Integer[])this.getTileCompVal(t, c);
            }
        }
        return dim[0].intValue();
    }

    public int getCBlkHeight(byte type, int t, int c) {
        Integer[] dim = null;
        switch (type) {
            case 0: {
                dim = (Integer[])this.getDefault();
                break;
            }
            case 1: {
                dim = (Integer[])this.getCompDef(c);
                break;
            }
            case 2: {
                dim = (Integer[])this.getTileDef(t);
                break;
            }
            case 3: {
                dim = (Integer[])this.getTileCompVal(t, c);
            }
        }
        return dim[1].intValue();
    }

    @Override
    public void setDefault(Object value) {
        super.setDefault(value);
        this.storeHighestDims((Integer[])value);
    }

    @Override
    public void setTileDef(int t, Object value) {
        super.setTileDef(t, value);
        this.storeHighestDims((Integer[])value);
    }

    @Override
    public void setCompDef(int c, Object value) {
        super.setCompDef(c, value);
        this.storeHighestDims((Integer[])value);
    }

    @Override
    public void setTileCompVal(int t, int c, Object value) {
        super.setTileCompVal(t, c, value);
        this.storeHighestDims((Integer[])value);
    }

    private void storeHighestDims(Integer[] dim) {
        if (dim[0] > this.maxCBlkWidth) {
            this.maxCBlkWidth = dim[0];
        }
        if (dim[1] > this.maxCBlkHeight) {
            this.maxCBlkHeight = dim[1];
        }
    }
}

