/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util;

import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.concurrent.Semaphore;
import org.encog.EncogError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageSize
implements ImageObserver {
    private int width;
    private int height;
    private final Semaphore wait;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ImageSize(Image image) {
        this.wait = new Semaphore(0);
        this.width = image.getWidth(this);
        this.height = image.getHeight(this);
        if (this.width == -1 || this.height == -1) {
            try {
                this.wait.acquire();
            }
            catch (InterruptedException interruptedException) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Exception", (Throwable)interruptedException);
                }
                throw new EncogError(interruptedException);
            }
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 3) != 3) {
            return true;
        }
        this.height = n5;
        this.width = n4;
        return false;
    }
}

