/*
 * Decompiled with CFR 0.152.
 */
package org.encog.solve.genetic;

import org.encog.engine.concurrency.EngineConcurrency;
import org.encog.engine.concurrency.TaskGroup;
import org.encog.neural.networks.ContextClearable;
import org.encog.solve.genetic.MateWorker;
import org.encog.solve.genetic.crossover.Crossover;
import org.encog.solve.genetic.genome.CalculateGenomeScore;
import org.encog.solve.genetic.genome.Genome;
import org.encog.solve.genetic.genome.GenomeComparator;
import org.encog.solve.genetic.mutate.Mutate;
import org.encog.solve.genetic.population.Population;
import org.encog.solve.genetic.species.Species;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneticAlgorithm {
    private CalculateGenomeScore calculateScore;
    private GenomeComparator comparator;
    private Crossover crossover;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private double matingPopulation;
    private Mutate mutate;
    private double mutationPercent;
    private double percentToMate;
    private Population population;

    public void calculateScore(Genome genome) {
        if (genome.getOrganism() instanceof ContextClearable) {
            ((ContextClearable)genome.getOrganism()).clearContext();
        }
        double d = this.calculateScore.calculateScore(genome);
        genome.setScore(d);
    }

    public CalculateGenomeScore getCalculateScore() {
        return this.calculateScore;
    }

    public GenomeComparator getComparator() {
        return this.comparator;
    }

    public Crossover getCrossover() {
        return this.crossover;
    }

    public double getMatingPopulation() {
        return this.matingPopulation;
    }

    public Mutate getMutate() {
        return this.mutate;
    }

    public double getMutationPercent() {
        return this.mutationPercent;
    }

    public double getPercentToMate() {
        return this.percentToMate;
    }

    public Population getPopulation() {
        return this.population;
    }

    public void iteration() {
        int n = (int)((double)this.population.getPopulationSize() * this.getPercentToMate());
        int n2 = n * 2;
        int n3 = this.population.getPopulationSize() - n2;
        int n4 = (int)((double)this.population.getPopulationSize() * this.getMatingPopulation());
        TaskGroup taskGroup = EngineConcurrency.getInstance().createTaskGroup();
        for (int i = 0; i < n; ++i) {
            Genome genome = this.population.getGenomes().get(i);
            int n5 = (int)(Math.random() * (double)n4);
            Genome genome2 = this.population.getGenomes().get(n5);
            Genome genome3 = this.population.getGenomes().get(n3);
            Genome genome4 = this.population.getGenomes().get(n3 + 1);
            MateWorker mateWorker = new MateWorker(genome, genome2, genome3, genome4);
            EngineConcurrency.getInstance().processTask(mateWorker, taskGroup);
            n3 += 2;
        }
        taskGroup.waitForComplete();
        this.population.sort();
    }

    public void setCalculateScore(CalculateGenomeScore calculateGenomeScore) {
        this.calculateScore = calculateGenomeScore;
    }

    public void setComparator(GenomeComparator genomeComparator) {
        this.comparator = genomeComparator;
    }

    public void setCrossover(Crossover crossover) {
        this.crossover = crossover;
    }

    public void setMatingPopulation(double d) {
        this.matingPopulation = d;
    }

    public void setMutate(Mutate mutate) {
        this.mutate = mutate;
    }

    public void setMutationPercent(double d) {
        this.mutationPercent = d;
    }

    public void setPercentToMate(double d) {
        this.percentToMate = d;
    }

    public void setPopulation(Population population) {
        this.population = population;
    }

    public void addSpeciesMember(Species species, Genome genome) {
        if (this.getComparator().isBetterThan(genome.getScore(), species.getBestScore())) {
            species.setBestScore(genome.getScore());
            species.setGensNoImprovement(0);
            species.setLeader(genome);
        }
        species.getMembers().add(genome);
    }
}

