/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist.persistors;

import java.util.HashMap;
import java.util.Map;
import org.encog.EncogError;
import org.encog.engine.network.flat.FlatNetwork;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.ART1Logic;
import org.encog.neural.networks.logic.BAMLogic;
import org.encog.neural.networks.logic.BoltzmannLogic;
import org.encog.neural.networks.logic.FeedforwardLogic;
import org.encog.neural.networks.logic.HopfieldLogic;
import org.encog.neural.networks.logic.NeuralLogic;
import org.encog.neural.networks.logic.SimpleRecurrentLogic;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.parse.tags.read.ReadXML;
import org.encog.parse.tags.write.WriteXML;
import org.encog.persist.EncogPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PersistorUtil;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;

public class BasicNetworkPersistor
implements Persistor {
    public static final String TAG_LAYERS = "layers";
    public static final String TAG_SYNAPSES = "synapses";
    public static final String TAG_SYNAPSE = "synapse";
    public static final String TAG_PROPERTIES = "properties";
    public static final String TAG_OUTPUT = "layerOutput";
    public static final String TAG_TAGS = "tags";
    public static final String TAG_TAG = "tag";
    public static final String TAG_LOGIC = "logic";
    public static final String TAG_LAYER = "layer";
    public static final String TAG_PROPERTY = "Property";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_TYPE_INPUT = "input";
    public static final String ATTRIBUTE_TYPE_OUTPUT = "output";
    public static final String ATTRIBUTE_TYPE_HIDDEN = "hidden";
    public static final String ATTRIBUTE_TYPE_BOTH = "both";
    public static final String ATTRIBUTE_TYPE_UNKNOWN = "unknown";
    public static final String ATTRIBUTE_FROM = "from";
    public static final String ATTRIBUTE_TO = "to";
    public static final String ATTRIBUTE_LAYER = "layer";
    private BasicNetwork currentNetwork;
    private final Map<Layer, Integer> layer2index = new HashMap<Layer, Integer>();
    private final Map<Integer, Layer> index2layer = new HashMap<Integer, Layer>();

    private void handleLayers(ReadXML readXML) {
        String string = readXML.getTag().getName();
        while (readXML.readToTag()) {
            if (readXML.is("layer", true)) {
                int n = readXML.getTag().getAttributeInt(ATTRIBUTE_ID);
                String string2 = readXML.getTag().getAttributeValue(ATTRIBUTE_TYPE);
                readXML.readToTag();
                Persistor persistor = PersistorUtil.createPersistor(readXML.getTag().getName());
                Layer layer = (Layer)persistor.load(readXML);
                this.index2layer.put(n, layer);
                layer.setID(n);
                if (string2 != null) {
                    if (string2.equals(ATTRIBUTE_TYPE_INPUT)) {
                        this.currentNetwork.tagLayer("INPUT", layer);
                    } else if (string2.equals(ATTRIBUTE_TYPE_OUTPUT)) {
                        this.currentNetwork.tagLayer("OUTPUT", layer);
                    } else if (string2.equals(ATTRIBUTE_TYPE_BOTH)) {
                        this.currentNetwork.tagLayer("INPUT", layer);
                        this.currentNetwork.tagLayer("OUTPUT", layer);
                    }
                }
            }
            if (!readXML.is(string, false)) continue;
            break;
        }
    }

    private void handleLogic(ReadXML readXML) {
        String string = readXML.readTextToTag();
        if (string.equalsIgnoreCase("ART1Logic")) {
            this.currentNetwork.setLogic(new ART1Logic());
        } else if (string.equalsIgnoreCase("BAMLogic")) {
            this.currentNetwork.setLogic(new BAMLogic());
        } else if (string.equalsIgnoreCase("BoltzmannLogic")) {
            this.currentNetwork.setLogic(new BoltzmannLogic());
        } else if (string.equalsIgnoreCase("FeedforwardLogic")) {
            this.currentNetwork.setLogic(new FeedforwardLogic());
        } else if (string.equalsIgnoreCase("HopfieldLogic")) {
            this.currentNetwork.setLogic(new HopfieldLogic());
        } else if (string.equalsIgnoreCase("SimpleRecurrentLogic")) {
            this.currentNetwork.setLogic(new SimpleRecurrentLogic());
        } else {
            try {
                NeuralLogic neuralLogic = (NeuralLogic)Class.forName(string).newInstance();
                this.currentNetwork.setLogic(neuralLogic);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new EncogError(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new EncogError(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new EncogError(illegalAccessException);
            }
        }
    }

    private void handleProperties(ReadXML readXML) {
        String string = readXML.getTag().getName();
        while (readXML.readToTag()) {
            if (readXML.is(TAG_PROPERTY, true)) {
                String string2 = readXML.getTag().getAttributeValue(ATTRIBUTE_NAME);
                String string3 = readXML.readTextToTag();
                this.currentNetwork.setProperty(string2, string3);
            }
            if (!readXML.is(string, false)) continue;
            break;
        }
    }

    private void handleSynapses(ReadXML readXML) {
        String string = readXML.getTag().getName();
        while (readXML.readToTag()) {
            if (readXML.is(TAG_SYNAPSE, true)) {
                int n = readXML.getTag().getAttributeInt(ATTRIBUTE_FROM);
                int n2 = readXML.getTag().getAttributeInt(ATTRIBUTE_TO);
                readXML.readToTag();
                Persistor persistor = PersistorUtil.createPersistor(readXML.getTag().getName());
                Synapse synapse = (Synapse)persistor.load(readXML);
                synapse.setFromLayer(this.index2layer.get(n));
                synapse.setToLayer(this.index2layer.get(n2));
                synapse.getFromLayer().addSynapse(synapse);
            }
            if (!readXML.is(string, false)) continue;
            break;
        }
    }

    private void handleTags(ReadXML readXML) {
        String string = readXML.getTag().getName();
        while (readXML.readToTag()) {
            if (readXML.is(TAG_TAG, true)) {
                String string2 = readXML.getTag().getAttributeValue(ATTRIBUTE_NAME);
                String string3 = readXML.getTag().getAttributeValue("layer");
                int n = Integer.parseInt(string3);
                Layer layer = this.index2layer.get(n);
                this.currentNetwork.tagLayer(string2, layer);
                readXML.readToTag();
            }
            if (!readXML.is(string, false)) continue;
            break;
        }
    }

    public EncogPersistedObject load(ReadXML readXML) {
        double[] dArray = null;
        String string = readXML.getTag().getAttributes().get(ATTRIBUTE_NAME);
        String string2 = readXML.getTag().getAttributes().get("description");
        this.currentNetwork = new BasicNetwork();
        this.currentNetwork.setName(string);
        this.currentNetwork.setDescription(string2);
        while (readXML.readToTag()) {
            if (readXML.is(TAG_LAYERS, true)) {
                this.handleLayers(readXML);
                continue;
            }
            if (readXML.is(TAG_SYNAPSES, true)) {
                this.handleSynapses(readXML);
                continue;
            }
            if (readXML.is(TAG_PROPERTIES, true)) {
                this.handleProperties(readXML);
                continue;
            }
            if (readXML.is(TAG_LOGIC, true)) {
                this.handleLogic(readXML);
                continue;
            }
            if (readXML.is(TAG_TAGS, true)) {
                this.handleTags(readXML);
                continue;
            }
            if (readXML.is(TAG_OUTPUT, true)) {
                dArray = this.handleOutput(readXML);
                continue;
            }
            if (!readXML.is("BasicNetwork", false)) continue;
        }
        this.currentNetwork.getStructure().finalizeStructure();
        return this.currentNetwork;
    }

    public void save(EncogPersistedObject encogPersistedObject, WriteXML writeXML) {
        PersistorUtil.beginEncogObject("BasicNetwork", writeXML, encogPersistedObject, true);
        this.currentNetwork = (BasicNetwork)encogPersistedObject;
        this.currentNetwork.getStructure().finalizeStructure();
        writeXML.beginTag(TAG_LAYERS);
        this.saveLayers(writeXML);
        writeXML.endTag();
        writeXML.beginTag(TAG_SYNAPSES);
        this.saveSynapses(writeXML);
        writeXML.endTag();
        this.saveProperties(writeXML);
        this.saveTags(writeXML);
        this.saveLogic(writeXML);
        this.saveOutput(writeXML);
        writeXML.endTag();
    }

    private void saveLayers(WriteXML writeXML) {
        for (Layer layer : this.currentNetwork.getStructure().getLayers()) {
            writeXML.addAttribute(ATTRIBUTE_ID, "" + layer.getID());
            writeXML.beginTag("layer");
            Persistor persistor = layer.createPersistor();
            persistor.save(layer, writeXML);
            writeXML.endTag();
            this.layer2index.put(layer, layer.getID());
        }
    }

    private void saveLogic(WriteXML writeXML) {
        writeXML.beginTag(TAG_LOGIC);
        NeuralLogic neuralLogic = this.currentNetwork.getLogic();
        if (neuralLogic instanceof FeedforwardLogic || neuralLogic instanceof SimpleRecurrentLogic || neuralLogic instanceof BoltzmannLogic || neuralLogic instanceof ART1Logic || neuralLogic instanceof BAMLogic || neuralLogic instanceof HopfieldLogic) {
            writeXML.addText(neuralLogic.getClass().getSimpleName());
        } else {
            writeXML.addText(neuralLogic.getClass().getName());
        }
        writeXML.endTag();
    }

    private void saveProperties(WriteXML writeXML) {
        writeXML.beginTag(TAG_PROPERTIES);
        for (String string : this.currentNetwork.getProperties().keySet()) {
            String string2 = this.currentNetwork.getProperties().get(string);
            writeXML.addAttribute(ATTRIBUTE_NAME, string);
            writeXML.beginTag(TAG_PROPERTY);
            writeXML.addText(string2.toString());
            writeXML.endTag();
        }
        writeXML.endTag();
    }

    private void saveSynapses(WriteXML writeXML) {
        for (Synapse synapse : this.currentNetwork.getStructure().getSynapses()) {
            writeXML.addAttribute(ATTRIBUTE_FROM, "" + this.layer2index.get(synapse.getFromLayer()));
            writeXML.addAttribute(ATTRIBUTE_TO, "" + this.layer2index.get(synapse.getToLayer()));
            writeXML.beginTag(TAG_SYNAPSE);
            Persistor persistor = synapse.createPersistor();
            persistor.save(synapse, writeXML);
            writeXML.endTag();
        }
    }

    private void saveTags(WriteXML writeXML) {
        writeXML.beginTag(TAG_TAGS);
        for (String string : this.currentNetwork.getLayerTags().keySet()) {
            Layer layer = this.currentNetwork.getLayerTags().get(string);
            writeXML.addAttribute(ATTRIBUTE_NAME, string);
            writeXML.addAttribute("layer", "" + this.layer2index.get(layer));
            writeXML.beginTag(TAG_TAG);
            writeXML.endTag();
        }
        writeXML.endTag();
    }

    private void saveOutput(WriteXML writeXML) {
        FlatNetwork flatNetwork = this.currentNetwork.getStructure().getFlat();
        if (flatNetwork != null) {
            writeXML.beginTag(TAG_OUTPUT);
            StringBuilder stringBuilder = new StringBuilder();
            NumberList.toList(CSVFormat.EG_FORMAT, stringBuilder, flatNetwork.getLayerOutput());
            writeXML.addProperty("threshold", stringBuilder.toString());
            writeXML.endTag();
        }
    }

    private double[] handleOutput(ReadXML readXML) {
        String string = readXML.readTextToTag();
        return NumberList.fromList(CSVFormat.EG_FORMAT, string);
    }
}

