/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationBiPolar;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.logic.HopfieldLogic;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HopfieldPattern
implements NeuralNetworkPattern {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int neuronCount = -1;

    public void addHiddenLayer(int n) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A Hopfield network has no hidden layers.");
        }
        throw new PatternError("A Hopfield network has no hidden layers.");
    }

    public void clear() {
    }

    public BasicNetwork generate() {
        BasicLayer basicLayer = new BasicLayer(new ActivationBiPolar(), false, this.neuronCount);
        BasicNetwork basicNetwork = new BasicNetwork(new HopfieldLogic());
        basicNetwork.addLayer(basicLayer);
        basicLayer.addNext(basicLayer);
        basicLayer.setX(50);
        basicLayer.setY(50);
        basicNetwork.getStructure().finalizeStructure();
        basicNetwork.reset();
        return basicNetwork;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A Hopfield network will use the BiPolar activation function, no activation function needs to be specified.");
        }
        throw new PatternError("A Hopfield network will use the BiPolar activation function, no activation function needs to be specified.");
    }

    public void setInputNeurons(int n) {
        this.neuronCount = n;
    }

    public void setOutputNeurons(int n) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A Hopfield network has a single layer, so no need to specify the output count.");
        }
        throw new PatternError("A Hopfield network has a single layer, so no need to specify the output count.");
    }
}

