/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.neat;

import java.util.Collections;
import java.util.List;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.synapse.neat.NEATLink;
import org.encog.neural.networks.synapse.neat.NEATNeuron;
import org.encog.neural.networks.synapse.neat.NEATNeuronType;
import org.encog.neural.networks.training.neat.NEATInnovation;
import org.encog.neural.networks.training.neat.NEATInnovationType;
import org.encog.neural.networks.training.neat.NEATLinkGene;
import org.encog.neural.networks.training.neat.NEATNeuronGene;
import org.encog.neural.networks.training.neat.NEATTraining;
import org.encog.neural.pattern.NEATPattern;
import org.encog.persist.annotations.EGAttribute;
import org.encog.persist.annotations.EGReference;
import org.encog.solve.genetic.genes.BasicGene;
import org.encog.solve.genetic.genes.Gene;
import org.encog.solve.genetic.genome.BasicGenome;
import org.encog.solve.genetic.genome.Chromosome;
import org.encog.solve.genetic.innovation.BasicInnovation;

public class NEATGenome
extends BasicGenome
implements Cloneable {
    public static final double TWEAK_DISJOINT = 1.0;
    public static final double TWEAK_EXCESS = 1.0;
    public static final double TWEAK_MATCHED = 0.4;
    @EGAttribute
    private int inputCount;
    @EGReference
    private Chromosome linksChromosome;
    @EGAttribute
    private int networkDepth;
    @EGReference
    private Chromosome neuronsChromosome;
    @EGAttribute
    private int outputCount;
    @EGAttribute
    private long speciesID;

    public NEATGenome() {
        super(null);
    }

    public NEATGenome(NEATGenome nEATGenome) {
        super(nEATGenome.getGeneticAlgorithm());
        BasicGene basicGene;
        BasicGene basicGene2;
        this.neuronsChromosome = new Chromosome();
        this.linksChromosome = new Chromosome();
        this.getChromosomes().add(this.neuronsChromosome);
        this.getChromosomes().add(this.linksChromosome);
        this.setGenomeID(nEATGenome.getGenomeID());
        this.networkDepth = nEATGenome.networkDepth;
        this.setScore(nEATGenome.getScore());
        this.setAdjustedScore(nEATGenome.getAdjustedScore());
        this.setAmountToSpawn(nEATGenome.getAmountToSpawn());
        this.inputCount = nEATGenome.inputCount;
        this.outputCount = nEATGenome.outputCount;
        this.speciesID = nEATGenome.speciesID;
        for (Gene gene : nEATGenome.getNeurons().getGenes()) {
            basicGene2 = (NEATNeuronGene)gene;
            basicGene = new NEATNeuronGene(((NEATNeuronGene)basicGene2).getNeuronType(), basicGene2.getId(), ((NEATNeuronGene)basicGene2).getSplitY(), ((NEATNeuronGene)basicGene2).getSplitX(), ((NEATNeuronGene)basicGene2).isRecurrent(), ((NEATNeuronGene)basicGene2).getActivationResponse());
            this.getNeurons().add(basicGene);
        }
        for (Gene gene : nEATGenome.getLinks().getGenes()) {
            basicGene2 = (NEATLinkGene)gene;
            basicGene = new NEATLinkGene(((NEATLinkGene)basicGene2).getFromNeuronID(), ((NEATLinkGene)basicGene2).getToNeuronID(), basicGene2.isEnabled(), basicGene2.getInnovationId(), ((NEATLinkGene)basicGene2).getWeight(), ((NEATLinkGene)basicGene2).isRecurrent());
            this.getLinks().add(basicGene);
        }
    }

    public NEATGenome(NEATTraining nEATTraining, long l, Chromosome chromosome, Chromosome chromosome2, int n, int n2) {
        super(nEATTraining);
        this.setGenomeID(l);
        this.linksChromosome = chromosome2;
        this.neuronsChromosome = chromosome;
        this.setAmountToSpawn(0.0);
        this.setAdjustedScore(0.0);
        this.inputCount = n;
        this.outputCount = n2;
        this.getChromosomes().add(this.neuronsChromosome);
        this.getChromosomes().add(this.linksChromosome);
    }

    public NEATGenome(NEATTraining nEATTraining, long l, int n, int n2) {
        super(nEATTraining);
        int n3;
        this.setGenomeID(l);
        this.setAdjustedScore(0.0);
        this.inputCount = n;
        this.outputCount = n2;
        this.setAmountToSpawn(0.0);
        this.speciesID = 0L;
        double d = 0.8 / (double)n;
        this.neuronsChromosome = new Chromosome();
        this.linksChromosome = new Chromosome();
        this.getChromosomes().add(this.neuronsChromosome);
        this.getChromosomes().add(this.linksChromosome);
        for (int i = 0; i < n; ++i) {
            this.neuronsChromosome.add(new NEATNeuronGene(NEATNeuronType.Input, i, 0.0, 0.1 + (double)i * d));
        }
        this.neuronsChromosome.add(new NEATNeuronGene(NEATNeuronType.Bias, n, 0.0, 0.9));
        double d2 = 1.0 / (double)(n2 + 1);
        for (n3 = 0; n3 < n2; ++n3) {
            this.neuronsChromosome.add(new NEATNeuronGene(NEATNeuronType.Output, n3 + n + 1, 1.0, (double)(n3 + 1) * d2));
        }
        for (n3 = 0; n3 < n + 1; ++n3) {
            for (int i = 0; i < n2; ++i) {
                this.linksChromosome.add(new NEATLinkGene(((NEATNeuronGene)this.neuronsChromosome.get(n3)).getId(), ((NEATNeuronGene)this.getNeurons().get(n + i + 1)).getId(), true, n + n2 + 1 + this.getNumGenes(), RangeRandomizer.randomize(-1.0, 1.0), false));
            }
        }
    }

    void addLink(double d, double d2, int n, int n2) {
        NEATNeuronGene nEATNeuronGene;
        Object object;
        if (Math.random() > d) {
            return;
        }
        int n3 = n;
        int n4 = n;
        long l = -1L;
        long l2 = -1L;
        boolean bl = false;
        if (Math.random() < d2) {
            while (n3-- > 0) {
                object = this.chooseRandomNeuron(false);
                if (((NEATNeuronGene)object).isRecurrent() || ((NEATNeuronGene)object).getNeuronType() == NEATNeuronType.Bias || ((NEATNeuronGene)object).getNeuronType() == NEATNeuronType.Input) continue;
                l = ((BasicGene)object).getId();
                l2 = ((BasicGene)object).getId();
                ((NEATNeuronGene)object).setRecurrent(true);
                bl = true;
                n3 = 0;
            }
        } else {
            while (n4-- > 0) {
                object = this.chooseRandomNeuron(true);
                nEATNeuronGene = this.chooseRandomNeuron(false);
                if (this.isDuplicateLink(l, l2) || ((BasicGene)object).getId() == nEATNeuronGene.getId() || nEATNeuronGene.getNeuronType() == NEATNeuronType.Bias) continue;
                l = ((BasicGene)object).getId();
                l2 = nEATNeuronGene.getId();
                break;
            }
        }
        if (l < 0L || l2 < 0L) {
            return;
        }
        object = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().checkInnovation(l, l, NEATInnovationType.NewLink);
        nEATNeuronGene = (NEATNeuronGene)this.neuronsChromosome.get(this.getElementPos(l));
        if (nEATNeuronGene.getSplitY() > nEATNeuronGene.getSplitY()) {
            bl = true;
        }
        if (object == null) {
            ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().createNewInnovation(l, l2, NEATInnovationType.NewLink);
            long l3 = ((NEATTraining)this.getGeneticAlgorithm()).getPopulation().assignInnovationID();
            NEATLinkGene nEATLinkGene = new NEATLinkGene(l, l2, true, l3, RangeRandomizer.randomize(-1.0, 1.0), bl);
            this.linksChromosome.add(nEATLinkGene);
        } else {
            NEATLinkGene nEATLinkGene = new NEATLinkGene(l, l2, true, ((BasicInnovation)object).getInnovationID(), RangeRandomizer.randomize(-1.0, 1.0), bl);
            this.linksChromosome.add(nEATLinkGene);
        }
    }

    void addNeuron(double d, int n) {
        long l;
        long l2;
        if (Math.random() > d) {
            return;
        }
        int n2 = n;
        BasicGene basicGene = null;
        int n3 = this.inputCount + this.outputCount + 10;
        int n4 = this.linksChromosome.size() < n3 ? this.getNumGenes() - 1 - (int)Math.sqrt(this.getNumGenes()) : this.getNumGenes() - 1;
        while (n2-- > 0) {
            int n5 = RangeRandomizer.randomInt(0, n4);
            NEATLinkGene nEATLinkGene = (NEATLinkGene)this.linksChromosome.get(n5);
            l2 = nEATLinkGene.getFromNeuronID();
            if (!nEATLinkGene.isEnabled() || nEATLinkGene.isRecurrent() || ((NEATNeuronGene)this.getNeurons().get(this.getElementPos(l2))).getNeuronType() == NEATNeuronType.Bias) continue;
            basicGene = nEATLinkGene;
            break;
        }
        if (basicGene == null) {
            return;
        }
        basicGene.setEnabled(false);
        double d2 = ((NEATLinkGene)basicGene).getWeight();
        l2 = ((NEATLinkGene)basicGene).getFromNeuronID();
        long l3 = ((NEATLinkGene)basicGene).getToNeuronID();
        NEATNeuronGene nEATNeuronGene = (NEATNeuronGene)this.getNeurons().get(this.getElementPos(l2));
        NEATNeuronGene nEATNeuronGene2 = (NEATNeuronGene)this.getNeurons().get(this.getElementPos(l3));
        double d3 = (nEATNeuronGene.getSplitY() + nEATNeuronGene2.getSplitY()) / 2.0;
        double d4 = (nEATNeuronGene.getSplitX() + nEATNeuronGene2.getSplitX()) / 2.0;
        NEATInnovation nEATInnovation = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().checkInnovation(l2, l3, NEATInnovationType.NewNeuron);
        if (nEATInnovation != null && this.alreadyHaveThisNeuronID(l = nEATInnovation.getNeuronID())) {
            nEATInnovation = null;
        }
        if (nEATInnovation == null) {
            l = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().createNewInnovation(l2, l3, NEATInnovationType.NewNeuron, NEATNeuronType.Hidden, d4, d3);
            this.neuronsChromosome.add(new NEATNeuronGene(NEATNeuronType.Hidden, l, d3, d4));
            long l4 = ((NEATTraining)this.getGeneticAlgorithm()).getPopulation().assignInnovationID();
            ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().createNewInnovation(l2, l, NEATInnovationType.NewLink);
            NEATLinkGene nEATLinkGene = new NEATLinkGene(l2, l, true, l4, 1.0, false);
            this.linksChromosome.add(nEATLinkGene);
            long l5 = ((NEATTraining)this.getGeneticAlgorithm()).getPopulation().assignInnovationID();
            ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().createNewInnovation(l, l3, NEATInnovationType.NewLink);
            NEATLinkGene nEATLinkGene2 = new NEATLinkGene(l, l3, true, l5, d2, false);
            this.linksChromosome.add(nEATLinkGene2);
        } else {
            l = nEATInnovation.getNeuronID();
            NEATInnovation nEATInnovation2 = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().checkInnovation(l2, l, NEATInnovationType.NewLink);
            NEATInnovation nEATInnovation3 = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().checkInnovation(l, l3, NEATInnovationType.NewLink);
            if (nEATInnovation2 == null || nEATInnovation3 == null) {
                throw new NeuralNetworkError("NEAT Error");
            }
            NEATLinkGene nEATLinkGene = new NEATLinkGene(l2, l, true, nEATInnovation2.getInnovationID(), 1.0, false);
            NEATLinkGene nEATLinkGene3 = new NEATLinkGene(l, l3, true, nEATInnovation3.getInnovationID(), d2, false);
            this.linksChromosome.add(nEATLinkGene);
            this.linksChromosome.add(nEATLinkGene3);
            NEATNeuronGene nEATNeuronGene3 = new NEATNeuronGene(NEATNeuronType.Hidden, l, d3, d4);
            this.neuronsChromosome.add(nEATNeuronGene3);
        }
    }

    public boolean alreadyHaveThisNeuronID(long l) {
        for (Gene gene : this.neuronsChromosome.getGenes()) {
            NEATNeuronGene nEATNeuronGene = (NEATNeuronGene)gene;
            if (nEATNeuronGene.getId() != l) continue;
            return true;
        }
        return false;
    }

    private NEATNeuronGene chooseRandomNeuron(boolean bl) {
        int n = bl ? 0 : this.inputCount + 1;
        int n2 = RangeRandomizer.randomInt(n, this.getNeurons().size() - 1);
        NEATNeuronGene nEATNeuronGene = (NEATNeuronGene)this.neuronsChromosome.get(n2);
        return nEATNeuronGene;
    }

    public void decode() {
        BasicGene basicGene;
        NEATPattern nEATPattern = new NEATPattern();
        List<NEATNeuron> list = nEATPattern.getNeurons();
        for (Gene gene : this.getNeurons().getGenes()) {
            basicGene = (NEATNeuronGene)gene;
            NEATNeuron nEATNeuron = new NEATNeuron(((NEATNeuronGene)basicGene).getNeuronType(), basicGene.getId(), ((NEATNeuronGene)basicGene).getSplitY(), ((NEATNeuronGene)basicGene).getSplitX(), ((NEATNeuronGene)basicGene).getActivationResponse());
            list.add(nEATNeuron);
        }
        for (Gene gene : this.getLinks().getGenes()) {
            basicGene = (NEATLinkGene)gene;
            if (!basicGene.isEnabled()) continue;
            int n = this.getElementPos(((NEATLinkGene)basicGene).getFromNeuronID());
            NEATNeuron nEATNeuron = list.get(n);
            n = this.getElementPos(((NEATLinkGene)basicGene).getToNeuronID());
            NEATNeuron nEATNeuron2 = list.get(n);
            NEATLink nEATLink = new NEATLink(((NEATLinkGene)basicGene).getWeight(), nEATNeuron, nEATNeuron2, ((NEATLinkGene)basicGene).isRecurrent());
            nEATNeuron.getOutputboundLinks().add(nEATLink);
            nEATNeuron2.getInboundLinks().add(nEATLink);
        }
        nEATPattern.setNEATActivationFunction(((NEATTraining)this.getGeneticAlgorithm()).getNeatActivationFunction());
        nEATPattern.setActivationFunction(((NEATTraining)this.getGeneticAlgorithm()).getOutputActivationFunction());
        nEATPattern.setInputNeurons(this.inputCount);
        nEATPattern.setOutputNeurons(this.outputCount);
        nEATPattern.setSnapshot(((NEATTraining)this.getGeneticAlgorithm()).isSnapshot());
        this.setOrganism(nEATPattern.generate());
    }

    public void encode() {
    }

    public double getCompatibilityScore(NEATGenome nEATGenome) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        int n2 = 0;
        while (n < this.linksChromosome.size() - 1 || n2 < this.linksChromosome.size() - 1) {
            long l;
            if (n == this.linksChromosome.size() - 1) {
                ++n2;
                d2 += 1.0;
                continue;
            }
            if (n2 == nEATGenome.getLinks().size() - 1) {
                ++n;
                d2 += 1.0;
                continue;
            }
            long l2 = ((NEATLinkGene)this.linksChromosome.get(n)).getInnovationId();
            if (l2 == (l = ((NEATLinkGene)nEATGenome.getLinks().get(n2)).getInnovationId())) {
                d3 += 1.0;
                d4 += Math.abs(((NEATLinkGene)this.linksChromosome.get(++n)).getWeight() - ((NEATLinkGene)nEATGenome.getLinks().get(++n2)).getWeight());
            }
            if (l2 < l) {
                d += 1.0;
                ++n;
            }
            if (l2 <= l) continue;
            d += 1.0;
            ++n2;
        }
        int n3 = nEATGenome.getNumGenes();
        if (this.getNumGenes() > n3) {
            n3 = this.getNumGenes();
        }
        double d5 = 1.0 * d2 / (double)n3 + 1.0 * d / (double)n3 + 0.4 * d4 / d3;
        return d5;
    }

    private int getElementPos(long l) {
        for (int i = 0; i < this.getNeurons().size(); ++i) {
            NEATNeuronGene nEATNeuronGene = (NEATNeuronGene)this.neuronsChromosome.getGene(i);
            if (nEATNeuronGene.getId() != l) continue;
            return i;
        }
        return -1;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public Chromosome getLinks() {
        return this.linksChromosome;
    }

    public int getNetworkDepth() {
        return this.networkDepth;
    }

    public Chromosome getNeurons() {
        return this.neuronsChromosome;
    }

    public int getNumGenes() {
        return this.linksChromosome.size();
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public long getSpeciesID() {
        return this.speciesID;
    }

    public double getSplitY(int n) {
        return ((NEATNeuronGene)this.neuronsChromosome.get(n)).getSplitY();
    }

    public boolean isDuplicateLink(long l, long l2) {
        for (Gene gene : this.getLinks().getGenes()) {
            NEATLinkGene nEATLinkGene = (NEATLinkGene)gene;
            if (nEATLinkGene.getFromNeuronID() != l || nEATLinkGene.getToNeuronID() != l2) continue;
            return true;
        }
        return false;
    }

    public void mutateActivationResponse(double d, double d2) {
        for (Gene gene : this.neuronsChromosome.getGenes()) {
            if (!(Math.random() < d)) continue;
            NEATNeuronGene nEATNeuronGene = (NEATNeuronGene)gene;
            nEATNeuronGene.setActivationResponse(nEATNeuronGene.getActivationResponse() + RangeRandomizer.randomize(-1.0, 1.0) * d2);
        }
    }

    public void mutateWeights(double d, double d2, double d3) {
        for (Gene gene : this.linksChromosome.getGenes()) {
            NEATLinkGene nEATLinkGene = (NEATLinkGene)gene;
            if (!(Math.random() < d)) continue;
            if (Math.random() < d2) {
                nEATLinkGene.setWeight(RangeRandomizer.randomize(-1.0, 1.0));
                continue;
            }
            nEATLinkGene.setWeight(nEATLinkGene.getWeight() + RangeRandomizer.randomize(-1.0, 1.0) * d3);
        }
    }

    public void setNetworkDepth(int n) {
        this.networkDepth = n;
    }

    public void setSpeciesID(long l) {
        this.speciesID = l;
    }

    public void sortGenes() {
        Collections.sort(this.linksChromosome.getGenes());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[NEATGenome:");
        stringBuilder.append(this.getGenomeID());
        stringBuilder.append(",fitness=");
        stringBuilder.append(this.getScore());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

