/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.lma;

import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.data.Indexable;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.NeuralOutputHolder;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.training.lma.ComputeJacobian;

public class JacobianChainRule
implements ComputeJacobian {
    private final BasicNetwork network;
    private final Indexable indexableTraining;
    private final int inputLength;
    private final int parameterSize;
    private final double[][] jacobian;
    private int jacobianRow;
    private int jacobianCol;
    private final NeuralDataPair pair;
    private final double[] rowErrors;
    private double error;

    public JacobianChainRule(BasicNetwork basicNetwork, Indexable indexable) {
        this.indexableTraining = indexable;
        this.network = basicNetwork;
        this.parameterSize = basicNetwork.getStructure().calculateSize();
        this.inputLength = (int)this.indexableTraining.getRecordCount();
        this.jacobian = new double[this.inputLength][this.parameterSize];
        this.rowErrors = new double[this.inputLength];
        BasicNeuralData basicNeuralData = new BasicNeuralData(this.indexableTraining.getInputSize());
        BasicNeuralData basicNeuralData2 = new BasicNeuralData(this.indexableTraining.getIdealSize());
        this.pair = new BasicNeuralDataPair(basicNeuralData, basicNeuralData2);
    }

    private double calcDerivative(ActivationFunction activationFunction, double d) {
        return activationFunction.derivativeFunction(d);
    }

    private double calcDerivative2(ActivationFunction activationFunction, double d) {
        double[] dArray = new double[]{d};
        activationFunction.activationFunction(dArray, 0, dArray.length);
        dArray[0] = activationFunction.derivativeFunction(dArray[0]);
        return dArray[0];
    }

    public double calculate(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.inputLength; ++i) {
            double d2;
            this.jacobianRow = i;
            this.jacobianCol = 0;
            this.indexableTraining.getRecord(i, this.pair);
            this.rowErrors[i] = d2 = this.calculateDerivatives(this.pair);
            d += d2 * d2;
        }
        return d / 2.0;
    }

    private double calculateDerivatives(NeuralDataPair neuralDataPair) {
        double d = 0.0;
        double d2 = 0.0;
        ActivationFunction activationFunction = this.network.getLayer("INPUT").getActivationFunction();
        NeuralOutputHolder neuralOutputHolder = new NeuralOutputHolder();
        this.network.compute(neuralDataPair.getInput(), neuralOutputHolder);
        List<Synapse> list = this.network.getStructure().getSynapses();
        int n = 0;
        Synapse synapse = list.get(n++);
        double d3 = neuralOutputHolder.getOutput().getData(0);
        d = neuralDataPair.getIdeal().getData(0) - d3;
        for (int i = 0; i < synapse.getFromNeuronCount(); ++i) {
            double d4 = neuralOutputHolder.getResult().get(synapse).getData(i);
            this.jacobian[this.jacobianRow][this.jacobianCol++] = this.calcDerivative(activationFunction, d3) * d4;
        }
        this.jacobian[this.jacobianRow][this.jacobianCol++] = this.calcDerivative(activationFunction, d3);
        while (n < list.size()) {
            Synapse synapse2 = synapse;
            synapse = list.get(n++);
            NeuralData neuralData = neuralOutputHolder.getResult().get(synapse2);
            for (int i = 0; i < synapse.getToNeuronCount(); ++i) {
                d3 = neuralData.getData(i);
                double d5 = synapse2.getMatrix().get(i, 0);
                double d6 = this.calcDerivative(activationFunction, d3) * this.calcDerivative2(activationFunction, d2) * d5;
                for (int j = 0; j < synapse.getFromNeuronCount(); ++j) {
                    d2 = 0.0;
                    for (int k = 0; k < synapse2.getToNeuronCount(); ++k) {
                        for (int i2 = 0; i2 < synapse2.getFromNeuronCount(); ++i2) {
                            d2 += synapse2.getMatrix().get(i2, k) * d3;
                        }
                        d2 += synapse2.getToLayer().getBiasWeight(k);
                    }
                    this.jacobian[this.jacobianRow][this.jacobianCol++] = d6 * neuralOutputHolder.getResult().get(synapse).getData(j);
                }
                if (!synapse.getToLayer().hasBias()) continue;
                double[] dArray = this.jacobian[this.jacobianRow];
                int n2 = this.jacobianCol++;
                dArray[n2] = dArray[n2] + d6;
            }
        }
        return d;
    }

    public double getError() {
        return this.error;
    }

    public double[][] getJacobian() {
        return this.jacobian;
    }

    public double[] getRowErrors() {
        return this.rowErrors;
    }
}

