/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.encog.Encog;
import org.encog.NullStatusReportable;
import org.encog.engine.StatusReportable;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.training.concurrent.jobs.TrainingJob;
import org.encog.neural.networks.training.concurrent.performers.ConcurrentTrainingPerformer;
import org.encog.neural.networks.training.concurrent.performers.ConcurrentTrainingPerformerCPU;
import org.encog.neural.networks.training.concurrent.performers.ConcurrentTrainingPerformerOpenCL;

public final class ConcurrentTrainingManager
implements Runnable {
    private static ConcurrentTrainingManager instance;
    private final Lock accessLock = new ReentrantLock();
    private final Condition mightBeDone = this.accessLock.newCondition();
    private int jobNumber;
    private boolean singleThreaded;
    private final List<ConcurrentTrainingPerformer> performers = new ArrayList<ConcurrentTrainingPerformer>();
    private final List<TrainingJob> queue = new ArrayList<TrainingJob>();
    private Thread thread;
    private StatusReportable report = new NullStatusReportable();

    public static ConcurrentTrainingManager getInstance() {
        if (instance == null) {
            instance = new ConcurrentTrainingManager();
        }
        return instance;
    }

    private ConcurrentTrainingManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPerformer(ConcurrentTrainingPerformer concurrentTrainingPerformer) {
        try {
            this.accessLock.lock();
            this.performers.add(concurrentTrainingPerformer);
            concurrentTrainingPerformer.setManager(this);
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrainingJob(TrainingJob trainingJob) {
        try {
            this.accessLock.lock();
            this.queue.add(trainingJob);
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPerformers() {
        try {
            this.accessLock.lock();
            this.performers.clear();
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearQueue() {
        try {
            this.accessLock.lock();
            this.queue.clear();
        }
        finally {
            this.accessLock.unlock();
        }
    }

    public void detectPerformers() {
        this.detectPerformers(false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void detectPerformers(boolean bl, int n) {
        try {
            this.accessLock.lock();
            boolean bl2 = true;
            this.clearPerformers();
            int n2 = 1;
            int n3 = 1;
            this.setSingleThreaded(bl);
            if (Encog.getInstance().getCL() != null) {
                if (Encog.getInstance().getCL().areCPUsPresent()) {
                    bl2 = false;
                }
                for (EncogCLDevice object : Encog.getInstance().getCL().getDevices()) {
                    this.addPerformer(new ConcurrentTrainingPerformerOpenCL(n2++, object));
                }
            }
            if (bl2 && n >= 0) {
                void var7_12;
                int n4;
                if (bl) {
                    Runtime i = Runtime.getRuntime();
                    n4 = n > 0 ? n : i.availableProcessors();
                } else {
                    n4 = 1;
                }
                boolean bl3 = false;
                while (var7_12 < n4) {
                    this.addPerformer(new ConcurrentTrainingPerformerCPU(n3++));
                    ++var7_12;
                }
            }
        }
        finally {
            this.accessLock.unlock();
        }
    }

    public void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void reportErrors() {
        for (TrainingJob trainingJob : this.queue) {
            if (trainingJob.getError() == null) continue;
            throw new NeuralNetworkError(trainingJob.getError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.jobNumber = 0;
        this.report.report(this.queue.size(), 0, "Starting first job");
        int n = 0;
        for (TrainingJob trainingJob : this.queue) {
            ConcurrentTrainingPerformer concurrentTrainingPerformer = this.waitForFreePerformer();
            concurrentTrainingPerformer.perform(trainingJob);
            ++n;
            this.reportErrors();
        }
        boolean bl = false;
        this.report.report(this.queue.size(), n, "No more jobs to submit, waiting for last job.");
        while (!bl) {
            try {
                this.accessLock.lock();
                boolean bl2 = false;
                for (ConcurrentTrainingPerformer concurrentTrainingPerformer : this.performers) {
                    if (concurrentTrainingPerformer.ready()) continue;
                    bl2 = true;
                }
                if (bl2) {
                    try {
                        this.mightBeDone.await();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                bl = true;
            }
            finally {
                this.accessLock.unlock();
            }
        }
        this.report.report(this.queue.size(), n, "All training done.");
    }

    private void reportStatus(String string) {
        this.report.report(this.queue.size(), this.jobNumber, string);
    }

    public void setReport(StatusReportable statusReportable) {
        this.report = statusReportable;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentTrainingPerformer waitForFreePerformer() {
        try {
            this.accessLock.lock();
            Object object = null;
            while (object == null) {
                for (ConcurrentTrainingPerformer concurrentTrainingPerformer : this.performers) {
                    if (!concurrentTrainingPerformer.ready()) continue;
                    object = concurrentTrainingPerformer;
                }
                if (object != null) continue;
                try {
                    this.mightBeDone.await();
                }
                catch (InterruptedException interruptedException) {
                    ConcurrentTrainingPerformer concurrentTrainingPerformer;
                    concurrentTrainingPerformer = null;
                    this.accessLock.unlock();
                    return concurrentTrainingPerformer;
                }
            }
            Iterator<ConcurrentTrainingPerformer> iterator = object;
            return iterator;
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobDone(long l, ConcurrentTrainingPerformerCPU concurrentTrainingPerformerCPU) {
        try {
            ++this.jobNumber;
            this.reportStatus("Job finished in " + l + "ms, on " + concurrentTrainingPerformerCPU.toString());
            this.accessLock.lock();
            this.mightBeDone.signal();
        }
        finally {
            this.accessLock.unlock();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        for (ConcurrentTrainingPerformer concurrentTrainingPerformer : this.performers) {
            stringBuilder.append("Performer ");
            stringBuilder.append(n++);
            stringBuilder.append(": ");
            stringBuilder.append(concurrentTrainingPerformer.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public boolean isSingleThreaded() {
        return this.singleThreaded;
    }

    public void setSingleThreaded(boolean bl) {
        this.singleThreaded = bl;
    }
}

