/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.structure;

import org.encog.engine.EngineMachineLearning;
import org.encog.engine.validate.BasicMachineLearningValidate;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.layers.ContextLayer;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.layers.RadialBasisFunctionLayer;
import org.encog.neural.networks.logic.FeedforwardLogic;
import org.encog.neural.networks.logic.ThermalLogic;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.synapse.neat.NEATSynapse;

public class ValidateForFlat
extends BasicMachineLearningValidate {
    public String isValid(EngineMachineLearning engineMachineLearning) {
        if (!(engineMachineLearning instanceof BasicNetwork)) {
            return "Only a BasicNetwork can be converted to a flat network.";
        }
        BasicNetwork basicNetwork = (BasicNetwork)engineMachineLearning;
        Layer layer = basicNetwork.getLayer("INPUT");
        Layer layer2 = basicNetwork.getLayer("OUTPUT");
        if (layer == null) {
            return "To convert to a flat network, there must be an input layer.";
        }
        if (layer2 == null) {
            return "To convert to a flat network, there must be an output layer.";
        }
        if (!(basicNetwork.getLogic() instanceof FeedforwardLogic) || basicNetwork.getLogic() instanceof ThermalLogic) {
            return "To convert to flat, must be using FeedforwardLogic or SimpleRecurrentLogic.";
        }
        for (Layer encogPersistedObject : basicNetwork.getStructure().getLayers()) {
            if (encogPersistedObject.getNext().size() > 2) {
                return "To convert to flat a network must have at most two outbound synapses.";
            }
            if (encogPersistedObject.getClass() == ContextLayer.class || encogPersistedObject.getClass() == BasicLayer.class || encogPersistedObject.getClass() == RadialBasisFunctionLayer.class) continue;
            return "To convert to flat a network must have only BasicLayer and ContextLayer layers.";
        }
        for (Synapse synapse : basicNetwork.getStructure().getSynapses()) {
            if (!(synapse instanceof NEATSynapse)) continue;
            return "A NEAT synapse cannot be flattened.";
        }
        return null;
    }
}

