/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.buffer.codec;

import java.util.Iterator;
import org.encog.engine.util.EngineArray;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.data.buffer.codec.DataSetCODEC;

public class NeuralDataSetCODEC
implements DataSetCODEC {
    private int inputSize;
    private int idealSize;
    private NeuralDataSet dataset;
    private Iterator<NeuralDataPair> iterator;

    public NeuralDataSetCODEC(NeuralDataSet neuralDataSet) {
        this.dataset = neuralDataSet;
        this.inputSize = neuralDataSet.getInputSize();
        this.idealSize = neuralDataSet.getIdealSize();
    }

    public int getInputSize() {
        return this.inputSize;
    }

    public int getIdealSize() {
        return this.idealSize;
    }

    public boolean read(double[] dArray, double[] dArray2) {
        if (!this.iterator.hasNext()) {
            return false;
        }
        NeuralDataPair neuralDataPair = this.iterator.next();
        EngineArray.arrayCopy(neuralDataPair.getInputArray(), dArray);
        EngineArray.arrayCopy(neuralDataPair.getIdealArray(), dArray2);
        return true;
    }

    public void write(double[] dArray, double[] dArray2) {
        NeuralDataPair neuralDataPair = BasicNeuralDataPair.createPair(this.inputSize, this.idealSize);
        EngineArray.arrayCopy(dArray, neuralDataPair.getIdealArray());
        EngineArray.arrayCopy(dArray2, neuralDataPair.getIdealArray());
    }

    public void prepareWrite(int n, int n2, int n3) {
        this.inputSize = n2;
        this.idealSize = n3;
    }

    public void prepareRead() {
        this.iterator = this.dataset.iterator();
    }

    public void close() {
    }
}

