/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.buffer.codec;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.encog.engine.util.EngineArray;
import org.encog.neural.data.buffer.BufferedDataError;
import org.encog.neural.data.buffer.codec.DataSetCODEC;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.csv.ReadCSV;

public class CSVDataCODEC
implements DataSetCODEC {
    private File file;
    private CSVFormat format;
    private int inputCount;
    private int idealCount;
    private boolean headers;
    private ReadCSV readCSV;
    private PrintStream output;

    public CSVDataCODEC(File file, CSVFormat cSVFormat, boolean bl, int n, int n2) {
        if (this.inputCount != 0) {
            throw new BufferedDataError("To export CSV, you must use the CSVDataCODEC constructor that does not specify input or ideal sizes.");
        }
        this.file = file;
        this.format = cSVFormat;
        this.inputCount = n;
        this.idealCount = n2;
        this.headers = bl;
    }

    public CSVDataCODEC(File file, CSVFormat cSVFormat) {
        this.file = file;
        this.format = cSVFormat;
    }

    public boolean read(double[] dArray, double[] dArray2) {
        if (this.readCSV.next()) {
            int n;
            int n2 = 0;
            for (n = 0; n < dArray.length; ++n) {
                dArray[n] = this.readCSV.getDouble(n2++);
            }
            for (n = 0; n < dArray2.length; ++n) {
                dArray2[n] = this.readCSV.getDouble(n2++);
            }
            return true;
        }
        return false;
    }

    public void write(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length + dArray2.length];
        EngineArray.arrayCopy(dArray, dArray3);
        EngineArray.arrayCopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
        StringBuilder stringBuilder = new StringBuilder();
        NumberList.toList(this.format, stringBuilder, dArray3);
        this.output.println(stringBuilder.toString());
    }

    public void prepareWrite(int n, int n2, int n3) {
        try {
            this.inputCount = n2;
            this.idealCount = n3;
            this.output = new PrintStream(new FileOutputStream(this.file));
        }
        catch (IOException iOException) {
            throw new BufferedDataError(iOException);
        }
    }

    public void prepareRead() {
        if (this.inputCount == 0) {
            throw new BufferedDataError("To import CSV, you must use the CSVDataCODEC constructor that specifies input and ideal sizes.");
        }
        this.readCSV = new ReadCSV(this.file.toString(), this.headers, this.format);
    }

    public int getInputSize() {
        return this.inputCount;
    }

    public int getIdealSize() {
        return this.idealCount;
    }

    public void close() {
        if (this.readCSV != null) {
            this.readCSV.close();
            this.readCSV = null;
        }
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
    }
}

