/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.buffer;

import java.io.File;
import org.encog.NullStatusReportable;
import org.encog.engine.StatusReportable;
import org.encog.neural.data.buffer.EncogEGBFile;
import org.encog.neural.data.buffer.codec.DataSetCODEC;

public class BinaryDataLoader {
    private DataSetCODEC codec;
    private StatusReportable status = new NullStatusReportable();

    public BinaryDataLoader(DataSetCODEC dataSetCODEC) {
        this.codec = dataSetCODEC;
    }

    public void external2Binary(File file) {
        this.status.report(0, 0, "Importing to binary file: " + file.toString());
        EncogEGBFile encogEGBFile = new EncogEGBFile(file);
        encogEGBFile.create(this.codec.getInputSize(), this.codec.getIdealSize());
        double[] dArray = new double[this.codec.getInputSize()];
        double[] dArray2 = new double[this.codec.getIdealSize()];
        this.codec.prepareRead();
        int n = 3;
        int n2 = 0;
        int n3 = 0;
        while (this.codec.read(dArray, dArray2)) {
            encogEGBFile.write(dArray);
            encogEGBFile.write(dArray2);
            n += dArray.length;
            n += dArray2.length;
            ++n2;
            if (++n3 < 10000) continue;
            n3 = 0;
            this.status.report(0, n2, "Importing...");
        }
        encogEGBFile.close();
        this.codec.close();
        this.status.report(0, 0, "Done importing to binary file: " + file.toString());
    }

    public void binary2External(File file) {
        this.status.report(0, 0, "Exporting binary file: " + file.toString());
        EncogEGBFile encogEGBFile = new EncogEGBFile(file);
        encogEGBFile.open();
        this.codec.prepareWrite(encogEGBFile.getNumberOfRecords(), encogEGBFile.getInputCount(), encogEGBFile.getIdealCount());
        int n = encogEGBFile.getInputCount();
        int n2 = encogEGBFile.getIdealCount();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n2];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < encogEGBFile.getNumberOfRecords(); ++i) {
            int n5;
            for (n5 = 0; n5 < n; ++n5) {
                dArray[n5] = encogEGBFile.read();
            }
            for (n5 = 0; n5 < n2; ++n5) {
                dArray2[n5] = encogEGBFile.read();
            }
            this.codec.write(dArray, dArray2);
            ++n3;
            if (++n4 < 10000) continue;
            n4 = 0;
            this.status.report(encogEGBFile.getNumberOfRecords(), n3, "Exporting...");
        }
        encogEGBFile.close();
        this.codec.close();
        this.status.report(0, 0, "Done exporting binary file: " + file.toString());
    }

    public StatusReportable getStatus() {
        return this.status;
    }

    public void setStatus(StatusReportable statusReportable) {
        this.status = statusReportable;
    }

    public DataSetCODEC getCodec() {
        return this.codec;
    }
}

