/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.encog.EncogError;
import org.encog.persist.BasicPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.PropertyDataPersistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyData
extends BasicPersistedObject {
    private static final long serialVersionUID = -7940416732740995199L;
    private final Map<String, String> data = new HashMap<String, String>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Object clone() {
        PropertyData propertyData = new PropertyData();
        propertyData.setName(this.getName());
        propertyData.setDescription(this.getDescription());
        propertyData.setCollection(this.getCollection());
        for (String string : this.data.keySet()) {
            propertyData.set(string, this.get(string));
        }
        return propertyData;
    }

    @Override
    public Persistor createPersistor() {
        return new PropertyDataPersistor();
    }

    public String get(String string) {
        return this.data.get(string);
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public Date getDate(String string) {
        try {
            String string2 = this.get(string);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yy");
            Date date = simpleDateFormat.parse(string2);
            return date;
        }
        catch (ParseException parseException) {
            throw new EncogError(parseException);
        }
    }

    public double getDouble(String string) {
        String string2 = this.get(string);
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new EncogError(numberFormatException);
        }
    }

    public int getInteger(String string) {
        String string2 = this.get(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new EncogError(numberFormatException);
        }
    }

    public boolean isDefined(String string) {
        return this.data.containsKey(string);
    }

    public void remove(String string) {
        this.data.remove(string);
    }

    public void set(String string, String string2) {
        this.data.put(string, string2);
    }

    public int size() {
        return this.data.size();
    }
}

