/*
 * Decompiled with CFR 0.152.
 */
package org.encog.bot.rss;

import java.util.Date;
import org.encog.bot.rss.RSS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RSSItem {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String title;
    private String link;
    private String description;
    private Date date;

    public Date getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLink() {
        return this.link;
    }

    public String getTitle() {
        return this.title;
    }

    public void load(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            if (string2.equalsIgnoreCase("title")) {
                this.title = RSS.getXMLText(node2);
                continue;
            }
            if (string2.equalsIgnoreCase("link")) {
                this.link = RSS.getXMLText(node2);
                continue;
            }
            if (string2.equalsIgnoreCase("description")) {
                this.description = RSS.getXMLText(node2);
                continue;
            }
            if (!string2.equalsIgnoreCase("pubDate") || (string = RSS.getXMLText(node2)) == null) continue;
            this.date = RSS.parseDate(string);
        }
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append("title=\"");
        stringBuilder.append(this.title);
        stringBuilder.append("\",link=\"");
        stringBuilder.append(this.link);
        stringBuilder.append("\",date=\"");
        stringBuilder.append(this.date);
        stringBuilder.append("\"]");
        return stringBuilder.toString();
    }
}

