/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.util;

import java.awt.Window;
import java.awt.peer.ComponentPeer;
import java.lang.reflect.Method;
import sun.plugin2.util.SystemUtil;

public class SharedWindowAWT {
    private static final boolean DEBUG = SystemUtil.getenv("JPI_PLUGIN2_DEBUG") != null;
    private static Method accessableGetData;
    private static Method accessableGetSetHasShadow;
    private static Method accessableGetWindowID;
    static Class windowPeerClass;

    public static void setHasShadow(Window window, boolean bl) {
        if (DEBUG) {
            System.err.println("SharedWindowAWT.setHasShadow(" + window + ", " + bl + ")");
        }
        ComponentPeer componentPeer = SharedWindowAWT.getPeer(window);
        try {
            Object object = SharedWindowAWT.getAccessableGetData().invoke((Object)componentPeer, new Object[0]);
            SharedWindowAWT.getAccessableSetHasShadow().invoke((Object)componentPeer, object, new Boolean(bl));
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static Method getAccessableGetData() throws Throwable {
        if (accessableGetData != null) {
            return accessableGetData;
        }
        accessableGetData = SharedWindowAWT.getWindowPeerClass().getDeclaredMethod("getData", new Class[0]);
        accessableGetData.setAccessible(true);
        return accessableGetData;
    }

    private static Method getAccessableSetHasShadow() throws Throwable {
        if (accessableGetSetHasShadow != null) {
            return accessableGetSetHasShadow;
        }
        accessableGetSetHasShadow = SharedWindowAWT.getWindowPeerClass().getDeclaredMethod("_setHasShadow", Long.TYPE, Boolean.TYPE);
        accessableGetSetHasShadow.setAccessible(true);
        return accessableGetSetHasShadow;
    }

    public static long windowHandleFor(Window window) {
        ComponentPeer componentPeer;
        if (DEBUG) {
            System.err.println("SharedWindowAWT.windowHandleFor(" + window + ")");
        }
        if ((componentPeer = SharedWindowAWT.getPeer(window)) == null) {
            return 0L;
        }
        try {
            Object object = SharedWindowAWT.getAccessableGetWindowID().invoke((Object)componentPeer, new Object[0]);
            return (Long)object;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static Method getAccessableGetWindowID() throws Throwable {
        if (accessableGetWindowID != null) {
            return accessableGetWindowID;
        }
        accessableGetWindowID = SharedWindowAWT.getWindowPeerClass().getDeclaredMethod("getWindowID", new Class[0]);
        accessableGetWindowID.setAccessible(true);
        return accessableGetWindowID;
    }

    private static ComponentPeer getPeer(Window window) {
        if (window == null) {
            return null;
        }
        ComponentPeer componentPeer = window.getPeer();
        if (componentPeer == null) {
            return null;
        }
        return componentPeer;
    }

    private static Class getWindowPeerClass() {
        if (windowPeerClass != null) {
            return windowPeerClass;
        }
        try {
            windowPeerClass = Class.forName("apple.awt.CWindow");
            return windowPeerClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

