/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.encog.engine.EncogEngineError;

public final class ResourceLoader {
    public static InputStream createInputStream(String string) {
        ClassLoader classLoader = ResourceLoader.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            String string2 = "Can't read resource: " + string;
            throw new EncogEngineError(string2);
        }
        return inputStream;
    }

    public static String loadString(String string) {
        InputStream inputStream = null;
        try {
            String string2;
            inputStream = ResourceLoader.createInputStream(string);
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
                stringBuilder.append("\r\n");
            }
            String string3 = stringBuilder.toString();
            return string3;
        }
        catch (IOException iOException) {
            throw new EncogEngineError(iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new EncogEngineError(iOException);
            }
        }
    }

    private ResourceLoader() {
    }
}

