/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.train.prop;

import org.encog.engine.data.EngineDataSet;
import org.encog.engine.network.flat.FlatNetwork;
import org.encog.engine.network.train.prop.TrainFlatNetworkProp;

public class TrainFlatNetworkManhattan
extends TrainFlatNetworkProp {
    private final double zeroTolerance;
    private double learningRate;

    public TrainFlatNetworkManhattan(FlatNetwork flatNetwork, EngineDataSet engineDataSet, double d) {
        super(flatNetwork, engineDataSet);
        this.learningRate = d;
        this.zeroTolerance = 1.0E-17;
    }

    public double updateWeight(double[] dArray, double[] dArray2, int n) {
        if (Math.abs(dArray[n]) < this.zeroTolerance) {
            return 0.0;
        }
        if (dArray[n] > 0.0) {
            return this.learningRate;
        }
        return -this.learningRate;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(double d) {
        this.learningRate = d;
    }
}

