/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.CellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.ImageView;
import ncsa.hdf.view.PaletteView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultPaletteView
extends JDialog
implements PaletteView,
MouseListener,
MouseMotionListener,
ActionListener,
ItemListener {
    private static final long serialVersionUID = -5092012421988388661L;
    private final Color[] lineColors = new Color[]{Color.red, Color.green, Color.blue};
    private final String[] lineLabels = new String[]{"Red", "Green", "Blue"};
    private static String PALETTE_GRAY = "Gray";
    private static String PALETTE_DEFAULT = "Default";
    private static String PALETTE_REVERSE_GRAY = "Reverse Gray";
    private static String PALETTE_GRAY_WAVE = "GrayWave";
    private static String PALETTE_RAINBOW = "Rainbow";
    private static String PALETTE_NATURE = "Nature";
    private static String PALETTE_WAVE = "Wave";
    private JRadioButton checkRed;
    private JRadioButton checkGreen;
    private JRadioButton checkBlue;
    private ChartPanel chartP;
    private int x0;
    private int y0;
    private Image originalImage;
    private Image currentImage;
    boolean isPaletteChanged = false;
    byte[][] palette;
    private ScalarDS dataset;
    private ImageView imageView;
    private int[][] paletteData;
    private JComboBox choicePalette;
    private PaletteValueTable paletteValueTable;
    private int numberOfPalettes;
    private boolean startEditing = false;

    public DefaultPaletteView(ImageView theImageView) {
        this(null, theImageView);
    }

    public DefaultPaletteView(ViewManager theViewer, ImageView theImageView) {
        super((Frame)((JFrame)((Object)theViewer)), true);
        byte[] palRefs;
        this.setDefaultCloseOperation(2);
        this.imageView = theImageView;
        this.dataset = (ScalarDS)this.imageView.getDataObject();
        this.numberOfPalettes = 1;
        this.choicePalette = new JComboBox();
        this.choicePalette.addItemListener(this);
        boolean isH5 = this.dataset.getFileFormat().isThisType(FileFormat.getFileFormat((String)"HDF5"));
        this.choicePalette.addItem("Select palette");
        String paletteName = this.dataset.getPaletteName(0);
        if (paletteName != null) {
            paletteName = paletteName.trim();
        }
        if (paletteName != null && paletteName.length() > 0) {
            this.choicePalette.addItem(paletteName);
        }
        if (isH5 && this.dataset instanceof ScalarDS && (palRefs = this.dataset.getPaletteRefs()) != null && palRefs.length > 8) {
            this.numberOfPalettes = palRefs.length / 8;
        }
        for (int i = 1; i < this.numberOfPalettes; ++i) {
            paletteName = this.dataset.getPaletteName(i);
            this.choicePalette.addItem(paletteName);
        }
        this.choicePalette.addItem(PALETTE_GRAY);
        this.choicePalette.addItem(PALETTE_GRAY_WAVE);
        this.choicePalette.addItem(PALETTE_RAINBOW);
        this.choicePalette.addItem(PALETTE_NATURE);
        this.choicePalette.addItem(PALETTE_WAVE);
        Vector<String> plist = ViewProperties.getPaletteList();
        int n = plist.size();
        for (int i = 0; i < n; ++i) {
            this.choicePalette.addItem(plist.get(i));
        }
        this.chartP = new ChartPanel();
        this.chartP.setBackground(Color.white);
        this.paletteData = new int[3][256];
        byte[][] imagePalette = this.imageView.getPalette();
        this.setTitle("Image Palette for - " + this.dataset.getPath() + this.dataset.getName());
        int d = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 256; ++j) {
                d = imagePalette[i][j];
                if (d < 0) {
                    d += 256;
                }
                this.paletteData[i][j] = d;
            }
        }
        this.imageView = theImageView;
        this.chartP.addMouseListener(this);
        this.chartP.addMouseMotionListener(this);
        this.y0 = 0;
        this.x0 = 0;
        this.originalImage = this.currentImage = this.imageView.getImage();
        this.palette = new byte[3][256];
        this.createUI();
        this.setVisible(true);
    }

    @Override
    public HObject getDataObject() {
        return this.dataset;
    }

    private void createUI() {
        Window owner = this.getOwner();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        int w = 700 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 500 + (ViewProperties.getFontSize() - 12) * 10;
        contentPane.setPreferredSize(new Dimension(w, h));
        contentPane.add((Component)this.chartP, "Center");
        JButton button = new JButton("  Ok  ");
        button.addActionListener(this);
        button.setActionCommand("Ok");
        JPanel buttonP = new JPanel();
        buttonP.setBorder(new LineBorder(Color.GRAY));
        buttonP.add(button);
        button = new JButton("Cancel");
        button.addActionListener(this);
        button.setActionCommand("Cancel");
        buttonP.add(button);
        button = new JButton("Preview");
        button.addActionListener(this);
        button.setActionCommand("Preview");
        buttonP.add(button);
        JPanel bottomP = new JPanel();
        bottomP.setLayout(new BorderLayout(20, 2));
        bottomP.add((Component)buttonP, "East");
        this.checkRed = new JRadioButton("Red");
        this.checkRed.setForeground(Color.red);
        this.checkGreen = new JRadioButton("Green");
        this.checkGreen.setForeground(Color.green);
        this.checkBlue = new JRadioButton("Blue");
        this.checkBlue.setForeground(Color.blue);
        this.checkRed.setSelected(true);
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(this.checkRed);
        bgroup.add(this.checkGreen);
        bgroup.add(this.checkBlue);
        JPanel checkP = new JPanel();
        checkP.setBorder(new LineBorder(Color.GRAY));
        checkP.add(this.checkRed);
        checkP.add(this.checkGreen);
        checkP.add(this.checkBlue);
        bottomP.add((Component)checkP, "West");
        JPanel valueP = new JPanel();
        valueP.setLayout(new GridLayout(1, 2));
        valueP.setBorder(new LineBorder(Color.GRAY));
        JButton valueButton = new JButton("Show Values");
        valueButton.setActionCommand("Show palette values");
        valueButton.addActionListener(this);
        valueP.add(this.choicePalette);
        valueP.add(valueButton);
        bottomP.add((Component)valueP, "Center");
        contentPane.add((Component)bottomP, "South");
        Point l = owner.getLocation();
        l.x += 350;
        l.y += 200;
        this.setLocation(l);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Ok")) {
            if (this.isPaletteChanged) {
                this.updatePalette();
                this.isPaletteChanged = false;
                this.imageView.setPalette(this.palette);
                this.imageView.setImage(this.currentImage);
            }
            super.dispose();
        } else if (cmd.equals("Cancel")) {
            this.imageView.setImage(this.originalImage);
            super.dispose();
        } else if (cmd.equals("Preview")) {
            this.updatePalette();
            this.imageView.setImage(this.currentImage);
        } else if (cmd.equals("Show palette values")) {
            if (this.paletteValueTable == null) {
                this.paletteValueTable = new PaletteValueTable(this);
            }
            this.paletteValueTable.refresh();
            this.paletteValueTable.setVisible(true);
        } else if (cmd.equals("Hide palette values") && this.paletteValueTable != null) {
            this.paletteValueTable.setVisible(false);
        }
    }

    @Override
    public void dispose() {
        this.imageView.setImage(this.originalImage);
        super.dispose();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (!src.equals(this.choicePalette)) {
            return;
        }
        int idx = this.choicePalette.getSelectedIndex();
        if (idx <= 0) {
            return;
        }
        byte[][] imagePalette = null;
        Object item = this.choicePalette.getSelectedItem();
        imagePalette = item.equals(PALETTE_DEFAULT) ? this.dataset.getPalette() : (item.equals(PALETTE_GRAY) ? Tools.createGrayPalette() : (item.equals(PALETTE_REVERSE_GRAY) ? Tools.createReverseGrayPalette() : (item.equals(PALETTE_GRAY_WAVE) ? Tools.createGrayWavePalette() : (item.equals(PALETTE_RAINBOW) ? Tools.createRainbowPalette() : (item.equals(PALETTE_NATURE) ? Tools.createNaturePalette() : (item.equals(PALETTE_WAVE) ? Tools.createWavePalette() : (idx > 0 && idx <= this.numberOfPalettes ? this.dataset.readPalette(idx - 1) : Tools.readPalette((String)item))))))));
        if (imagePalette == null) {
            return;
        }
        int d = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 256; ++j) {
                d = imagePalette[i][j];
                if (d < 0) {
                    d += 256;
                }
                this.paletteData[i][j] = d;
            }
        }
        this.chartP.repaint();
        this.isPaletteChanged = true;
    }

    private void updatePalette() {
        for (int i = 0; i < 256; ++i) {
            this.palette[0][i] = (byte)this.paletteData[0][i];
            this.palette[1][i] = (byte)this.paletteData[1][i];
            this.palette[2][i] = (byte)this.paletteData[2][i];
        }
        IndexColorModel colorModel = new IndexColorModel(8, 256, this.palette[0], this.palette[1], this.palette[2]);
        int w = this.dataset.getWidth();
        int h = this.dataset.getHeight();
        MemoryImageSource memoryImageSource = null;
        try {
            memoryImageSource = (MemoryImageSource)this.originalImage.getSource();
        }
        catch (Throwable err) {
            memoryImageSource = null;
        }
        if (memoryImageSource == null) {
            memoryImageSource = new MemoryImageSource(w, h, (ColorModel)colorModel, this.imageView.getImageByteData(), 0, w);
        } else {
            memoryImageSource.newPixels(this.imageView.getImageByteData(), (ColorModel)colorModel, 0, w);
        }
        this.currentImage = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.paletteValueTable != null && this.paletteValueTable.isVisible()) {
            this.paletteValueTable.refresh();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x1 = e.getX() - 40;
        if (x1 < 0) {
            x1 = 0;
        }
        int y1 = e.getY() + 20;
        Dimension d = this.chartP.getSize();
        double ry = 255.0 / (double)d.height;
        double rx = 255.0 / (double)d.width;
        int lineIdx = 0;
        if (this.checkGreen.isSelected()) {
            lineIdx = 1;
        } else if (this.checkBlue.isSelected()) {
            lineIdx = 2;
        }
        int idx = 0;
        double b = (double)(y1 - this.y0) / (double)(x1 - this.x0);
        double a = (double)this.y0 - b * (double)this.x0;
        double value = (double)this.y0 * ry;
        int i0 = Math.min(this.x0, x1);
        int i1 = Math.max(this.x0, x1);
        for (int i = i0; i < i1; ++i) {
            idx = (int)(rx * (double)i);
            if (idx > 255) continue;
            value = 255.0 - (a + b * (double)i) * ry;
            if (value < 0.0) {
                value = 0.0;
            } else if (value > 255.0) {
                value = 255.0;
            }
            this.paletteData[lineIdx][idx] = (int)value;
        }
        this.chartP.repaint();
        this.isPaletteChanged = true;
    }

    private final class ChartPanel
    extends JComponent {
        private static final long serialVersionUID = -6861041412971944L;

        private ChartPanel() {
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getSize();
            int gap = 20;
            int legendSpace = 60;
            int h = d.height - gap;
            int w = d.width - 3 * gap - legendSpace;
            g.drawLine(2 * gap, h, w + 2 * gap, h);
            g.drawLine(2 * gap, h, 2 * gap, 0);
            int dh = h / 10;
            int dw = w / 10;
            int dx = 25;
            double dy = 25.0;
            int xp = 2 * gap;
            int yp = 0;
            int x = 0;
            double y = 0.0;
            g.drawString(String.valueOf((int)y), 0, h + 8);
            g.drawString(String.valueOf(x), xp - 5, h + gap);
            for (int i = 0; i < 10; ++i) {
                g.drawLine(xp += dw, h, xp, h - 5);
                g.drawLine(2 * gap, h - (yp += dh), 2 * gap + 5, h - yp);
                g.drawString(String.valueOf((int)(y += dy)), 0, h - yp + 8);
                g.drawString(String.valueOf(x += dx), xp - 5, h + gap);
            }
            Color c = g.getColor();
            for (int i = 0; i < 3; ++i) {
                int y0;
                int x0;
                g.setColor(DefaultPaletteView.this.lineColors[i]);
                for (int j = 0; j < 255; ++j) {
                    x0 = w * j / 255 + 2 * gap;
                    y0 = h - h * DefaultPaletteView.this.paletteData[i][j] / 255;
                    int x1 = w * (j + 1) / 255 + 2 * gap;
                    int y1 = h - h * DefaultPaletteView.this.paletteData[i][j + 1] / 255;
                    g.drawLine(x0, y0, x1, y1);
                }
                x0 = w + legendSpace;
                y0 = gap + gap * i;
                g.drawLine(x0, y0, x0 + 7, y0);
                g.drawString(DefaultPaletteView.this.lineLabels[i], x0 + 10, y0 + 3);
            }
            g.setColor(c);
            g.drawRect(w + legendSpace - 10, 10, legendSpace, 10 * gap);
        }
    }

    private final class PaletteValueTable
    extends JDialog {
        private static final long serialVersionUID = 6105012612969555535L;
        private JTable valueTable;
        private DefaultTableModel valueTableModel;
        String rgbName;
        String idxName;
        int editingRow;
        int editingCol;

        public PaletteValueTable(DefaultPaletteView owner) {
            super(owner);
            this.rgbName = "Color";
            this.idxName = "Index";
            this.editingRow = -1;
            this.editingCol = -1;
            Object[] columnNames = new String[]{this.idxName, "Red", "Green", "Blue", this.rgbName};
            this.valueTableModel = new DefaultTableModel(columnNames, 256);
            this.valueTable = new JTable(this.valueTableModel){
                private static final long serialVersionUID = -2823793138915014637L;

                @Override
                public boolean isCellEditable(int row, int col) {
                    return col > 0 && col < 4;
                }

                @Override
                public Object getValueAt(int row, int col) {
                    if (DefaultPaletteView.this.startEditing && row == this.editingRow && col == PaletteValueTable.this.editingCol) {
                        return "";
                    }
                    if (col == 0) {
                        return String.valueOf(row);
                    }
                    if (col < 4) {
                        return String.valueOf(DefaultPaletteView.this.paletteData[col - 1][row]);
                    }
                    return "";
                }

                @Override
                public boolean editCellAt(int row, int column, EventObject e) {
                    KeyEvent ke;
                    if (!this.isCellEditable(row, column)) {
                        return super.editCellAt(row, column, e);
                    }
                    if (e instanceof KeyEvent && (ke = (KeyEvent)e).getID() == 401) {
                        DefaultPaletteView.this.startEditing = true;
                        this.editingRow = row;
                        PaletteValueTable.this.editingCol = column;
                    }
                    return super.editCellAt(row, column, e);
                }

                @Override
                public void editingStopped(ChangeEvent e) {
                    int col;
                    int row = this.getEditingRow();
                    if (!this.isCellEditable(row, col = this.getEditingColumn())) {
                        return;
                    }
                    String oldValue = (String)this.getValueAt(row, col);
                    super.editingStopped(e);
                    DefaultPaletteView.this.startEditing = false;
                    this.editingRow = -1;
                    PaletteValueTable.this.editingCol = -1;
                    Object source = e.getSource();
                    if (source instanceof CellEditor) {
                        CellEditor editor = (CellEditor)source;
                        String newValue = (String)editor.getCellEditorValue();
                        this.setValueAt(oldValue, row, col);
                        PaletteValueTable.this.updatePaletteValue(newValue, row, col - 1);
                    }
                }
            };
            this.valueTable.setName("PaletteValue");
            this.valueTable.getColumn(this.rgbName).setCellRenderer(new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 8390954944015521331L;
                Color color = Color.white;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                    Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                    this.color = new Color(DefaultPaletteView.this.paletteData[0][row], DefaultPaletteView.this.paletteData[1][row], DefaultPaletteView.this.paletteData[2][row]);
                    comp.setBackground(this.color);
                    return comp;
                }
            });
            this.valueTable.getColumn(this.idxName).setCellRenderer(new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 2786027382023940417L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                    Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                    comp.setBackground(Color.LIGHT_GRAY);
                    return comp;
                }
            });
            this.valueTable.setRowSelectionAllowed(false);
            this.valueTable.setCellSelectionEnabled(true);
            this.valueTable.getTableHeader().setReorderingAllowed(false);
            this.valueTable.setSelectionMode(0);
            int cellRowHeight = Math.max(16, this.valueTable.getFontMetrics(this.valueTable.getFont()).getHeight());
            this.valueTable.setRowHeight(cellRowHeight);
            JScrollPane scroller = new JScrollPane(this.valueTable);
            JPanel contentPane = (JPanel)this.getContentPane();
            int w = 300 + (ViewProperties.getFontSize() - 12) * 10;
            int h = 600 + (ViewProperties.getFontSize() - 12) * 15;
            contentPane.setPreferredSize(new Dimension(w, h));
            contentPane.setLayout(new BorderLayout(5, 5));
            contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            contentPane.add((Component)scroller, "Center");
            JButton button = new JButton("  Ok  ");
            button.addActionListener(owner);
            button.setActionCommand("Hide palette values");
            JPanel tmpP = new JPanel();
            tmpP.add(button);
            contentPane.add((Component)tmpP, "South");
            Point l = owner.getLocation();
            l.x += 100;
            l.y += 100;
            this.setLocation(l);
            this.pack();
        }

        private void updatePaletteValue(String strValue, int row, int col) {
            if (strValue == null) {
                return;
            }
            int value = 0;
            try {
                value = Integer.parseInt(strValue);
            }
            catch (Exception ex) {
                return;
            }
            if (value < 0 || value > 255) {
                JOptionPane.showMessageDialog(this, "Value is out of range [0, 255]\n", this.getTitle(), 0);
                return;
            }
            ((DefaultPaletteView)DefaultPaletteView.this).paletteData[col][row] = value;
            DefaultPaletteView.this.chartP.repaint();
            DefaultPaletteView.this.isPaletteChanged = true;
        }

        public void refresh() {
            this.valueTable.editingStopped(new ChangeEvent(this.valueTable));
            this.valueTable.updateUI();
        }
    }
}

