/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import ncsa.hdf.view.ViewProperties;

public class Chart
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 6306479533747330357L;
    public static final int HISTOGRAM = 0;
    public static final int LINEPLOT = 1;
    public static final Color[] LINE_COLORS = new Color[]{Color.black, Color.red, Color.green.darker(), Color.blue, Color.magenta, Color.pink, Color.yellow, Color.orange, Color.gray, Color.cyan};
    protected double[][] data;
    protected ChartPanel chartP;
    protected int numberOfPoints;
    private int chartStyle;
    private double ymax;
    private double ymin;
    private double xmax;
    private double xmin;
    private String[] lineLabels;
    private Color[] lineColors;
    private int numberOfLines;
    private double[] xData = null;
    private boolean isInteger;
    private DecimalFormat format;

    public Chart(Frame owner, String title, int style, double[][] data, double[] xData, double[] yRange) {
        super(owner, title, false);
        this.setDefaultCloseOperation(2);
        this.format = new DecimalFormat("0.00E0");
        if (data == null) {
            return;
        }
        this.chartStyle = style;
        this.data = data;
        this.isInteger = style == 0;
        if (xData != null) {
            int len = xData.length;
            if (len == 2) {
                this.xmin = xData[0];
                this.xmax = xData[1];
            } else {
                this.xData = xData;
                this.xmin = this.xmax = xData[0];
                for (int i = 0; i < len; ++i) {
                    if (xData[i] < this.xmin) {
                        this.xmin = xData[i];
                    }
                    if (!(xData[i] > this.xmax)) continue;
                    this.xmax = xData[i];
                }
            }
        } else {
            this.xmin = 1.0;
            this.xmax = data[0].length;
        }
        this.numberOfLines = Array.getLength(data);
        this.numberOfPoints = Array.getLength(data[0]);
        this.lineColors = LINE_COLORS;
        if (yRange != null) {
            this.ymin = yRange[0];
            this.ymax = yRange[1];
        } else {
            this.findDataRange();
        }
        if (this.ymax < 1.0E-4 || this.ymax > 100000.0) {
            this.format = new DecimalFormat("###.####E0#");
        }
        this.chartP = new ChartPanel();
        this.chartP.setBackground(Color.white);
        this.createUI();
    }

    protected void createUI() {
        Window owner = this.getOwner();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        int w = 640 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 400 + (ViewProperties.getFontSize() - 12) * 10;
        contentPane.setPreferredSize(new Dimension(w, h));
        contentPane.add((Component)this.chartP, "Center");
        JButton button = new JButton("Close");
        button.addActionListener(this);
        button.setActionCommand("Close");
        JPanel tmp = new JPanel();
        tmp.add(button);
        contentPane.add((Component)tmp, "South");
        Point l = owner.getLocation();
        l.x += 220;
        l.y += 100;
        this.setLocation(l);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Close")) {
            this.dispose();
        }
    }

    public void setLineColors(Color[] c) {
        this.lineColors = c;
    }

    public void setLineLabels(String[] l) {
        this.lineLabels = l;
    }

    public void setTypeToInteger() {
        this.isInteger = true;
    }

    private void findDataRange() {
        if (this.data == null) {
            return;
        }
        this.ymin = this.ymax = this.data[0][0];
        for (int i = 0; i < this.numberOfLines; ++i) {
            for (int j = 0; j < this.numberOfPoints; ++j) {
                if (this.data[i][j] < this.ymin) {
                    this.ymin = this.data[i][j];
                }
                if (!(this.data[i][j] > this.ymax)) continue;
                this.ymax = this.data[i][j];
            }
        }
    }

    private class ChartPanel
    extends JComponent {
        private static final long serialVersionUID = -3701826094727309097L;

        private ChartPanel() {
        }

        @Override
        public void paint(Graphics g) {
            if (Chart.this.numberOfLines <= 0) {
                return;
            }
            Dimension d = this.getSize();
            int gap = 20;
            int xgap = 2 * gap;
            int ygap = 2 * gap;
            int legendSpace = 0;
            if (Chart.this.chartStyle == 1 && Chart.this.lineLabels != null) {
                legendSpace = 60;
            }
            int h = d.height - gap;
            int w = d.width - (3 * gap + legendSpace);
            int xnpoints = Math.min(10, Chart.this.numberOfPoints - 1);
            int ynpoints = 10;
            g.drawLine(xgap, h, w + xgap, h);
            g.drawLine(ygap, h, ygap, 0);
            double xp = 0.0;
            double x = Chart.this.xmin;
            double dw = (double)w / (double)xnpoints;
            double dx = (Chart.this.xmax - Chart.this.xmin) / (double)xnpoints;
            boolean gtOne = dx >= 1.0;
            for (int i = 0; i <= xnpoints; ++i) {
                x = Chart.this.xmin + (double)i * dx;
                xp = (double)xgap + (double)i * dw;
                g.drawLine((int)xp, h, (int)xp, h - 5);
                if (gtOne) {
                    g.drawString(String.valueOf((int)x), (int)xp - 5, h + gap);
                    continue;
                }
                g.drawString(String.valueOf(x), (int)xp - 5, h + gap);
            }
            double yp = 0.0;
            double y = Chart.this.ymin;
            double dh = (double)h / (double)ynpoints;
            double dy = (Chart.this.ymax - Chart.this.ymin) / (double)ynpoints;
            if (dy > 1.0) {
                dy = (double)Math.round(dy * 10.0) / 10.0;
            }
            for (int i = 0; i <= ynpoints; ++i) {
                yp = (double)i * dh;
                y = (double)i * dy + Chart.this.ymin;
                g.drawLine(ygap, h - (int)yp, ygap + 5, h - (int)yp);
                if (Chart.this.isInteger) {
                    g.drawString(String.valueOf((int)y), 0, h - (int)yp + 8);
                    continue;
                }
                g.drawString(Chart.this.format.format(y), 0, h - (int)yp + 8);
            }
            Color c = g.getColor();
            if (Chart.this.chartStyle == 1) {
                dw = (double)w / (double)(Chart.this.numberOfPoints - 1);
                double b = (double)h / (Chart.this.ymin - Chart.this.ymax);
                double a = -b * Chart.this.ymax;
                boolean hasXdata = Chart.this.xData != null && Chart.this.xData.length >= Chart.this.numberOfPoints;
                double xRatio = 1.0 / (Chart.this.xmax - Chart.this.xmin) * (double)w;
                double xD = Chart.this.xmin / (Chart.this.xmax - Chart.this.xmin) * (double)w;
                for (int i = 0; i < Chart.this.numberOfLines; ++i) {
                    if (Chart.this.lineColors != null && Chart.this.lineColors.length >= Chart.this.numberOfLines) {
                        g.setColor(Chart.this.lineColors[i]);
                    }
                    double x0 = hasXdata ? (double)xgap + Chart.this.xData[0] * xRatio - xD : (double)xgap;
                    double y0 = a + b * Chart.this.data[i][0];
                    for (int j = 1; j < Chart.this.numberOfPoints; ++j) {
                        double x1 = hasXdata ? (double)xgap + Chart.this.xData[j] * xRatio - xD : (double)xgap + (double)j * dw;
                        double y1 = a + b * Chart.this.data[i][j];
                        g.drawLine((int)x0, (int)y0, (int)x1, (int)y1);
                        x0 = x1;
                        y0 = y1;
                    }
                    if (Chart.this.lineLabels == null || Chart.this.lineLabels.length < Chart.this.numberOfLines) continue;
                    x0 = w + legendSpace;
                    y0 = gap + gap * i;
                    g.drawLine((int)x0, (int)y0, (int)x0 + 7, (int)y0);
                    g.drawString(Chart.this.lineLabels[i], (int)x0 + 10, (int)y0 + 3);
                }
                g.setColor(c);
                if (Chart.this.lineLabels != null && Chart.this.lineLabels.length >= Chart.this.numberOfLines) {
                    g.drawRect(w + legendSpace - 10, 10, legendSpace, 10 * gap);
                }
            } else if (Chart.this.chartStyle == 0) {
                xp = xgap;
                yp = 0.0;
                g.setColor(Color.blue);
                int barWidth = w / Chart.this.numberOfPoints;
                if (barWidth <= 0) {
                    barWidth = 1;
                }
                dw = (double)w / (double)Chart.this.numberOfPoints;
                for (int j = 0; j < Chart.this.numberOfPoints; ++j) {
                    xp = (double)xgap + (double)j * dw;
                    yp = (int)((double)h * (Chart.this.data[0][j] - Chart.this.ymin) / (Chart.this.ymax - Chart.this.ymin));
                    g.fillRect((int)xp, (int)((double)h - yp), barWidth, (int)yp);
                }
                g.setColor(c);
            }
        }
    }
}

