/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.geotools.renderer.lite.GlyphRenderer;
import org.geotools.renderer.lite.InternalTranscoder;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;

public class SVGGlyphRenderer
implements GlyphRenderer {
    private static Hashtable cache = new Hashtable(10);
    private static final List formats = Collections.unmodifiableList(Arrays.asList("image/svg"));
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.rendering");

    private Document getDocument(URL url) throws Exception {
        if (cache.contains(url)) {
            return (Document)cache.get(url);
        }
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        Document doc = f.createDocument(url.toString());
        cache.put(url, doc);
        return doc;
    }

    public boolean canRender(String format) {
        return format.toLowerCase().equals("image/svg+xml");
    }

    public List getFormats() {
        return formats;
    }

    public BufferedImage render(Graphic graphic, ExternalGraphic eg, Object feature, int height) {
        try {
            URL svgfile = eg.getLocation();
            InternalTranscoder magic = new InternalTranscoder();
            if (height > 0) {
                magic.addTranscodingHint(InternalTranscoder.KEY_HEIGHT, new Float(height));
            }
            Document inputDoc = this.getDocument(svgfile);
            magic.transcode(inputDoc);
            BufferedImage img = magic.getImage();
            return img;
        }
        catch (IOException mue) {
            LOGGER.log(Level.WARNING, "Unable to load external svg file", mue);
            return null;
        }
        catch (Exception te) {
            LOGGER.log(Level.WARNING, "Unable to load external svg file", te);
            return null;
        }
    }
}

