/*
 * Decompiled with CFR 0.152.
 */
package org.geonames;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geonames.Address;
import org.geonames.FeatureClass;
import org.geonames.Intersection;
import org.geonames.PostalCode;
import org.geonames.PostalCodeSearchCriteria;
import org.geonames.StreetSegment;
import org.geonames.Style;
import org.geonames.Timezone;
import org.geonames.Toponym;
import org.geonames.ToponymSearchCriteria;
import org.geonames.ToponymSearchResult;
import org.geonames.WikipediaArticle;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class WebService {
    private static Logger logger = Logger.getLogger("org.geonames");
    private static String USER_AGENT = "geonames-webservice-client-1.0";
    private static String geoNamesServer = "http://ws.geonames.org";
    private static String geoNamesServerFailover = "http://ws.geonames.org";
    private static long timeOfLastFailureMainServer;
    private static Style defaultStyle;
    private static String userName;
    private static String token;

    private static String addUserName(String string) {
        if (userName != null) {
            string = string + "&username=" + userName;
        }
        if (token != null) {
            string = string + "&token=" + token;
        }
        return string;
    }

    private static String addDefaultStyle(String string) {
        if (defaultStyle != Style.MEDIUM) {
            string = string + "&style=" + defaultStyle.name();
        }
        return string;
    }

    private static String getCurrentlyActiveServer() {
        if (timeOfLastFailureMainServer == 0L) {
            return geoNamesServer;
        }
        if (System.currentTimeMillis() - timeOfLastFailureMainServer > 600000L) {
            timeOfLastFailureMainServer = 0L;
            return geoNamesServer;
        }
        if (System.currentTimeMillis() < timeOfLastFailureMainServer) {
            throw new Error("time of last failure cannot be in future.");
        }
        return geoNamesServerFailover;
    }

    private static InputStream connect(String string) throws IOException {
        String string2 = WebService.getCurrentlyActiveServer();
        try {
            URLConnection uRLConnection = new URL(string2 + string).openConnection();
            uRLConnection.setRequestProperty("User-Agent", USER_AGENT);
            InputStream inputStream = uRLConnection.getInputStream();
            return inputStream;
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "problems connecting to geonames server " + geoNamesServer, iOException);
            if (geoNamesServerFailover == null || string2.equals(geoNamesServerFailover)) {
                throw iOException;
            }
            timeOfLastFailureMainServer = System.currentTimeMillis();
            logger.info("trying to connect to failover server " + geoNamesServerFailover);
            URLConnection uRLConnection = new URL(geoNamesServerFailover + string).openConnection();
            uRLConnection.setRequestProperty("User-Agent", USER_AGENT + " failover from " + geoNamesServer);
            InputStream inputStream = uRLConnection.getInputStream();
            return inputStream;
        }
    }

    private static Toponym getToponymFromElement(Element element) {
        String string;
        Toponym toponym = new Toponym();
        toponym.setName(element.getChildText("name"));
        toponym.setAlternateNames(element.getChildText("alternateNames"));
        toponym.setLatitude(Double.parseDouble(element.getChildText("lat")));
        toponym.setLongitude(Double.parseDouble(element.getChildText("lng")));
        String string2 = element.getChildText("geonameId");
        if (string2 != null) {
            toponym.setGeoNameId(Integer.parseInt(string2));
        }
        toponym.setCountryCode(element.getChildText("countryCode"));
        toponym.setCountryName(element.getChildText("countryName"));
        toponym.setFeatureClass(FeatureClass.fromValue(element.getChildText("fcl")));
        toponym.setFeatureCode(element.getChildText("fcode"));
        toponym.setFeatureClassName(element.getChildText("fclName"));
        toponym.setFeatureCodeName(element.getChildText("fCodeName"));
        String string3 = element.getChildText("population");
        if (string3 != null && !"".equals(string3)) {
            toponym.setPopulation(Integer.parseInt(string3));
        }
        if ((string = element.getChildText("elevation")) != null && !"".equals(string)) {
            toponym.setElevation(Integer.parseInt(string));
        }
        toponym.setAdminCode1(element.getChildText("adminCode1"));
        toponym.setAdminName1(element.getChildText("adminName1"));
        toponym.setAdminCode2(element.getChildText("adminCode2"));
        toponym.setAdminName2(element.getChildText("adminName2"));
        toponym.setAdminCode3(element.getChildText("adminCode3"));
        toponym.setAdminCode4(element.getChildText("adminCode4"));
        Element element2 = element.getChild("timezone");
        if (element2 != null) {
            Timezone timezone = new Timezone();
            timezone.setTimezoneId(element2.getValue());
            timezone.setDstOffset(Double.parseDouble(element2.getAttributeValue("dstOffset")));
            timezone.setGmtOffset(Double.parseDouble(element2.getAttributeValue("gmtOffset")));
            toponym.setTimezone(timezone);
        }
        return toponym;
    }

    private static WikipediaArticle getWikipediaArticleFromElement(Element element) {
        String string;
        WikipediaArticle wikipediaArticle = new WikipediaArticle();
        wikipediaArticle.setLanguage(element.getChildText("lang"));
        wikipediaArticle.setTitle(element.getChildText("title"));
        wikipediaArticle.setSummary(element.getChildText("summary"));
        wikipediaArticle.setFeature(element.getChildText("feature"));
        wikipediaArticle.setWikipediaUrl(element.getChildText("wikipediaUrl"));
        wikipediaArticle.setThumbnailImg(element.getChildText("thumbnailImg"));
        wikipediaArticle.setLatitude(Double.parseDouble(element.getChildText("lat")));
        wikipediaArticle.setLongitude(Double.parseDouble(element.getChildText("lng")));
        String string2 = element.getChildText("population");
        if (string2 != null && !"".equals(string2)) {
            wikipediaArticle.setPopulation(Integer.parseInt(string2));
        }
        if ((string = element.getChildText("altitude")) != null && !"".equals(string)) {
            wikipediaArticle.setElevation(Integer.parseInt(string));
        }
        return wikipediaArticle;
    }

    public static List<PostalCode> postalCodeSearch(String string, String string2, String string3) throws Exception {
        PostalCodeSearchCriteria postalCodeSearchCriteria = new PostalCodeSearchCriteria();
        postalCodeSearchCriteria.setPostalCode(string);
        postalCodeSearchCriteria.setPlaceName(string2);
        postalCodeSearchCriteria.setCountryCode(string3);
        return WebService.postalCodeSearch(postalCodeSearchCriteria);
    }

    public static List<PostalCode> postalCodeSearch(PostalCodeSearchCriteria postalCodeSearchCriteria) throws Exception {
        ArrayList<PostalCode> arrayList = new ArrayList<PostalCode>();
        String string = "/postalCodeSearch?";
        if (postalCodeSearchCriteria.getPostalCode() != null) {
            string = string + "postalcode=" + URLEncoder.encode(postalCodeSearchCriteria.getPostalCode(), "UTF8");
        }
        if (postalCodeSearchCriteria.getPlaceName() != null) {
            if (!string.endsWith("&")) {
                string = string + "&";
            }
            string = string + "placename=" + URLEncoder.encode(postalCodeSearchCriteria.getPlaceName(), "UTF8");
        }
        if (postalCodeSearchCriteria.getAdminCode1() != null) {
            string = string + "&adminCode1=" + URLEncoder.encode(postalCodeSearchCriteria.getAdminCode1(), "UTF8");
        }
        if (postalCodeSearchCriteria.getCountryCode() != null) {
            if (!string.endsWith("&")) {
                string = string + "&";
            }
            string = string + "country=" + postalCodeSearchCriteria.getCountryCode();
        }
        if (postalCodeSearchCriteria.getCountryBias() != null) {
            if (!string.endsWith("&")) {
                string = string + "&";
            }
            string = string + "countryBias=" + postalCodeSearchCriteria.getCountryBias();
        }
        if (postalCodeSearchCriteria.getMaxRows() > 0) {
            string = string + "&maxRows=" + postalCodeSearchCriteria.getMaxRows();
        }
        if (postalCodeSearchCriteria.getStartRow() > 0) {
            string = string + "&startRow=" + postalCodeSearchCriteria.getStartRow();
        }
        if (postalCodeSearchCriteria.isOROperator()) {
            string = string + "&operator=OR";
        }
        string = WebService.addUserName(string);
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(WebService.connect(string));
        Element element = document.getRootElement();
        for (Object e : element.getChildren("code")) {
            Element element2 = (Element)e;
            PostalCode postalCode = new PostalCode();
            postalCode.setPostalCode(element2.getChildText("postalcode"));
            postalCode.setPlaceName(element2.getChildText("name"));
            postalCode.setCountryCode(element2.getChildText("countryCode"));
            postalCode.setAdminCode1(element2.getChildText("adminCode1"));
            postalCode.setAdminCode2(element2.getChildText("adminCode2"));
            postalCode.setAdminName1(element2.getChildText("adminName1"));
            postalCode.setAdminName2(element2.getChildText("adminName2"));
            postalCode.setLatitude(Double.parseDouble(element2.getChildText("lat")));
            postalCode.setLongitude(Double.parseDouble(element2.getChildText("lng")));
            arrayList.add(postalCode);
        }
        return arrayList;
    }

    public static List<PostalCode> findNearbyPostalCodes(PostalCodeSearchCriteria postalCodeSearchCriteria) throws Exception {
        ArrayList<PostalCode> arrayList = new ArrayList<PostalCode>();
        String string = "/findNearbyPostalCodes?";
        if (postalCodeSearchCriteria.getPostalCode() != null) {
            string = string + "&postalcode=" + URLEncoder.encode(postalCodeSearchCriteria.getPostalCode(), "UTF8");
        }
        if (postalCodeSearchCriteria.getPlaceName() != null) {
            string = string + "&placename=" + URLEncoder.encode(postalCodeSearchCriteria.getPlaceName(), "UTF8");
        }
        if (postalCodeSearchCriteria.getCountryCode() != null) {
            string = string + "&country=" + postalCodeSearchCriteria.getCountryCode();
        }
        if (postalCodeSearchCriteria.getLatitude() != null) {
            string = string + "&lat=" + postalCodeSearchCriteria.getLatitude();
        }
        if (postalCodeSearchCriteria.getLongitude() != null) {
            string = string + "&lng=" + postalCodeSearchCriteria.getLongitude();
        }
        if (postalCodeSearchCriteria.getStyle() != null) {
            string = string + "&style=" + (Object)((Object)postalCodeSearchCriteria.getStyle());
        }
        if (postalCodeSearchCriteria.getMaxRows() > 0) {
            string = string + "&maxRows=" + postalCodeSearchCriteria.getMaxRows();
        }
        if (postalCodeSearchCriteria.getRadius() > 0.0) {
            string = string + "&radius=" + postalCodeSearchCriteria.getRadius();
        }
        string = WebService.addUserName(string);
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(WebService.connect(string));
        Element element = document.getRootElement();
        for (Object e : element.getChildren("code")) {
            Element element2 = (Element)e;
            PostalCode postalCode = new PostalCode();
            postalCode.setPostalCode(element2.getChildText("postalcode"));
            postalCode.setPlaceName(element2.getChildText("name"));
            postalCode.setCountryCode(element2.getChildText("countryCode"));
            postalCode.setLatitude(Double.parseDouble(element2.getChildText("lat")));
            postalCode.setLongitude(Double.parseDouble(element2.getChildText("lng")));
            postalCode.setAdminName1(element2.getChildText("adminName1"));
            postalCode.setAdminCode1(element2.getChildText("adminCode1"));
            postalCode.setAdminName2(element2.getChildText("adminName2"));
            postalCode.setAdminCode2(element2.getChildText("adminCode2"));
            if (element2.getChildText("distance") != null) {
                postalCode.setDistance(Double.parseDouble(element2.getChildText("distance")));
            }
            arrayList.add(postalCode);
        }
        return arrayList;
    }

    public static List<Toponym> findNearbyPlaceName(double d, double d2) throws IOException, Exception {
        return WebService.findNearbyPlaceName(d, d2, 0.0, 0);
    }

    public static List<Toponym> findNearbyPlaceName(double d, double d2, double d3, int n) throws IOException, Exception {
        ArrayList<Toponym> arrayList = new ArrayList<Toponym>();
        String string = "/findNearbyPlaceName?";
        string = string + "&lat=" + d;
        string = string + "&lng=" + d2;
        if (d3 > 0.0) {
            string = string + "&radius=" + d3;
        }
        if (n > 0) {
            string = string + "&maxRows=" + n;
        }
        string = WebService.addUserName(string);
        string = WebService.addDefaultStyle(string);
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(WebService.connect(string));
        Element element = document.getRootElement();
        for (Object e : element.getChildren("geoname")) {
            Element element2 = (Element)e;
            Toponym toponym = WebService.getToponymFromElement(element2);
            arrayList.add(toponym);
        }
        return arrayList;
    }

    public static Address findNearestAddress(double d, double d2) throws IOException, Exception {
        String string = "/findNearestAddress?";
        string = string + "&lat=" + d;
        string = string + "&lng=" + d2;
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(WebService.connect(string = WebService.addUserName(string)));
        Element element = document.getRootElement();
        Iterator iterator = element.getChildren("address").iterator();
        if (iterator.hasNext()) {
            Object e = iterator.next();
            Element element2 = (Element)e;
            Address address = new Address();
            address.setStreet(element2.getChildText("street"));
            address.setStreetNumber(element2.getChildText("streetNumber"));
            address.setPostalCode(element2.getChildText("postalcode"));
            address.setPlaceName(element2.getChildText("placename"));
            address.setCountryCode(element2.getChildText("countryCode"));
            address.setLatitude(Double.parseDouble(element2.getChildText("lat")));
            address.setLongitude(Double.parseDouble(element2.getChildText("lng")));
            address.setAdminName1(element2.getChildText("adminName1"));
            address.setAdminCode1(element2.getChildText("adminCode1"));
            address.setAdminName2(element2.getChildText("adminName2"));
            address.setAdminCode2(element2.getChildText("adminCode2"));
            address.setDistance(Double.parseDouble(element2.getChildText("distance")));
            return address;
        }
        return null;
    }

    public static Intersection findNearestIntersection(double d, double d2) throws Exception {
        return WebService.findNearestIntersection(d, d2, 0.0);
    }

    public static Intersection findNearestIntersection(double d, double d2, double d3) throws Exception {
        SAXBuilder sAXBuilder;
        Document document;
        Element element;
        Iterator iterator;
        String string = "/findNearestIntersection?";
        string = string + "&lat=" + d;
        string = string + "&lng=" + d2;
        if (d3 > 0.0) {
            string = string + "&radius=" + d3;
        }
        if ((iterator = (element = (document = (sAXBuilder = new SAXBuilder()).build(WebService.connect(string = WebService.addUserName(string)))).getRootElement()).getChildren("intersection").iterator()).hasNext()) {
            Object e = iterator.next();
            Element element2 = (Element)e;
            Intersection intersection = new Intersection();
            intersection.setStreet1(element2.getChildText("street1"));
            intersection.setStreet2(element2.getChildText("street2"));
            intersection.setLatitude(Double.parseDouble(element2.getChildText("lat")));
            intersection.setLongitude(Double.parseDouble(element2.getChildText("lng")));
            intersection.setDistance(Double.parseDouble(element2.getChildText("distance")));
            intersection.setPostalCode(element2.getChildText("postalcode"));
            intersection.setPlaceName(element2.getChildText("placename"));
            intersection.setCountryCode(element2.getChildText("countryCode"));
            intersection.setAdminName2(element2.getChildText("adminName2"));
            intersection.setAdminCode1(element2.getChildText("adminCode1"));
            intersection.setAdminName1(element2.getChildText("adminName1"));
            return intersection;
        }
        return null;
    }

    public static List<StreetSegment> findNearbyStreets(double d, double d2, double d3) throws Exception {
        String string = "/findNearbyStreets?";
        string = string + "&lat=" + d;
        string = string + "&lng=" + d2;
        if (d3 > 0.0) {
            string = string + "&radius=" + d3;
        }
        string = WebService.addUserName(string);
        ArrayList<StreetSegment> arrayList = new ArrayList<StreetSegment>();
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(WebService.connect(string));
        Element element = document.getRootElement();
        for (Object e : element.getChildren("streetSegment")) {
            Element element2 = (Element)e;
            StreetSegment streetSegment = new StreetSegment();
            String string2 = element2.getChildText("line");
            String[] stringArray = string2.split(",");
            double[] dArray = new double[stringArray.length];
            double[] dArray2 = new double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(" ");
                dArray2[i] = Double.parseDouble(stringArray2[0]);
                dArray[i] = Double.parseDouble(stringArray2[1]);
            }
            streetSegment.setCfcc(element2.getChildText("cfcc"));
            streetSegment.setName(element2.getChildText("name"));
            streetSegment.setFraddl(element2.getChildText("fraddl"));
            streetSegment.setFraddr(element2.getChildText("fraddr"));
            streetSegment.setToaddl(element2.getChildText("toaddl"));
            streetSegment.setToaddr(element2.getChildText("toaddr"));
            streetSegment.setPostalCode(element2.getChildText("postalcode"));
            streetSegment.setPlaceName(element2.getChildText("placename"));
            streetSegment.setCountryCode(element2.getChildText("countryCode"));
            streetSegment.setAdminName2(element2.getChildText("adminName2"));
            streetSegment.setAdminCode1(element2.getChildText("adminCode1"));
            streetSegment.setAdminName1(element2.getChildText("adminName1"));
            arrayList.add(streetSegment);
        }
        return arrayList;
    }

    public static ToponymSearchResult search(String string, String string2, String string3, String[] stringArray, int n) throws Exception {
        return WebService.search(string, string2, string3, stringArray, n, null, null, null);
    }

    public static ToponymSearchResult search(String string, String string2, String string3, String[] stringArray, int n, String string4, Style style, String string5) throws Exception {
        ToponymSearchCriteria toponymSearchCriteria = new ToponymSearchCriteria();
        toponymSearchCriteria.setQ(string);
        toponymSearchCriteria.setCountryCode(string2);
        toponymSearchCriteria.setName(string3);
        toponymSearchCriteria.setFeatureCodes(stringArray);
        toponymSearchCriteria.setStartRow(n);
        toponymSearchCriteria.setLanguage(string4);
        toponymSearchCriteria.setStyle(style);
        toponymSearchCriteria.setNameEquals(string5);
        return WebService.search(toponymSearchCriteria);
    }

    public static ToponymSearchResult search(ToponymSearchCriteria toponymSearchCriteria) throws Exception {
        ToponymSearchResult toponymSearchResult = new ToponymSearchResult();
        String string = "/search?";
        if (toponymSearchCriteria.getQ() != null) {
            string = string + "q=" + URLEncoder.encode(toponymSearchCriteria.getQ(), "UTF8");
        }
        if (toponymSearchCriteria.getNameEquals() != null) {
            string = string + "&name_equals=" + URLEncoder.encode(toponymSearchCriteria.getNameEquals(), "UTF8");
        }
        if (toponymSearchCriteria.getNameStartsWith() != null) {
            string = string + "&name_startsWith=" + URLEncoder.encode(toponymSearchCriteria.getNameStartsWith(), "UTF8");
        }
        if (toponymSearchCriteria.getName() != null) {
            string = string + "&name=" + URLEncoder.encode(toponymSearchCriteria.getName(), "UTF8");
        }
        if (toponymSearchCriteria.getTag() != null) {
            string = string + "&tag=" + URLEncoder.encode(toponymSearchCriteria.getTag(), "UTF8");
        }
        if (toponymSearchCriteria.getCountryCode() != null) {
            string = string + "&country=" + toponymSearchCriteria.getCountryCode();
        }
        if (toponymSearchCriteria.getAdminCode1() != null) {
            string = string + "&adminCode1=" + URLEncoder.encode(toponymSearchCriteria.getAdminCode1(), "UTF8");
        }
        if (toponymSearchCriteria.getAdminCode2() != null) {
            string = string + "&adminCode2=" + URLEncoder.encode(toponymSearchCriteria.getAdminCode2(), "UTF8");
        }
        if (toponymSearchCriteria.getAdminCode3() != null) {
            string = string + "&adminCode3=" + URLEncoder.encode(toponymSearchCriteria.getAdminCode3(), "UTF8");
        }
        if (toponymSearchCriteria.getAdminCode4() != null) {
            string = string + "&adminCode4=" + URLEncoder.encode(toponymSearchCriteria.getAdminCode4(), "UTF8");
        }
        if (toponymSearchCriteria.getLanguage() != null) {
            string = string + "&lang=" + toponymSearchCriteria.getLanguage();
        }
        if (toponymSearchCriteria.getFeatureClass() != null) {
            string = string + "&featureClass=" + (Object)((Object)toponymSearchCriteria.getFeatureClass());
        }
        if (toponymSearchCriteria.getFeatureCodes() != null) {
            for (Object object : toponymSearchCriteria.getFeatureCodes()) {
                string = string + "&fcode=" + (String)object;
            }
        }
        if (toponymSearchCriteria.getMaxRows() > 0) {
            string = string + "&maxRows=" + toponymSearchCriteria.getMaxRows();
        }
        if (toponymSearchCriteria.getStartRow() > 0) {
            string = string + "&startRow=" + toponymSearchCriteria.getStartRow();
        }
        string = toponymSearchCriteria.getStyle() != null ? string + "&style=" + (Object)((Object)toponymSearchCriteria.getStyle()) : WebService.addDefaultStyle(string);
        string = WebService.addUserName(string);
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(WebService.connect(string));
        Element element = document.getRootElement();
        WebService.checkException(element);
        toponymSearchResult.totalResultsCount = Integer.parseInt(element.getChildText("totalResultsCount"));
        toponymSearchResult.setStyle(Style.valueOf(element.getAttributeValue("style")));
        for (Object e : element.getChildren("geoname")) {
            Element element2 = (Element)e;
            Toponym toponym = WebService.getToponymFromElement(element2);
            toponym.setStyle(toponymSearchResult.getStyle());
            toponymSearchResult.toponyms.add(toponym);
        }
        return toponymSearchResult;
    }

    public static ToponymSearchResult children(int n, String string, Style style) throws Exception {
        ToponymSearchResult toponymSearchResult = new ToponymSearchResult();
        String string2 = "/children?";
        string2 = string2 + "geonameId=" + n;
        if (string != null) {
            string2 = string2 + "&lang=" + string;
        }
        string2 = style != null ? string2 + "&style=" + (Object)((Object)style) : WebService.addDefaultStyle(string2);
        string2 = WebService.addUserName(string2);
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(WebService.connect(string2));
        Element element = document.getRootElement();
        WebService.checkException(element);
        toponymSearchResult.totalResultsCount = Integer.parseInt(element.getChildText("totalResultsCount"));
        toponymSearchResult.setStyle(Style.valueOf(element.getAttributeValue("style")));
        for (Object e : element.getChildren("geoname")) {
            Element element2 = (Element)e;
            Toponym toponym = WebService.getToponymFromElement(element2);
            toponymSearchResult.toponyms.add(toponym);
        }
        return toponymSearchResult;
    }

    public static ToponymSearchResult neighbours(int n, String string, Style style) throws Exception {
        ToponymSearchResult toponymSearchResult = new ToponymSearchResult();
        String string2 = "/neighbours?";
        string2 = string2 + "geonameId=" + n;
        if (string != null) {
            string2 = string2 + "&lang=" + string;
        }
        string2 = style != null ? string2 + "&style=" + (Object)((Object)style) : WebService.addDefaultStyle(string2);
        string2 = WebService.addUserName(string2);
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(WebService.connect(string2));
        Element element = document.getRootElement();
        WebService.checkException(element);
        toponymSearchResult.totalResultsCount = Integer.parseInt(element.getChildText("totalResultsCount"));
        toponymSearchResult.setStyle(Style.valueOf(element.getAttributeValue("style")));
        for (Object e : element.getChildren("geoname")) {
            Element element2 = (Element)e;
            Toponym toponym = WebService.getToponymFromElement(element2);
            toponymSearchResult.toponyms.add(toponym);
        }
        return toponymSearchResult;
    }

    public static void saveTags(String[] sAXBuilder, Toponym toponym, String string, String string2) throws Exception {
        if (toponym.getGeoNameId() == 0) {
            throw new Error("no geonameid specified");
        }
        String string3 = "/servlet/geonames?srv=61";
        string3 = string3 + "&geonameId=" + toponym.getGeoNameId();
        string3 = WebService.addUserName(string3);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string4 : sAXBuilder) {
            stringBuilder.append(string4 + ",");
        }
        string3 = string3 + "&tag=" + stringBuilder;
        SAXBuilder sAXBuilder2 = new SAXBuilder();
        Document document = sAXBuilder2.build(WebService.connect(string3));
        Element element = document.getRootElement();
        WebService.checkException(element);
    }

    private static void checkException(Element element) throws Exception {
        Element element2 = element.getChild("status");
        if (element2 != null) {
            throw new Exception(element2.getAttributeValue("message"));
        }
    }

    public static List<WikipediaArticle> wikipediaSearch(String string, String string2) throws Exception {
        ArrayList<WikipediaArticle> arrayList = new ArrayList<WikipediaArticle>();
        String string3 = "/wikipediaSearch?";
        string3 = string3 + "q=" + URLEncoder.encode(string, "UTF8");
        if (string2 != null) {
            string3 = string3 + "&lang=" + string2;
        }
        string3 = WebService.addUserName(string3);
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(WebService.connect(string3));
        Element element = document.getRootElement();
        for (Object e : element.getChildren("entry")) {
            Element element2 = (Element)e;
            WikipediaArticle wikipediaArticle = WebService.getWikipediaArticleFromElement(element2);
            arrayList.add(wikipediaArticle);
        }
        return arrayList;
    }

    public static List<WikipediaArticle> findNearbyWikipedia(double d, double d2, String string) throws Exception {
        ArrayList<WikipediaArticle> arrayList = new ArrayList<WikipediaArticle>();
        String string2 = "/findNearbyWikipedia?";
        string2 = string2 + "lat=" + d;
        string2 = string2 + "&lng=" + d2;
        if (string != null) {
            string2 = string2 + "&lang=" + string;
        }
        string2 = WebService.addUserName(string2);
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(WebService.connect(string2));
        Element element = document.getRootElement();
        for (Object e : element.getChildren("entry")) {
            Element element2 = (Element)e;
            WikipediaArticle wikipediaArticle = WebService.getWikipediaArticleFromElement(element2);
            arrayList.add(wikipediaArticle);
        }
        return arrayList;
    }

    public static int gtopo30(double d, double d2) throws IOException {
        String string = "/gtopo30?lat=" + d + "&lng=" + d2;
        string = WebService.addUserName(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(WebService.connect(string)));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        return Integer.parseInt(string2);
    }

    public static int srtm3(double d, double d2) throws IOException {
        String string = "/srtm3?lat=" + d + "&lng=" + d2;
        string = WebService.addUserName(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(WebService.connect(string)));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        return Integer.parseInt(string2);
    }

    public static String countryCode(double d, double d2) throws IOException {
        String string = "/countrycode?lat=" + d + "&lng=" + d2;
        string = WebService.addUserName(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(WebService.connect(string)));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        return string2;
    }

    public static Timezone timezone(double d, double d2) throws IOException, Exception {
        String string = "/timezone?";
        string = string + "&lat=" + d;
        string = string + "&lng=" + d2;
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(WebService.connect(string = WebService.addUserName(string)));
        Element element = document.getRootElement();
        Iterator iterator = element.getChildren("timezone").iterator();
        if (iterator.hasNext()) {
            Object e = iterator.next();
            Element element2 = (Element)e;
            Timezone timezone = new Timezone();
            timezone.setTimezoneId(element2.getChildText("timezoneId"));
            timezone.setGmtOffset(Double.parseDouble(element2.getChildText("gmtOffset")));
            timezone.setDstOffset(Double.parseDouble(element2.getChildText("dstOffset")));
            return timezone;
        }
        return null;
    }

    public static String getGeoNamesServer() {
        return geoNamesServer;
    }

    public static String getGeoNamesServerFailover() {
        return geoNamesServerFailover;
    }

    public static void setGeoNamesServer(String string) {
        if (string == null) {
            throw new Error();
        }
        if (!(string = string.trim().toLowerCase()).startsWith("http://")) {
            string = "http://" + string;
        }
        geoNamesServer = string;
    }

    public static void setGeoNamesServerFailover(String string) {
        if (string != null && !(string = string.trim().toLowerCase()).startsWith("http://")) {
            string = "http://" + string;
        }
        geoNamesServerFailover = string;
    }

    public static String getUserName() {
        return userName;
    }

    public static void setUserName(String string) {
        userName = string;
    }

    public static String getToken() {
        return token;
    }

    public static void setToken(String string) {
        token = string;
    }

    public static Style getDefaultStyle() {
        return defaultStyle;
    }

    public static void setDefaultStyle(Style style) {
        defaultStyle = style;
    }

    static {
        defaultStyle = Style.MEDIUM;
    }
}

